/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.taskplanner;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DataEntry;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.DrivePermission;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.lib.util.EncodingFunctions;
import com.inet.permissions.Permission;
import com.inet.taskplanner.server.api.action.ResultActionHelper;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.fileservice.FileServiceForTaskPlanner;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class c
implements FileServiceForTaskPlanner {
    @Nonnull
    public String getExtensionName() {
        return "drive";
    }

    @Nullable
    public Permission getRequiredPermission() {
        return DrivePermission.DRIVE_PERMISSION;
    }

    @Nullable
    public InputStream readFile(@Nonnull String path) throws IOException {
        String string = this.V(path);
        DriveEntry driveEntry = Drive.getInstance().resolve(string);
        if (driveEntry == null) {
            return null;
        }
        Content content = driveEntry.getFeature(DriveEntry.CONTENT);
        if (content == null) {
            return null;
        }
        return content.getInputStream();
    }

    public void validateFilePath(@Nonnull String file) throws ValidationException {
    }

    public void validateDirPath(@Nonnull String directory) throws ValidationException {
    }

    public void saveFile(@Nonnull String fileName, @Nonnull String fileNameFormat, @Nonnull String destination, @Nonnull InputStream inputStream, @Nullable Map<String, String> extraMetaData) throws IOException {
        ResultActionHelper resultActionHelper = new ResultActionHelper();
        String string = resultActionHelper.resolveFilenamePlaceholder(fileName, fileNameFormat, extraMetaData);
        String string2 = this.V(destination);
        String string3 = resultActionHelper.resolvePlaceholder(fileName, string2);
        DriveEntry driveEntry = Drive.getInstance().resolve(string3 + string);
        if (driveEntry == null || driveEntry.hasFeature(DriveEntry.FOLDER) || driveEntry.hasFeature(DriveEntry.MOUNT)) {
            Object object;
            int n2;
            driveEntry = Drive.getInstance().resolve(string3);
            if (driveEntry == null || driveEntry.hasFeature(DriveEntry.MOUNT)) {
                try {
                    driveEntry = DriveUtils.getOrCreateChild(Drive.getInstance(), string3);
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    throw new RuntimeException(DrivePlugin.MSG_SERVER.getMsg("drive.taskplanner.fileservice.foldernotfound", new Object[]{string3}));
                }
            }
            if ((n2 = string.lastIndexOf(47)) > 0 && string.length() > n2 + 1) {
                object = string.substring(0, n2);
                string = string.substring(n2 + 1);
                try {
                    driveEntry = DriveUtils.getOrCreateFolder(driveEntry, (String)object);
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    throw new RuntimeException(DrivePlugin.MSG_SERVER.getMsg("drive.taskplanner.fileservice.foldernotfound", new Object[]{string3}));
                }
            }
            Object object2 = object = driveEntry == null ? null : driveEntry.getFeature(DriveEntry.FOLDER);
            if (object == null) {
                throw new RuntimeException(DrivePlugin.MSG_SERVER.getMsg("drive.taskplanner.fileservice.foldernotfound", new Object[]{string3}));
            }
            DriveEntry driveEntry2 = object.createChild(new DataEntry(string, inputStream));
            this.c(driveEntry2, string);
        } else {
            driveEntry.getFeature(DriveEntry.CONTENT).setInputStream(inputStream, null);
            this.c(driveEntry, string);
        }
    }

    private void c(DriveEntry driveEntry, String string) {
        try {
            driveEntry.runFeature(MetaData.class, metaData -> metaData.setMetaData(MetaData.TITLE, string));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteOldFiles(@Nonnull String fileName, @Nonnull String fileNameFormat, @Nonnull String destination, long deleteOldTime) throws IOException {
        if (deleteOldTime == 0L) {
            return;
        }
        if (fileName.indexOf(47) >= 0) {
            return;
        }
        String string = this.V(destination);
        DriveEntry driveEntry = Drive.getInstance().resolve(string);
        if (driveEntry == null) {
            return;
        }
        Folder folder = driveEntry.getFeature(DriveEntry.FOLDER);
        if (folder == null) {
            return;
        }
        ResultActionHelper resultActionHelper = new ResultActionHelper(){

            public String getCurrentDate() {
                return "*";
            }

            public String getCurrentTime() {
                return "*";
            }
        };
        String string2 = resultActionHelper.resolvePlaceholder(fileName, ResultActionHelper.normalize((Object)string));
        if (string2.contains("*")) {
            return;
        }
        final String string3 = "\\E.*?\\Q";
        resultActionHelper = new ResultActionHelper(){

            public String getCurrentDate() {
                return string3;
            }

            public String getCurrentTime() {
                return string3;
            }
        };
        String string4 = "^\\Q" + resultActionHelper.resolveFilenamePlaceholder(fileName, fileNameFormat, null) + "\\E$";
        for (DriveEntry driveEntry2 : folder.getChildren()) {
            if (!driveEntry2.getName().matches(string4) || driveEntry2.getLastModified() >= deleteOldTime) continue;
            try {
                driveEntry2.delete(null);
            }
            catch (Exception exception) {
                DrivePlugin.LOGGER.debug((Object)("An error occurred while deleting a file: " + driveEntry2.getPath()));
                DrivePlugin.LOGGER.debug((Object)exception);
            }
        }
    }

    private String V(@Nonnull String string) {
        Object object = string;
        if (((String)object).startsWith("drive:")) {
            object = ((String)object).substring(6);
        }
        if (!((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        if (((String)object).startsWith("/~/")) {
            object = "/Home" + ((String)object).substring(2);
        }
        object = EncodingFunctions.decodeUrlParameter((String)object);
        while (((String)object).contains("//")) {
            object = ((String)object).replace("//", "/");
        }
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        return object;
    }
}

