/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.persistence;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.drive.server.persistence.c;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.image.PreviewGenerator;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadPool;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class q
implements Thumbnail {
    @Nonnull
    private c dV;
    private static byte @Nonnull [] fq = "NO_PREVIEW".getBytes();
    private static byte @Nonnull [] fr = "HASPREVIEW".getBytes();
    private static byte @Nonnull [] fs = "REFRESHREQ".getBytes();
    private boolean ft;
    private boolean fu = true;
    private a fv;
    private Set<Thumbnail.Size> fw = Collections.synchronizedSet(new HashSet());

    public q(@Nonnull c c2) {
        this.dV = c2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public InputStream getThumbnail(@Nonnull Thumbnail.Size size) throws IOException {
        Object object;
        this.dV.aj();
        if (this.fv != null) {
            object = new a(this.dV);
            if (((a)object).equals(this.fv)) {
                return null;
            }
            this.fv = null;
        }
        object = this.b(size);
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve((String)object);
        boolean bl = persistenceEntry.exists();
        if (!bl) return this.a(size);
        this.ft = true;
        if (persistenceEntry.size() > 0L) {
            this.fu = false;
            InputStream inputStream = null;
            try {
                inputStream = persistenceEntry.getInputStream();
                if (inputStream == null) {
                    return null;
                }
                inputStream.mark(fr.length);
                byte[] byArray = inputStream.readNBytes(fr.length);
                if (Arrays.equals(fr, byArray)) {
                    return inputStream;
                }
                if (Arrays.equals(fq, byArray)) {
                    inputStream.close();
                    return null;
                }
                if (Arrays.equals(fs, byArray)) {
                    inputStream.close();
                    return this.a(size);
                }
                inputStream.reset();
                return inputStream;
            }
            catch (Exception exception) {
                if (inputStream == null) return this.a(size);
                inputStream.close();
                return this.a(size);
            }
        } else {
            this.fu = true;
            return this.dV.executeFeature(Content.class, Content::getInputStream, () -> null);
        }
    }

    private InputStream a(@Nonnull Thumbnail.Size size) {
        List<DriveFileTypeHandler> list = DriveUtils.getDriveTypeHandler();
        if (this.dV.executeFeature(Content.class, Content::getSize, this.dV.hasFeature(Content.class) ? 0L : 1L) == 0L) {
            return null;
        }
        for (DriveFileTypeHandler driveFileTypeHandler : list) {
            if (!driveFileTypeHandler.acceptFileTyp(this.dV, DriveFileTypeHandler.FEATURE.thumbnail)) continue;
            try {
                if (driveFileTypeHandler.thumbnailNeedCache(this.dV)) {
                    if (this.fw.contains((Object)size)) {
                        return null;
                    }
                    a a2 = new a(this.dV);
                    this.fw.add(size);
                    ThreadPool.DEFAULT.startSubThread(() -> {
                        try {
                            PreviewGenerator.ImagePreview imagePreview = driveFileTypeHandler.getThumbnail(this.dV, size, false);
                            this.a(imagePreview, size);
                        }
                        catch (Throwable throwable) {
                            a a3 = new a(this.dV);
                            if (a3.equals(a2)) {
                                this.fv = a3;
                                DrivePlugin.LOGGER.warn((Object)throwable);
                            }
                            this.dV.C().notifyObservers(DriveObserver.EventType.THUMBNAIL, new DriveObserver.EventType.ThumbnailEvent(this.dV, size));
                        }
                        finally {
                            this.fw.remove((Object)size);
                        }
                    }, (RunnableSession)new BaseRunnableSession(UserManager.PRIVILEGED_ACCOUNT_ID));
                    return Thumbnail.WILL_RENDER_ASYNC;
                }
                return driveFileTypeHandler.getAdhocThumbnail(this.dV, size, false);
            }
            catch (Throwable throwable) {
                DrivePlugin.LOGGER.warn("Create thumbnail", (Object)throwable);
            }
        }
        return null;
    }

    @Nonnull
    private String b(Thumbnail.Size size) {
        return this.dV.aT() + ".thumbnail-" + size.name();
    }

    @Override
    public long getThumbnailTimestamp(@Nonnull Thumbnail.Size size) {
        String string = this.b(size);
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve(string);
        if (persistenceEntry.exists()) {
            return persistenceEntry.lastModified();
        }
        if (this.fv != null) {
            return 1L;
        }
        if (this.fu && this.ft) {
            return this.dV.getLastModified();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PreviewGenerator.ImagePreview imagePreview, @Nonnull Thumbnail.Size size) {
        block22: {
            String string = this.b(size);
            PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve(string);
            try (ServerLock serverLock = Persistence.getRecoveryEnabledInstance().getWriteLock(string, 2000L);){
                if (imagePreview == null) {
                    persistenceEntry.setBytes(fq);
                    return;
                }
                if (imagePreview.hasPreviewImage()) {
                    try (OutputStream outputStream = persistenceEntry.getOutputStream();){
                        outputStream.write(fr);
                        imagePreview.writeTo(outputStream);
                        break block22;
                    }
                    catch (IOException iOException) {
                        DrivePlugin.LOGGER.debug((Object)iOException);
                        this.fv = new a(this.dV);
                        if (serverLock != null) {
                            serverLock.close();
                        }
                        return;
                    }
                    finally {
                        this.ft = true;
                    }
                }
                persistenceEntry.setBytes(new byte[0]);
            }
        }
        this.dV.C().notifyObservers(DriveObserver.EventType.THUMBNAIL, new DriveObserver.EventType.ThumbnailEvent(this.dV, size));
    }

    @Override
    public void resetThumbnails(Thumbnail.Size ... sizes) {
        Thumbnail.Size[] sizeArray = sizes;
        if (sizeArray == null || sizeArray.length == 0) {
            sizeArray = Thumbnail.Size.values();
        }
        for (Thumbnail.Size size : sizeArray) {
            String string = this.b(size);
            PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve(string);
            if (!persistenceEntry.exists()) continue;
            persistenceEntry.setBytes(fs);
        }
        this.fv = null;
        this.dV.C().notifyObservers(DriveObserver.EventType.THUMBNAIL, new DriveObserver.EventType.ThumbnailEvent(this.dV, sizes != null && sizes.length > 0 ? sizes[0] : null));
    }

    private class a {
        private long size;
        private long fx;

        public a(DriveEntry driveEntry) {
            this.size = driveEntry.executeFeature(Content.class, content -> content.getSize(), -1L);
            @Nullable Long l2 = driveEntry.getMetaData(MetaData.MODIFIED);
            this.fx = l2 != null ? l2 : -1L;
        }

        public int hashCode() {
            return 31 + Objects.hash(this.fx, this.size);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof a)) {
                return false;
            }
            a a2 = (a)obj;
            return this.fx == a2.fx && this.size == a2.size;
        }
    }
}

