/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api.feature;

import com.inet.annotations.JsonData;
import com.inet.drive.api.DriveIDUtils;
import com.inet.id.GUID;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class ShareData {
    private String id;
    private String driveEntryID;
    private Map<@Nonnull GUID, Set<String>> userPermissions = new HashMap<GUID, Set<String>>();
    private Map<@Nonnull GUID, Set<String>> groupPermissions = new HashMap<GUID, Set<String>>();

    private ShareData() {
    }

    public ShareData(@Nonnull String entryID) {
        this.driveEntryID = entryID;
        this.id = DriveIDUtils.generateShareID();
    }

    public ShareData(@Nonnull ShareData shareData) {
        this.driveEntryID = shareData.getDriveEntryID();
        this.id = shareData.getId();
        this.groupPermissions = this.cleanup(new HashMap<GUID, Set<String>>(shareData.getPermissions(true)));
        this.userPermissions = this.cleanup(new HashMap<GUID, Set<String>>(shareData.getPermissions(false)));
    }

    public ShareData(@Nonnull ShareData shareData, @Nonnull String oldID) {
        this.driveEntryID = shareData.getDriveEntryID();
        this.id = oldID;
        this.groupPermissions = this.cleanup(new HashMap<GUID, Set<String>>(shareData.getPermissions(true)));
        this.userPermissions = this.cleanup(new HashMap<GUID, Set<String>>(shareData.getPermissions(false)));
    }

    private Map<@Nonnull GUID, Set<String>> cleanup(Map<@Nonnull GUID, Set<String>> permissions) {
        HashMap<@Nonnull GUID, Set<String>> hashMap = new HashMap<GUID, Set<String>>();
        Set<@Nonnull GUID> set = permissions.keySet();
        for (GUID gUID : set) {
            Set<String> set2 = permissions.get(gUID);
            if (set2 == null || set2.isEmpty()) continue;
            hashMap.put(gUID, set2);
        }
        return hashMap;
    }

    @Nonnull
    public String getDriveEntryID() {
        return this.driveEntryID;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public final boolean equals(@Nullable Object o2) {
        if (!(o2 instanceof ShareData)) {
            return false;
        }
        ShareData shareData = (ShareData)o2;
        return Objects.equals(this.id, shareData.id) && Objects.equals(this.driveEntryID, shareData.driveEntryID) && this.equalsPermissions(this.userPermissions, shareData.userPermissions) && this.equalsPermissions(this.groupPermissions, shareData.groupPermissions);
    }

    private boolean equalsPermissions(Map<GUID, Set<String>> a2, Map<GUID, Set<String>> b2) {
        return Objects.equals(a2, b2) || a2 != null && b2 != null && a2.size() == b2.size() && a2.entrySet().stream().allMatch(e2 -> Objects.equals(e2.getValue(), b2.get(e2.getKey())));
    }

    public int hashCode() {
        int n2 = this.id.hashCode();
        n2 = 31 * n2 + this.driveEntryID.hashCode();
        n2 = 31 * n2 + this.userPermissions.hashCode();
        n2 = 31 * n2 + this.groupPermissions.hashCode();
        return n2;
    }

    public void addPermissions(@Nonnull GUID userOrGroupId, boolean isGroup, String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            return;
        }
        Map<@Nonnull GUID, Set<String>> map = isGroup ? this.groupPermissions : this.userPermissions;
        map.computeIfAbsent(userOrGroupId, k2 -> new HashSet()).addAll(Arrays.asList(permissions));
    }

    public void removePermission(@Nonnull GUID userOrGroupId, boolean isGroup, String ... permissionTypes) {
        Map<GUID, Set<String>> map;
        Map<GUID, Set<String>> map2 = map = isGroup ? this.groupPermissions : this.userPermissions;
        if (map == null) {
            return;
        }
        for (String string : permissionTypes) {
            Set<String> set = map.get(userOrGroupId);
            if (set == null) continue;
            set.remove(string);
            if (!set.isEmpty()) continue;
            map.remove(userOrGroupId);
        }
    }

    public void setPermissions(boolean isGroup, @Nonnull @Nonnull Map<@Nonnull GUID, Set<String>> permissions) {
        if (isGroup) {
            this.groupPermissions = this.cleanup(permissions);
        } else {
            this.userPermissions = this.cleanup(permissions);
        }
    }

    public boolean hasPermissions() {
        Set<String> set;
        if (this.groupPermissions != null) {
            for (GUID gUID : this.groupPermissions.keySet()) {
                set = this.groupPermissions.get(gUID);
                if (set == null || set.isEmpty()) continue;
                return true;
            }
        }
        if (this.userPermissions != null) {
            for (GUID gUID : this.userPermissions.keySet()) {
                set = this.userPermissions.get(gUID);
                if (set == null || set.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public void clearPermission() {
        if (this.userPermissions != null) {
            this.userPermissions.clear();
        }
        if (this.groupPermissions != null) {
            this.groupPermissions.clear();
        }
    }

    @Nonnull
    public @Nonnull Map<@Nonnull GUID, Set<String>> getPermissions(boolean isGroup) {
        Map<@Nonnull GUID, Set<String>> map = isGroup ? this.groupPermissions : this.userPermissions;
        return map != null ? new HashMap<GUID, Set<String>>(map) : new HashMap();
    }
}

