/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api;

import com.inet.annotations.InternalApi;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.webgui.server.a;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class DriveOperationConflictException
extends IOException {
    private final boolean E;
    @Nonnull
    private final @Nonnull List<@Nonnull SingleEntryConflict> conflicts;

    public static DriveOperationConflictException createSingleConflictException(@Nonnull String id, @Nonnull CONFLICT conflict, @Nullable String msg) {
        return DriveOperationConflictException.createSingleConflictException(true, new SingleEntryConflict(id, conflict, msg));
    }

    public static DriveOperationConflictException createSingleConflictException(boolean executed, @Nonnull SingleEntryConflict conflict) {
        ArrayList<@Nonnull SingleEntryConflict> arrayList = new ArrayList<SingleEntryConflict>();
        arrayList.add(conflict);
        return new DriveOperationConflictException(executed, arrayList);
    }

    public static SingleEntryConflict createAlreadyExistConflict(String existingID, String overwriteID, String name, String path, boolean isFolder) {
        if (isFolder) {
            return new SingleEntryConflict(existingID, overwriteID, CONFLICT.alreadyExistsFolder, DrivePlugin.MSG_CLIENT.getMsg("drive.gui.conflict.alreadyExistsFolder", new Object[0]) + ":'" + path + "' filename = '" + name + "'");
        }
        return new SingleEntryConflict(existingID, overwriteID, CONFLICT.alreadyExists, DrivePlugin.MSG_CLIENT.getMsg("drive.gui.conflict.alreadyExists", new Object[0]) + ": '" + path + "' filename = '" + name + "'");
    }

    public DriveOperationConflictException(boolean operationExecuted, @Nonnull @Nonnull List<@Nonnull SingleEntryConflict> conflicts) {
        super(DriveOperationConflictException.a(conflicts));
        this.E = operationExecuted;
        this.conflicts = conflicts;
    }

    private static String a(@Nonnull @Nonnull List<@Nonnull SingleEntryConflict> list) {
        if (list.size() > 10) {
            return list.subList(0, 10).stream().map(SingleEntryConflict::toMessage).collect(Collectors.joining(", ")) + ", ...";
        }
        return list.stream().map(SingleEntryConflict::toMessage).collect(Collectors.joining(", "));
    }

    public boolean isOperationExecuted() {
        return this.E;
    }

    @Nonnull
    public @Nonnull List<@Nonnull SingleEntryConflict> getConflicts() {
        return Collections.unmodifiableList(this.conflicts);
    }

    @Override
    @Nonnull
    public String toString() {
        return "DriveOperationConflictException{operationExecuted=" + this.E + ", conflicts=" + String.valueOf(this.conflicts) + "}";
    }

    @InternalApi
    public static class SingleEntryConflict {
        private String I;
        @Nonnull
        private CONFLICT conflict;
        private RESOLUTION resolution;
        private String J;
        private String message;

        public SingleEntryConflict(@Nullable String existingEntryID, @Nonnull CONFLICT conflict) {
            this.I = existingEntryID;
            this.conflict = conflict;
        }

        public SingleEntryConflict(@Nullable String existingEntryID, @Nonnull CONFLICT conflict, String message) {
            this.I = existingEntryID;
            this.conflict = conflict;
            this.message = message;
        }

        public SingleEntryConflict(@Nullable String existingEntryID, @Nullable String replacementEntryID, @Nonnull CONFLICT conflict, String message) {
            this(existingEntryID, replacementEntryID, conflict);
            this.message = message;
        }

        public SingleEntryConflict(@Nullable String existingEntryID, @Nullable String replacementEntryID, @Nonnull CONFLICT conflict) {
            this.I = existingEntryID;
            this.J = replacementEntryID;
            this.conflict = conflict;
            if (conflict == CONFLICT.samepath) {
                this.J = null;
            }
        }

        public SingleEntryConflict(@Nonnull String entryID, @Nullable RESOLUTION resolution) {
            this.I = entryID;
            this.resolution = resolution;
            this.conflict = CONFLICT.alreadyExists;
        }

        @Nullable
        public String getExistingEntryID() {
            return this.I;
        }

        public void setExistingEntryID(@Nullable String existingEntryID) {
            this.I = existingEntryID;
        }

        @Nullable
        public String getReplacementEntryID() {
            return this.J;
        }

        public void setReplacementEntryID(@Nullable String replacementEntryID) {
            this.J = replacementEntryID;
        }

        @Nonnull
        public CONFLICT getConflict() {
            return this.conflict;
        }

        @Nullable
        public RESOLUTION getResolution() {
            return this.resolution;
        }

        @Nonnull
        public String toMessage() {
            if (this.message != null) {
                return this.message;
            }
            String string = null;
            if (this.I != null || this.J != null) {
                try {
                    DriveEntry driveEntry = a.du().resolve(this.I != null ? this.I : this.J);
                    if (driveEntry != null) {
                        string = driveEntry.getPath();
                    }
                }
                catch (Throwable throwable) {
                    DrivePlugin.LOGGER.debug((Object)throwable);
                }
            }
            return DrivePlugin.MSG_CLIENT.getMsg("drive.gui.conflict." + String.valueOf((Object)this.conflict), new Object[0]) + (String)(string != null ? ": " + string : "");
        }

        public boolean equals(@Nullable Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            SingleEntryConflict singleEntryConflict = (SingleEntryConflict)o2;
            return Objects.equals(this.I, singleEntryConflict.I) && this.conflict == singleEntryConflict.conflict && this.resolution == singleEntryConflict.resolution && Objects.equals(this.J, singleEntryConflict.J) && Objects.equals(this.message, singleEntryConflict.message);
        }

        public int hashCode() {
            int n2 = Objects.hashCode(this.I);
            n2 = 31 * n2 + Objects.hashCode((Object)this.conflict);
            n2 = 31 * n2 + Objects.hashCode((Object)this.resolution);
            n2 = 31 * n2 + Objects.hashCode(this.J);
            n2 = 31 * n2 + Objects.hashCode(this.message);
            return n2;
        }

        @Nonnull
        public String toString() {
            return "SingleEntryConflict{existingEntryID='" + this.I + "', conflict=" + String.valueOf((Object)this.conflict) + ", resolution=" + String.valueOf((Object)this.resolution) + ", replacementEntryID='" + this.J + "', message='" + this.message + "'}";
        }
    }

    @InternalApi
    public static final class CONFLICT
    extends Enum<CONFLICT> {
        public static final /* enum */ CONFLICT invalidName = new CONFLICT(RESOLUTION.skip);
        public static final /* enum */ CONFLICT invalidPath = new CONFLICT(RESOLUTION.skip);
        public static final /* enum */ CONFLICT alreadyExists = new CONFLICT(RESOLUTION.overwrite, RESOLUTION.rename, RESOLUTION.skip);
        public static final /* enum */ CONFLICT alreadyExistsFolder = new CONFLICT(RESOLUTION.overwrite, RESOLUTION.rename, RESOLUTION.skip);
        public static final /* enum */ CONFLICT writeProtected = new CONFLICT(RESOLUTION.retry, RESOLUTION.skip);
        public static final /* enum */ CONFLICT writeProtectedFolder = new CONFLICT(RESOLUTION.retry, RESOLUTION.rename, RESOLUTION.skip);
        public static final /* enum */ CONFLICT format = new CONFLICT(RESOLUTION.rename, RESOLUTION.skip);
        public static final /* enum */ CONFLICT samepath = new CONFLICT(RESOLUTION.skip);
        public static final /* enum */ CONFLICT locked = new CONFLICT(RESOLUTION.retry, RESOLUTION.skip);
        public static final /* enum */ CONFLICT exception = new CONFLICT(RESOLUTION.retry, RESOLUTION.skip);
        public static final /* enum */ CONFLICT protectedChild = new CONFLICT(RESOLUTION.skip);
        public static final /* enum */ CONFLICT targetNotFound = new CONFLICT(RESOLUTION.retry, RESOLUTION.skip);
        public static final /* enum */ CONFLICT sourceNotFound = new CONFLICT(RESOLUTION.skip);
        private final RESOLUTION[] F;
        private static final /* synthetic */ CONFLICT[] G;

        public static CONFLICT[] values() {
            return (CONFLICT[])G.clone();
        }

        public static CONFLICT valueOf(String name) {
            return Enum.valueOf(CONFLICT.class, name);
        }

        private CONFLICT(RESOLUTION ... defaultResolutions) {
            this.F = defaultResolutions;
        }

        public RESOLUTION[] getDefaultResolutions() {
            return this.F;
        }

        private static /* synthetic */ CONFLICT[] m() {
            return new CONFLICT[]{invalidName, invalidPath, alreadyExists, alreadyExistsFolder, writeProtected, writeProtectedFolder, format, samepath, locked, exception, protectedChild, targetNotFound, sourceNotFound};
        }

        static {
            G = CONFLICT.m();
        }
    }

    @InternalApi
    public static final class RESOLUTION
    extends Enum<RESOLUTION> {
        public static final /* enum */ RESOLUTION skip = new RESOLUTION();
        public static final /* enum */ RESOLUTION skipSameFile = new RESOLUTION();
        public static final /* enum */ RESOLUTION overwrite = new RESOLUTION();
        public static final /* enum */ RESOLUTION retry = new RESOLUTION();
        public static final /* enum */ RESOLUTION rename = new RESOLUTION();
        public static final /* enum */ RESOLUTION skipAll = new RESOLUTION();
        public static final /* enum */ RESOLUTION overwriteAll = new RESOLUTION();
        private static final /* synthetic */ RESOLUTION[] H;

        public static RESOLUTION[] values() {
            return (RESOLUTION[])H.clone();
        }

        public static RESOLUTION valueOf(String name) {
            return Enum.valueOf(RESOLUTION.class, name);
        }

        private static /* synthetic */ RESOLUTION[] n() {
            return new RESOLUTION[]{skip, skipSameFile, overwrite, retry, rename, skipAll, overwriteAll};
        }

        static {
            H = RESOLUTION.n();
        }
    }
}

