/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api;

import com.inet.annotations.InternalApi;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.ShareData;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.drive.webgui.server.a;
import com.inet.id.GUID;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface DriveObserver {
    public boolean isValid();

    default public boolean synchronizedEvent() {
        return false;
    }

    public <T> void changed(@Nonnull EventType<T> var1, @Nonnull T var2);

    @InternalApi
    public static class EventType<T> {
        private static final Map<String, EventType<?>> q = new HashMap();
        @Nonnull
        public static final @Nonnull EventType<@Nonnull RemoveEvent> REMOVED = new EventType("REMOVED");
        @Nonnull
        public static final @Nonnull EventType<@Nonnull DriveEntry> CREATED = new EventType("CREATED");
        @Nonnull
        public static final @Nonnull EventType<@Nonnull DriveEntry> CONTENT_CHANGE = new EventType("CONTENT_CHANGE");
        @Nonnull
        public static final @Nonnull EventType<@Nonnull MetaDataChange> MODIFIED = new EventType("MODIFIED");
        @Nonnull
        public static final @Nonnull EventType<@Nonnull DriveEntry> LOCK = new EventType("LOCK");
        @Nonnull
        public static final @Nonnull EventType<@Nonnull DriveEntry> PERMISSION = new EventType("PERMISSION");
        @Nonnull
        public static final @Nonnull EventType<@Nonnull a> SHARE = new EventType("SHARE");
        @Nonnull
        public static final @Nonnull EventType<@Nonnull ThumbnailEvent> THUMBNAIL = new EventType("THUMBNAIL");
        @Nonnull
        public static final @Nonnull EventType<@Nonnull GUID> REFRESH = new EventType("REFRESH");
        @Nonnull
        private final String key;

        private EventType(@Nonnull String key) {
            this.key = key;
            q.put(key, this);
        }

        @Nonnull
        public String getKey() {
            return this.key;
        }

        public static EventType<?> getTypeForKey(String jsonKey) {
            return q.get(jsonKey);
        }

        @Nonnull
        public String toString() {
            return this.key;
        }

        @InternalApi
        public static final class MetaDataChange {
            @Nonnull
            private final MetaKey<?> r;
            private final Object s;
            private final Object t;
            @Nonnull
            private final String id;

            public MetaDataChange(@Nonnull String id, @Nonnull MetaKey<?> metaKey, @Nullable Object oldValue, @Nullable Object newValue) {
                this.id = id;
                this.r = metaKey;
                this.s = oldValue;
                this.t = newValue;
            }

            public MetaDataChange(@Nonnull String id, @Nonnull MetaKey<?> metaKey) {
                MetaData metaData;
                this.id = id;
                this.r = metaKey;
                DriveEntry driveEntry = com.inet.drive.webgui.server.a.du().resolve(id);
                this.s = null;
                if (driveEntry != null && (metaData = driveEntry.getFeature(DriveEntry.META_DATA)) != null) {
                    this.t = metaData.getMetaData(metaKey);
                    return;
                }
                this.t = null;
            }

            @Nonnull
            public MetaKey<?> getMetaKey() {
                return this.r;
            }

            @Nonnull
            public String getID() {
                return this.id;
            }

            @Nullable
            public Object getOldValue() {
                return this.s;
            }

            @Nullable
            public Object getNewValue() {
                return this.t;
            }

            @Nonnull
            public String toString() {
                return "MetaDataChange{metaKey=" + this.r.getKey() + ", oldValue=" + String.valueOf(this.s) + ", newValue=" + String.valueOf(this.t) + ", id='" + this.id + "'}";
            }
        }

        @InternalApi
        public static final class ThumbnailEvent {
            @Nonnull
            private final DriveEntry y;
            private final Thumbnail.Size D;

            public ThumbnailEvent(@Nonnull DriveEntry entry, @Nullable Thumbnail.Size size) {
                this.y = entry;
                this.D = size;
            }

            @Nonnull
            public DriveEntry getEntry() {
                return this.y;
            }

            @Nullable
            public Thumbnail.Size getSize() {
                return this.D;
            }

            @Nonnull
            public String toString() {
                return "ThumbnailEvent: " + this.y.getName() + " " + String.valueOf((Object)this.D);
            }
        }

        @InternalApi
        public static final class RemoveEvent {
            @Nonnull
            private final String id;
            @Nonnull
            private final String name;
            @Nullable
            private final String parentID;

            public RemoveEvent(@Nonnull String id, @Nullable String parentID, @Nonnull String name) {
                this.id = id;
                this.parentID = parentID;
                this.name = name;
            }

            @Nonnull
            public String getId() {
                return this.id;
            }

            @Nonnull
            public String getName() {
                return this.name;
            }

            @Nullable
            public String getParentID() {
                return this.parentID;
            }

            @Nonnull
            public String toString() {
                return "RemoveEvent{id='" + this.id + "', name='" + this.name + "'}";
            }
        }

        public static final class com.inet.drive.api.DriveObserver$EventType$a {
            @Nonnull
            private final a u;
            @Nonnull
            private final String v;
            @Nonnull
            private @Nonnull Set<@Nonnull GUID> w = new HashSet<GUID>();
            @Nonnull
            private @Nonnull Set<@Nonnull GUID> x = new HashSet<GUID>();
            @Nonnull
            private final DriveEntry y;

            public com.inet.drive.api.DriveObserver$EventType$a(@Nonnull DriveEntry driveEntry, @Nonnull a a2, @Nonnull String string) {
                this.y = driveEntry;
                this.u = a2;
                this.v = string;
            }

            public com.inet.drive.api.DriveObserver$EventType$a(@Nonnull DriveEntry driveEntry, @Nonnull a a2, @Nonnull String string, @Nonnull @Nonnull Set<@Nonnull GUID> set, @Nonnull @Nonnull Set<@Nonnull GUID> set2, @Nullable ShareData shareData) {
                this.y = driveEntry;
                this.u = a2;
                this.v = string;
                this.x = set;
                this.w = set2;
            }

            @Nonnull
            public a h() {
                return this.u;
            }

            @Nonnull
            public DriveEntry getEntry() {
                return this.y;
            }

            @Nonnull
            public String i() {
                return this.v;
            }

            @Nonnull
            public @Nonnull Set<@Nonnull GUID> j() {
                return this.w;
            }

            @Nonnull
            public @Nonnull Set<@Nonnull GUID> k() {
                return this.x;
            }

            public static final class a
            extends Enum<a> {
                public static final /* enum */ a z = new a();
                public static final /* enum */ a A = new a();
                public static final /* enum */ a B = new a();
                private static final /* synthetic */ a[] C;

                public static a[] values() {
                    return (a[])C.clone();
                }

                public static a valueOf(String name) {
                    return Enum.valueOf(a.class, name);
                }

                private static /* synthetic */ a[] l() {
                    return new a[]{z, A, B};
                }

                static {
                    C = a.l();
                }
            }
        }
    }
}

