/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.model;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DrivePermission;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.webgui.server.data.DriveGuiEntry;
import com.inet.drive.webgui.server.handler.k;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.io.DiskBufferedOutputStream;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.remote.gui.angular.filechooser.FSFile;
import com.inet.remote.gui.angular.filechooser.FileSystemService;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class c
implements FileSystemService {
    @Nonnull
    public String getExtensionName() {
        return "drive";
    }

    public @Nullable List<@Nonnull FSFile> getRoots() {
        if (!DriveUtils.hasValidLicense()) {
            return null;
        }
        if (!SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_PERMISSION)) {
            return null;
        }
        ArrayList<@Nonnull FSFile> arrayList = new ArrayList<FSFile>();
        @Nonnull Map<Drive.ROOT_TYPES, List<DriveEntry>> map = Drive.getInstance().getRoots();
        for (Drive.ROOT_TYPES rOOT_TYPES : Drive.ROOT_TYPES.values()) {
            List<DriveEntry> list = map.get((Object)rOOT_TYPES);
            if (list == null) continue;
            list = new ArrayList<DriveEntry>(list);
            Collections.sort(list, (driveEntry, driveEntry2) -> {
                int n2 = driveEntry.getName().toLowerCase().compareTo(driveEntry2.getName().toLowerCase());
                if (n2 != 0) {
                    return n2;
                }
                return driveEntry.getID().compareTo(driveEntry2.getID());
            });
            for (DriveEntry driveEntry3 : list) {
                String string = rOOT_TYPES == Drive.ROOT_TYPES.DRIVE ? "/" : "/" + driveEntry3.getName() + "/";
                arrayList.add(this.i(string, driveEntry3));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="URL is generated and refers to image resources in the archive.")
    public byte[] getFileImage(@Nonnull String iconid) {
        block16: {
            byte[] byArray;
            InputStream inputStream = null;
            try {
                URL uRL = k.a(32, iconid);
                if (uRL == null) {
                    byte[] byArray2 = new byte[]{};
                    return byArray2;
                }
                inputStream = uRL.openStream();
                byArray = IOFunctions.readBytes((InputStream)inputStream);
            }
            catch (IOException iOException) {
                DrivePlugin.LOGGER.debug((Object)iOException);
                break block16;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return byArray;
        }
        return new byte[0];
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<FSFile> getFileSystemFiles(@Nonnull String folderpath, boolean directoriesOnly) {
        DriveEntry driveEntry = this.az(folderpath);
        ArrayList<FSFile> arrayList = new ArrayList<FSFile>();
        if (driveEntry == null) {
            return arrayList;
        }
        @Nonnull @Nonnull List list = driveEntry.executeFeatureNN(Folder.class, folder -> folder.getChildren(), ArrayList::new);
        String string = this.B(driveEntry);
        Collections.sort(list, new a());
        for (DriveEntry driveEntry2 : list) {
            if (directoriesOnly && !driveEntry2.hasFeature(Folder.class)) continue;
            arrayList.add(this.i(string + driveEntry2.getName(), driveEntry2));
        }
        return arrayList;
    }

    @Nonnull
    private String B(@Nonnull DriveEntry driveEntry) {
        String string;
        try {
            string = driveEntry.getPath();
        }
        catch (Exception exception) {
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                string = driveEntry.getPath();
            }
        }
        return string;
    }

    public FSFile getFile(@Nonnull String path) {
        if (!SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_PERMISSION)) {
            return null;
        }
        DriveEntry driveEntry = com.inet.drive.webgui.server.a.du().resolve(path);
        if (driveEntry == null) {
            return null;
        }
        return this.i(path, driveEntry);
    }

    @Nonnull
    private FSFile i(String string, DriveEntry driveEntry) {
        int n2;
        String string2 = new String(Base64.getEncoder().encode(driveEntry.getID().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        String string3 = "drive:" + EncodingFunctions.encodeUrlPath((String)string);
        DriveGuiEntry.a a2 = DriveGuiEntry.a.w(driveEntry);
        String string4 = a2.name();
        String string5 = com.inet.drive.webgui.server.utils.c.Q(driveEntry);
        if (a2 == DriveGuiEntry.a.iJ && (n2 = string5.lastIndexOf(46)) >= 0) {
            string4 = string5.substring(n2 + 1);
        }
        if (a2 == DriveGuiEntry.a.iN && driveEntry.hasFeature(Mount.class)) {
            string4 = com.inet.drive.webgui.server.utils.a.N(driveEntry);
        }
        n2 = driveEntry.hasFeature(Folder.class) ? 1 : 0;
        return new FSFile("drive", string3, string5, string2, string4, n2 != 0, false);
    }

    public FSFile getParent(@Nonnull String path) {
        DriveEntry driveEntry = this.az(path);
        if (driveEntry == null) {
            return null;
        }
        return (driveEntry = driveEntry.getParent()) != null ? this.i(this.B(driveEntry), driveEntry) : null;
    }

    private DriveEntry az(@Nonnull String string) {
        if (!SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_PERMISSION)) {
            return null;
        }
        string = this.normalizePath("", string);
        DriveEntry driveEntry = com.inet.drive.webgui.server.a.du().resolve(string);
        if (driveEntry == null) {
            int n2;
            if (!string.endsWith("/") && (n2 = string.lastIndexOf(47)) >= 0) {
                string = string.substring(0, n2 + 1);
                driveEntry = com.inet.drive.webgui.server.a.du().resolve(string);
            }
            if (driveEntry == null) {
                return null;
            }
        }
        if (!driveEntry.hasFeature(Folder.class) && (driveEntry = driveEntry.getParent()) == null) {
            return null;
        }
        return driveEntry;
    }

    public FSFile getFolder(@Nonnull String path) {
        DriveEntry driveEntry = this.az(path);
        return driveEntry != null ? this.i(this.B(driveEntry), driveEntry) : null;
    }

    @Nonnull
    private String aA(@Nullable String object) {
        if (object == null) {
            object = "/";
        }
        if (!((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        if (((String)object).startsWith("/~/")) {
            object = "/Home" + ((String)object).substring(2);
        }
        return object;
    }

    @Nonnull
    public String normalizePath(@Nullable String basePath, @Nonnull String folderPath) {
        if (folderPath.toLowerCase().startsWith(this.getExtensionName().toLowerCase() + ":")) {
            folderPath = folderPath.substring(6);
            folderPath = EncodingFunctions.decodeUrlPath((String)folderPath);
        }
        if (folderPath.toLowerCase().startsWith("repo:")) {
            folderPath = folderPath.substring(5);
            folderPath = EncodingFunctions.decodeUrlPath((String)folderPath);
        }
        return this.aA(folderPath);
    }

    public boolean isResponsible(@Nonnull String path) {
        if (path.toLowerCase().startsWith(this.getExtensionName().toLowerCase() + ":")) {
            return true;
        }
        return path.toLowerCase().startsWith("repo:");
    }

    @Nonnull
    public Permission getRequiredPermission() {
        return DrivePermission.DRIVE_PERMISSION;
    }

    @Nonnull
    public OutputStream getOutputStream(URL saveTarget) throws IOException, AccessDeniedException, IllegalArgumentException {
        if (!SystemPermissionChecker.checkAccess((Permission)this.getRequiredPermission())) {
            throw new AccessDeniedException(this.getRequiredPermission());
        }
        final @Nonnull String string = this.normalizePath(null, saveTarget.toString());
        return new DiskBufferedOutputStream(){

            public void close() throws IOException {
                try {
                    Drive.getInstance().createOrReplace(string, this.getInputStream());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    super.close();
                }
            }
        };
    }

    private static class a
    implements Comparator<DriveEntry> {
        private Collator collator = Collator.getInstance(ClientLocale.getThreadLocale());

        public a() {
            this.collator.setStrength(0);
        }

        public int f(DriveEntry driveEntry, DriveEntry driveEntry2) {
            int n2 = Integer.compare(DriveGuiEntry.a.w(driveEntry).dE(), DriveGuiEntry.a.w(driveEntry2).dE());
            if (n2 != 0) {
                return n2;
            }
            n2 = this.collator.compare(driveEntry.getName().toUpperCase(), driveEntry2.getName().toUpperCase());
            if (n2 != 0) {
                return n2;
            }
            try {
                long l2 = driveEntry.getLastModified();
                long l3 = driveEntry2.getLastModified();
                n2 = Long.compare(l2, l3);
                if (n2 != 0) {
                    return n2;
                }
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
            return driveEntry.getID().compareTo(driveEntry2.getID());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.f((DriveEntry)object, (DriveEntry)object2);
        }
    }
}

