/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.data;

import com.inet.annotations.JsonData;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.webgui.server.utils.e;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public abstract class ConflictResolveRequest {
    private List<@Nonnull String> overwriteIDs = null;
    private List<@Nonnull String> skipIDs = null;
    private List<@Nonnull String> renameIDs = null;
    private String pollingID;
    private String sourceTaskID;
    private e.b renameMap;

    protected ConflictResolveRequest() {
    }

    public void setOverwriteIDs(List<@Nonnull String> overwriteIDs) {
        this.overwriteIDs = overwriteIDs;
    }

    public void setSkipIDs(List<@Nonnull String> skipIDs) {
        this.skipIDs = skipIDs;
    }

    protected List<@Nonnull String> getSkipIDs() {
        return this.skipIDs;
    }

    public void setRenameIDs(List<@Nonnull String> renameIDs) {
        this.renameIDs = renameIDs;
    }

    @Nonnull
    public List<DriveOperationConflictException.SingleEntryConflict> toAPIResolutions() {
        ArrayList<DriveOperationConflictException.SingleEntryConflict> arrayList = new ArrayList<DriveOperationConflictException.SingleEntryConflict>();
        if (this.overwriteIDs != null) {
            this.overwriteIDs.forEach(id -> arrayList.add(new DriveOperationConflictException.SingleEntryConflict((String)id, DriveOperationConflictException.RESOLUTION.overwrite)));
        }
        if (this.skipIDs != null) {
            this.skipIDs.forEach(id -> arrayList.add(new DriveOperationConflictException.SingleEntryConflict((String)id, DriveOperationConflictException.RESOLUTION.skip)));
        }
        if (this.renameIDs != null) {
            this.renameIDs.forEach(id -> arrayList.add(new DriveOperationConflictException.SingleEntryConflict((String)id, DriveOperationConflictException.RESOLUTION.rename)));
        }
        return arrayList;
    }

    public Map<String, DriveOperationConflictException.RESOLUTION> toAPIResolutionsMap() {
        List<DriveOperationConflictException.SingleEntryConflict> list = this.toAPIResolutions();
        HashMap<String, DriveOperationConflictException.RESOLUTION> hashMap = new HashMap<String, DriveOperationConflictException.RESOLUTION>();
        for (DriveOperationConflictException.SingleEntryConflict singleEntryConflict : list) {
            String string = singleEntryConflict.getExistingEntryID();
            if (string == null) {
                string = singleEntryConflict.getReplacementEntryID();
            }
            hashMap.put(string, singleEntryConflict.getResolution());
        }
        return hashMap;
    }

    public String getPollingID() {
        return this.pollingID;
    }

    public void setPollingID(String pollingID) {
        this.pollingID = pollingID;
    }

    public String getSourceTaskID() {
        return this.sourceTaskID;
    }

    @Nullable
    public e.b getRenameMap() {
        return this.renameMap;
    }
}

