/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.persistence;

import com.inet.cache.MemoryStoreMap;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.drive.webgui.server.a;
import com.inet.drive.webgui.server.handler.k;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.image.PreviewGenerator;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;

public class g
implements DriveFileTypeHandler,
DriveObserver {
    private static final MemoryStoreMap<String, String> ey = new MemoryStoreMap(10, true);

    @Nonnull
    public String getExtensionName() {
        return "folder.handler";
    }

    @Override
    public boolean acceptFileTyp(@Nonnull DriveEntry entry) {
        if (entry.getID() == "Drive") {
            return false;
        }
        if (entry.getMetaData(MetaData.HOMEFOLDER) != null && "Drive".equals(entry.getMetaData(MetaData.PARENT_ID))) {
            return false;
        }
        return entry.hasFeature(Folder.class) && !entry.hasFeature(Mount.class);
    }

    @Override
    @Nonnull
    public DriveFileTypeHandler.FileTypeDriveEntryHandler getFileTypeHandler(@Nonnull PersistenceEntry contentEntry, @Nonnull DriveEntry entry) {
        return new DriveFileTypeHandler.FileTypeDriveEntryHandler(){

            @Override
            @Nullable
            public String getTextForSearch() {
                return null;
            }

            @Override
            @Nullable
            public Map<MetaKey<?>, Object> getMetaData() {
                return null;
            }
        };
    }

    @Override
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The requested URL is generated by the server end refers to application internal files only.")
    public PreviewGenerator.ImagePreview getThumbnail(@Nonnull DriveEntry entry, @Nonnull Thumbnail.Size size, boolean requireExactSize) throws IOException {
        Object object;
        Thumbnail thumbnail2;
        URL uRL;
        @Nullable Folder folder = entry.getFeature(Folder.class);
        if (folder == null) {
            return null;
        }
        DriveEntry object2 = null;
        @Nonnull List<@Nonnull DriveEntry> list = folder.getChildren();
        for (DriveEntry object3 : list) {
            if (object3.hasFeature(Folder.class)) continue;
            uRL = null;
            if (object3.hasFeature(Thumbnail.class) && (thumbnail2 = object3.getFeature(Thumbnail.class)) != null) {
                object = thumbnail2.getThumbnail(size);
                if (object == null) {
                    return null;
                }
                if (object == Thumbnail.WILL_RENDER_ASYNC) {
                    object2 = object3;
                    break;
                }
                uRL = this.a(size, (InputStream)object, object3, entry, false);
            }
            if (uRL != null) {
                return uRL;
            }
            if (object2 != null) continue;
            object2 = object3;
        }
        String string = entry.getMetaData(MetaData.PARENT_ID);
        ey.remove((Object)string);
        if (object2 != null) {
            String string2 = DriveFileTypeHandler.getSuffix(object2);
            uRL = k.a(size.getSize(), string2);
            if (uRL != null) {
                thumbnail2 = null;
                object = uRL.openStream();
                try {
                    if (object != null) {
                        thumbnail2 = this.a(size, (InputStream)object, object2, entry, true);
                    }
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
                if (ey.containsKey((Object)string)) {
                    for (DriveEntry driveEntry : list) {
                        PreviewGenerator.ImagePreview imagePreview;
                        if (driveEntry.hasFeature(Folder.class) || (imagePreview = driveEntry.executeFeature(Thumbnail.class, thumbnail -> {
                            InputStream inputStream = thumbnail.getThumbnail(size);
                            if (inputStream == null || inputStream == Thumbnail.WILL_RENDER_ASYNC) {
                                return null;
                            }
                            return this.a(size, inputStream, driveEntry, entry, false);
                        }, () -> null)) == null) continue;
                        return imagePreview;
                    }
                }
                return thumbnail2;
            }
        }
        entry.runFeature(MetaData.class, metaData -> metaData.setMetaData(MetaData.THUMBNAIL_ENTRY_ID, "no_entry"));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreviewGenerator.ImagePreview a(@Nonnull Thumbnail.Size size, @Nonnull InputStream inputStream, @Nonnull DriveEntry driveEntry, @Nonnull DriveEntry driveEntry2, boolean bl) throws IOException {
        try {
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2;
            try {
                bufferedImage2 = ImageIO.read(inputStream);
            }
            catch (Exception exception) {
                DrivePlugin.LOGGER.debug((Object)exception);
                PreviewGenerator.ImagePreview imagePreview = null;
                inputStream.close();
                return imagePreview;
            }
            if (bufferedImage2 == null) {
                PreviewGenerator.ImagePreview imagePreview = null;
                return imagePreview;
            }
            int n2 = 64;
            switch (size) {
                case px96: {
                    n2 = 64;
                    break;
                }
                case px512: {
                    n2 = 128;
                }
            }
            try (Object object = a.class.getResourceAsStream("images/folder_open_transparent_" + n2 + ".png");){
                if (object == null) {
                    throw new IOException("Folder image not found");
                }
                bufferedImage = ImageIO.read((InputStream)object);
            }
            object = new BufferedImage(n2, n2, 2);
            Graphics2D graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
            double d2 = 0.328125;
            double d3 = 0.046875;
            int n3 = (int)(d2 * (double)n2);
            int n4 = (int)(d3 * (double)n2);
            Rectangle rectangle = new Rectangle(n4, n3, n2 - n4 * 2, n2 / 2);
            graphics2D.setClip(rectangle);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(rectangle);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(bufferedImage2, rectangle.x, rectangle.y, rectangle.width, rectangle.width, null);
            graphics2D.setClip(new Rectangle(n2, n2));
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)object, "png", byteArrayOutputStream);
            driveEntry2.runFeature(MetaData.class, metaData -> metaData.setMetaData(MetaData.THUMBNAIL_ENTRY_ID, driveEntry.getID() + (bl ? "fall_back" : "")));
            PreviewGenerator.ImagePreview imagePreview = new PreviewGenerator.ImagePreview(n2, n2, "png", byteArrayOutputStream);
            return imagePreview;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    @Nullable
    public Object getFileSpecificDiff(@Nonnull DriveEntry previous, @Nonnull DriveEntry after) {
        return null;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public <T> void changed(@Nonnull DriveObserver.EventType<T> type, @Nonnull T eventData) {
        Object object;
        DriveEntry driveEntry;
        Object object2;
        if (type == DriveObserver.EventType.REMOVED) {
            DriveObserver.EventType.RemoveEvent removeEvent = (DriveObserver.EventType.RemoveEvent)eventData;
            String string = removeEvent.getParentID();
            if (string == null) {
                return;
            }
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                String string2;
                DriveEntry driveEntry2 = a.du().resolve(string);
                if (driveEntry2 != null && (string2 = driveEntry2.getMetaData(MetaData.THUMBNAIL_ENTRY_ID)) != null && string2.startsWith(removeEvent.getId())) {
                    this.a(driveEntry2, null);
                }
            }
            return;
        }
        if (type == DriveObserver.EventType.CONTENT_CHANGE || type == DriveObserver.EventType.CREATED) {
            object2 = (DriveEntry)eventData;
            if (object2.hasFeature(Folder.class)) {
                return;
            }
            driveEntry = object2.getParent();
            if (driveEntry == null) {
                return;
            }
            object = driveEntry.getMetaData(MetaData.THUMBNAIL_ENTRY_ID);
            if (object != null && ("no_entry".equals(object) || ((String)object).equals(object2.getID()) || ((String)object).endsWith("fall_back"))) {
                this.a(driveEntry, null);
            }
        }
        if (type == DriveObserver.EventType.THUMBNAIL) {
            String string;
            object2 = (DriveObserver.EventType.ThumbnailEvent)eventData;
            driveEntry = ((DriveObserver.EventType.ThumbnailEvent)object2).getEntry();
            if (driveEntry.hasFeature(Folder.class)) {
                return;
            }
            object = driveEntry.getParent();
            if (object == null) {
                return;
            }
            @Nullable String string3 = object.getMetaData(MetaData.PARENT_ID);
            if (string3 != null) {
                ey.put((Object)string3, (Object)string3);
            }
            if ((string = object.getMetaData(MetaData.THUMBNAIL_ENTRY_ID)) != null && ("no_entry".equals(string) || string.equals(driveEntry.getID()) || string.endsWith("fall_back"))) {
                this.a((DriveEntry)object, ((DriveObserver.EventType.ThumbnailEvent)object2).getSize());
            }
        }
    }

    private void a(@Nonnull DriveEntry driveEntry, Thumbnail.Size size) {
        @Nullable Thumbnail thumbnail = driveEntry.getFeature(Thumbnail.class);
        if (thumbnail == null) {
            return;
        }
        if (size == null) {
            try {
                driveEntry.runFeature(MetaData.class, metaData -> metaData.setMetaData(MetaData.THUMBNAIL_ENTRY_ID, "no_entry"));
            }
            catch (DriveEntry.UnmodifiableEntryException | DriveIOException | DriveOperationConflictException exception) {
                DrivePlugin.LOGGER.debug((Object)exception);
            }
        }
        if (size == null) {
            thumbnail.resetThumbnails(new Thumbnail.Size[0]);
        } else {
            thumbnail.resetThumbnails(size);
        }
    }
}

