/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.server.search.c;
import com.inet.drive.webgui.server.a;
import com.inet.id.GUID;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@InternalApi
public class PersistenceCloudEvent {
    private GUID perID;
    private String type;
    private String eID;
    private String name;
    private String pID;
    private String users;
    private String groups;
    private boolean f;
    private String metakey;

    public <T> PersistenceCloudEvent(GUID nodeid, DriveObserver.EventType<T> eventType, T eventData) {
        this.perID = nodeid;
        this.type = eventType.getKey();
        if (eventType == DriveObserver.EventType.MODIFIED) {
            DriveObserver.EventType.MetaDataChange metaDataChange = (DriveObserver.EventType.MetaDataChange)eventData;
            this.eID = metaDataChange.getID();
            this.metakey = metaDataChange.getMetaKey().getKey();
        } else if (eventType == DriveObserver.EventType.REMOVED) {
            DriveObserver.EventType.RemoveEvent removeEvent = (DriveObserver.EventType.RemoveEvent)eventData;
            this.eID = removeEvent.getId();
            this.pID = removeEvent.getParentID();
            this.name = removeEvent.getId();
        } else if (eventType == DriveObserver.EventType.THUMBNAIL) {
            DriveObserver.EventType.ThumbnailEvent thumbnailEvent = (DriveObserver.EventType.ThumbnailEvent)eventData;
            DriveEntry driveEntry = thumbnailEvent.getEntry();
            this.eID = driveEntry.getID();
            this.pID = driveEntry.getMetaData(MetaData.PARENT_ID);
            this.f = driveEntry.hasFeature(Folder.class);
        } else if (eventType == DriveObserver.EventType.REFRESH) {
            this.eID = ((GUID)eventData).toString();
        } else if (eventType == DriveObserver.EventType.SHARE) {
            DriveObserver.EventType.a a2 = (DriveObserver.EventType.a)eventData;
            this.eID = a2.getEntry().getID();
            this.type = a2.h().name();
            this.name = a2.i();
            this.users = this.convertToString(a2.k());
            this.groups = this.convertToString(a2.j());
        } else {
            DriveEntry driveEntry = (DriveEntry)eventData;
            this.eID = driveEntry.getID();
            this.pID = driveEntry.getMetaData(MetaData.PARENT_ID);
            this.f = driveEntry.hasFeature(Folder.class);
        }
    }

    private String convertToString(Set<GUID> ids) {
        Object object = "";
        for (GUID gUID : ids) {
            object = (String)object + gUID.toString() + ",";
        }
        return object;
    }

    private HashSet<GUID> convertToSet(String ids) {
        String[] stringArray = ids.split(",");
        HashSet<GUID> hashSet = new HashSet<GUID>();
        for (String string : stringArray) {
            if (string == null || string.isEmpty()) continue;
            hashSet.add(GUID.valueOf((String)string));
        }
        return hashSet;
    }

    private PersistenceCloudEvent() {
    }

    public GUID getPersistenceID() {
        return this.perID;
    }

    public DriveObserver.EventType<?> getEventType() {
        return DriveObserver.EventType.getTypeForKey(this.type);
    }

    public String getEntryID() {
        return this.eID;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getParentID() {
        return this.pID;
    }

    public boolean isFolder() {
        return this.f;
    }

    public <T> MetaKey<T> getMetakey() {
        if (this.metakey == null) {
            return null;
        }
        return c.G(this.metakey);
    }

    public DriveObserver.EventType.RemoveEvent getRemoveEvent() {
        return new DriveObserver.EventType.RemoveEvent(this.getEntryID(), this.getParentID(), this.getName());
    }

    public DriveObserver.EventType.MetaDataChange getMetaDataChangeEvent() {
        return new DriveObserver.EventType.MetaDataChange(this.getEntryID(), this.getMetakey());
    }

    @Nullable
    public DriveObserver.EventType.a getShareEvent() {
        HashSet<GUID> hashSet = this.convertToSet(this.users);
        HashSet<GUID> hashSet2 = this.convertToSet(this.groups);
        DriveEntry driveEntry = a.du().resolve(this.eID);
        if (driveEntry != null) {
            return new DriveObserver.EventType.a(driveEntry, DriveObserver.EventType.a.a.valueOf(this.type), this.name, hashSet, hashSet2, null);
        }
        return null;
    }

    @Nonnull
    public String toString() {
        return "PersistenceCloudEvent{persistenceID=" + String.valueOf(this.perID) + ", eventType='" + this.type + "', entryID='" + this.eID + "', entryName='" + this.name + "', metakey='" + this.metakey + "'}";
    }
}

