/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.details;

import com.inet.annotations.JsonData;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.server.sharing.ShareManager;
import com.inet.drive.webgui.server.data.DriveGuiEntry;
import com.inet.drive.webgui.server.details.DetailsPanelExtension;
import com.inet.drive.webgui.server.utils.c;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;

public class MyShareDetailsExtension
implements DetailsPanelExtension {
    @Nonnull
    public String getExtensionName() {
        return "detailspanel.myshare";
    }

    @Override
    public String getDisplayName() {
        return DrivePlugin.MSG_CLIENT.getMsg("drive.gui.details.myshare.displayname", new Object[0]);
    }

    @Override
    public String getDescription() {
        return DrivePlugin.MSG_CLIENT.getMsg("drive.gui.details.myshare.description", new Object[0]);
    }

    @Override
    public URL getTemplateURL() {
        return this.getClass().getResource("/com/inet/drive/webgui/client/details/myshareextension.html");
    }

    @Override
    public boolean appliesTo(@Nonnull DriveEntry entry) {
        return "SharedWithMe".equals(entry.getID());
    }

    public List<ShareListEntry> a(@Nonnull DriveEntry driveEntry, @Nonnull List<String> list, @Nonnull DetailsPanelExtension.a a2) {
        ArrayList<ShareListEntry> arrayList = new ArrayList<ShareListEntry>();
        if (!"SharedWithMe".equals(driveEntry.getID())) {
            return arrayList;
        }
        GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID == null) {
            return arrayList;
        }
        HashSet<String> hashSet = ShareManager.bU().n(gUID);
        for (String string : hashSet) {
            String string2;
            DriveEntry driveEntry2 = ShareManager.bU().J(string);
            if (driveEntry2 == null) continue;
            DriveGuiEntry.a a3 = DriveGuiEntry.a.w(driveEntry2);
            if (a3 == DriveGuiEntry.a.iM) {
                a3 = DriveGuiEntry.a.iL;
            }
            String string3 = string2 = a3 == DriveGuiEntry.a.iJ ? DriveFileTypeHandler.getSuffix(driveEntry2) : null;
            if (string2 == null || string2.isBlank()) {
                string2 = a3.name().toLowerCase();
            }
            String string4 = c.Q(driveEntry2);
            arrayList.add(new ShareListEntry(string, string4, a3, string2));
        }
        Collections.sort(arrayList, new a());
        return arrayList;
    }

    public /* synthetic */ Object getEntryData(@Nonnull DriveEntry driveEntry, @Nonnull List list, @Nonnull DetailsPanelExtension.a a2) {
        return this.a(driveEntry, list, a2);
    }

    @JsonData
    public static class ShareListEntry {
        private String id;
        private String name;
        private DriveGuiEntry.a type;
        private String mimeKey;

        public ShareListEntry(@Nonnull String id, @Nonnull String name, @Nonnull DriveGuiEntry.a type, @Nonnull String mimeKey) {
            this.id = id;
            this.name = name;
            this.type = type;
            this.mimeKey = mimeKey;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public String getId() {
            return this.id;
        }
    }

    private static class a
    implements Comparator<ShareListEntry> {
        private Collator collator = Collator.getInstance(ClientLocale.getThreadLocale());

        public a() {
            this.collator.setStrength(0);
        }

        public int a(ShareListEntry shareListEntry, ShareListEntry shareListEntry2) {
            int n2 = Integer.compare(shareListEntry.type.dE(), shareListEntry2.type.dE());
            if (n2 != 0) {
                return n2;
            }
            n2 = this.collator.compare(shareListEntry.name, shareListEntry2.name);
            if (n2 != 0) {
                return n2;
            }
            return shareListEntry.id.compareTo(shareListEntry2.id);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((ShareListEntry)object, (ShareListEntry)object2);
        }
    }
}

