/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.actions.permissions;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DrivePermissionType;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.webgui.server.actions.permissions.PermissionsData;
import com.inet.drive.webgui.server.actions.permissions.PermissionsDataWithInherit;
import com.inet.drive.webgui.server.actions.permissions.b;
import com.inet.drive.webgui.server.data.SingleIDData;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
extends ServiceMethod<SingleIDData, PermissionsDataWithInherit> {
    @Nonnull
    private static @Nonnull List<@Nonnull DrivePermissionType> iz = new ArrayList<DrivePermissionType>();

    public String getMethodName() {
        return "drive.permissions";
    }

    public short getMethodType() {
        return 1;
    }

    @Nonnull
    public static @Nonnull List<@Nonnull DrivePermissionType> dw() {
        if (iz.isEmpty() && ServerPluginManager.getInstance().isInitFinish()) {
            iz = new ArrayList<DrivePermissionType>(ServerPluginManager.getInstance().get(DrivePermissionType.class));
        }
        return iz;
    }

    public PermissionsDataWithInherit a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, SingleIDData singleIDData) throws IOException {
        Object object3;
        Object object2;
        List<PermissionsData.PermissionsEntry> list;
        List<PermissionsData.PermissionsEntry> list2;
        GUID gUID;
        String string = singleIDData.getId();
        if (string == null) {
            return null;
        }
        if (DriveIDUtils.isMountID(string) || DriveIDUtils.isIDinMount(string)) {
            throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("permissions.error.notformount", new Object[0]));
        }
        DriveEntry driveEntry = com.inet.drive.webgui.server.a.du().resolve(string);
        if (driveEntry == null || !driveEntry.exists()) {
            throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("permissions.error.noaccess", new Object[]{string}));
        }
        if (b.u(driveEntry)) {
            throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("permissions.error.homedenied", new Object[]{string}));
        }
        if (!driveEntry.hasFeature(Permissions.class) || !com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission(string, false, "VIEWER") && !com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission(string, false, "EDITOR")) {
            throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("permissions.error.nowrite", new Object[]{driveEntry.getName()}));
        }
        boolean bl = false;
        if (driveEntry.executeFeature(Mount.class, mount -> mount.getProviderKey().equals("PERSISTENCE_PROVIDER"), false) && driveEntry.hasFeature(MetaData.class) && ((gUID = driveEntry.getMetaData(MetaData.CREATOR_ID)) == null || !gUID.equals((Object)UserManager.getInstance().getCurrentUserAccountID()))) {
            bl = true;
        }
        boolean bl2 = !a.s(driveEntry);
        ArrayList<PermissionsData.PermissionsEntry> arrayList = new ArrayList<PermissionsData.PermissionsEntry>();
        ArrayList<PermissionsData.PermissionsEntry> arrayList2 = new ArrayList<PermissionsData.PermissionsEntry>();
        a.a(driveEntry, arrayList, arrayList2);
        Permissions permissions = driveEntry.getFeature(Permissions.class);
        if (bl2 || permissions == null) {
            list2 = new ArrayList<PermissionsData.PermissionsEntry>(arrayList);
            list = new ArrayList<PermissionsData.PermissionsEntry>(arrayList2);
        } else {
            boolean bl3 = b.dx();
            list2 = a.b(bl3, permissions);
            list = a.a(bl3, permissions);
        }
        List<String> list3 = null;
        @Nonnull String[] stringArray = DriveIDUtils.splittID(string);
        boolean bl4 = true;
        boolean bl5 = false;
        String string2 = null;
        if (stringArray.length > 1) {
            object2 = stringArray[stringArray.length - 1];
            if (DriveIDUtils.isMountID((String)object2)) {
                if (com.inet.drive.webgui.server.utils.a.O(com.inet.drive.webgui.server.a.du().resolve((String)object2)) != Boolean.TRUE) {
                    bl = true;
                } else {
                    list3 = this.ar((String)object2);
                }
                bl2 = false;
                bl4 = false;
            } else {
                bl = true;
                bl4 = true;
                if (com.inet.drive.webgui.server.utils.a.O(com.inet.drive.webgui.server.a.du().resolve(DriveIDUtils.getParentMountID(string))) == Boolean.TRUE) {
                    string2 = DriveIDUtils.getParentMountID(string);
                }
            }
            bl5 = true;
        } else if (driveEntry.executeFeature(Mount.class, mount -> "PERSISTENCE_PROVIDER".equals(mount.getProviderKey()), false)) {
            if (com.inet.drive.webgui.server.utils.a.O(driveEntry) != Boolean.TRUE) {
                bl = true;
            } else {
                list3 = this.ar(string);
            }
            bl5 = true;
            bl2 = false;
            bl4 = false;
        } else {
            bl |= !com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission(string, false, "EDITOR");
            if (string.equals("Drive")) {
                for (Object object3 : list) {
                    if (!object3.getKey().equals(UsersAndGroups.GROUPID_ADMIN.toString())) continue;
                    list.remove(object3);
                    break;
                }
                list3 = new ArrayList<String>();
                list3.addAll(a.dw().stream().map(drivePermissionType -> drivePermissionType.getPermissionTypeName()).collect(Collectors.toList()));
                object2 = UserGroupManager.getInstance().getGroup(UsersAndGroups.GROUPID_ADMIN).getDisplayName();
                object3 = PermissionsData.PermissionsEntry.forUserOrGroup(UsersAndGroups.GROUPID_ADMIN, (String)object2, list3);
                object3.setEditable(false);
                list.add(0, (PermissionsData.PermissionsEntry)((Object)object3));
                bl4 = false;
            } else {
                bl4 = true;
            }
        }
        object2 = this.a(driveEntry, list3);
        this.a((PermissionsData.PermissionsEntry)((Object)object2), list2);
        this.a((PermissionsData.PermissionsEntry)((Object)object2), arrayList);
        if (b.dx()) {
            object3 = new PermissionsDataWithInherit(string, list, list2, arrayList2, arrayList, bl2);
        } else {
            List<String> list4 = this.i(bl2 ? arrayList2 : list);
            String string3 = this.a(list, list2, this.i(list));
            String string4 = this.a(arrayList2, arrayList, this.i(arrayList2));
            object3 = new PermissionsDataWithInherit(string, bl2, list4, string3, string4);
        }
        ((PermissionsDataWithInherit)object3).setReadOnly(bl);
        ((PermissionsDataWithInherit)object3).setCanInherit(bl4);
        ((PermissionsDataWithInherit)object3).setInLink(bl5);
        ((PermissionsDataWithInherit)object3).setParentLinkID(string2);
        ((PermissionsDataWithInherit)object3).setShowReducedPermissions(list3 != null && list3.size() != a.dw().size());
        ((PermissionsDataWithInherit)object3).setAvailablePermissions(a.dw(), list3);
        return object3;
    }

    private List<String> ar(@Nonnull String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DrivePermissionType drivePermissionType : a.dw()) {
            if (!com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission(string, false, drivePermissionType.getPermissionTypeName())) continue;
            arrayList.add(drivePermissionType.getPermissionTypeName());
        }
        return arrayList;
    }

    public static void a(@Nonnull DriveEntry driveEntry, @Nonnull List<PermissionsData.PermissionsEntry> list, @Nonnull List<PermissionsData.PermissionsEntry> list2) {
        driveEntry = a.r(driveEntry);
        boolean bl = b.dx();
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            DriveEntry driveEntry2;
            for (driveEntry2 = driveEntry.getParent(); driveEntry2 != null && !a.s(driveEntry2); driveEntry2 = driveEntry2.getParent()) {
            }
            if (driveEntry2 != null) {
                driveEntry2.runFeature(Permissions.class, permissions -> {
                    list.addAll(a.b(bl, permissions));
                    list2.addAll(a.a(bl, permissions));
                });
            }
        }
    }

    @Nonnull
    private static DriveEntry r(@Nonnull DriveEntry driveEntry) {
        return driveEntry.executeFeatureNN(Mount.class, mount -> {
            if ("PERSISTENCE_PROVIDER".equals(mount.getProviderKey()) || "sharing".equals(mount.getProviderKey())) {
                String string = mount.getOriginID();
                try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                    DriveEntry driveEntry2 = com.inet.drive.webgui.server.a.du().resolve(string);
                    if (driveEntry2 != null) {
                        DriveEntry driveEntry3 = a.r(driveEntry2);
                        if (driveEntry3 != driveEntry2) {
                            DriveEntry driveEntry4 = driveEntry3;
                            return driveEntry4;
                        }
                        DriveEntry driveEntry5 = driveEntry2;
                        return driveEntry5;
                    }
                }
            }
            return driveEntry;
        }, () -> driveEntry);
    }

    @Nonnull
    private static List<PermissionsData.PermissionsEntry> a(boolean bl, @Nonnull Permissions permissions) {
        return a.a(permissions.getPermissions(true), (GUID gUID) -> {
            if (!bl) {
                return gUID.toString();
            }
            UserGroupInfo userGroupInfo = UserGroupManager.getInstance().getGroup(gUID);
            return userGroupInfo != null ? UsersAndGroups.getFullGroupDisplayName((UserGroupInfo)userGroupInfo) : gUID.toString();
        });
    }

    @Nonnull
    private static List<PermissionsData.PermissionsEntry> b(boolean bl, @Nonnull Permissions permissions) {
        return a.a(permissions.getPermissions(false), (GUID gUID) -> {
            if (!bl) {
                return gUID.toString();
            }
            UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
            return userAccount != null ? userAccount.getDisplayName() : gUID.toString();
        });
    }

    private void a(@Nullable PermissionsData.PermissionsEntry permissionsEntry, @Nonnull List<PermissionsData.PermissionsEntry> list) {
        for (PermissionsData.PermissionsEntry permissionsEntry3 : list) {
            if (!permissionsEntry3.getKey().equals(UserManager.PRIVILEGED_ACCOUNT_ID.toString())) continue;
            list.remove((Object)permissionsEntry3);
            break;
        }
        if (permissionsEntry == null || permissionsEntry.getKey().equals(UserManager.PRIVILEGED_ACCOUNT_ID.toString())) {
            return;
        }
        list.removeIf(permissionsEntry2 -> permissionsEntry.getKey().equals(permissionsEntry2.getKey()));
        list.add(permissionsEntry);
    }

    @Nullable
    private PermissionsData.PermissionsEntry a(@Nonnull DriveEntry driveEntry, List<String> list) {
        if (!driveEntry.hasFeature(MetaData.class)) {
            return null;
        }
        GUID gUID = driveEntry.getMetaData(MetaData.CREATOR_ID);
        if (gUID == null || UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)gUID)) {
            return null;
        }
        UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
        if (userAccount == null) {
            return null;
        }
        if (list != null) {
            return PermissionsData.PermissionsEntry.forOwnerInLink(gUID, DrivePlugin.MSG_SERVER.getMsg("permissions.info.owner", new Object[]{userAccount.getDisplayName()}), list);
        }
        return PermissionsData.PermissionsEntry.forOwner(gUID, DrivePlugin.MSG_SERVER.getMsg("permissions.info.owner", new Object[]{userAccount.getDisplayName()}));
    }

    @Nullable
    private String a(@Nonnull List<PermissionsData.PermissionsEntry> list, @Nonnull List<PermissionsData.PermissionsEntry> list2, @Nonnull List<String> list3) {
        Object object;
        String string;
        @Nullable GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID != null && list.isEmpty() && list2.size() == 1 && gUID.toString().equals(list2.get(0).getKey())) {
            return null;
        }
        List<String> list4 = this.a(list, list2);
        if (!list4.isEmpty() && new HashSet<String>(list4).equals(new HashSet<String>(list3))) {
            return null;
        }
        if (list4.isEmpty()) {
            string = DrivePlugin.MSG_SERVER.getMsg("permissions.custom.mixed", new Object[0]);
        } else {
            object = new ArrayList();
            for (DrivePermissionType drivePermissionType : a.dw()) {
                if (!list4.contains(drivePermissionType.getPermissionTypeName())) continue;
                object.add(drivePermissionType.getDisplayName());
            }
            string = object.stream().collect(Collectors.joining(", "));
        }
        object = DrivePlugin.MSG_SERVER.getMsg("permissions.custom.groups", new Object[]{list.size()});
        String string2 = DrivePlugin.MSG_SERVER.getMsg("permissions.custom.users", new Object[]{list2.size() - 1});
        if (!list.isEmpty() && list2.size() > 1) {
            return DrivePlugin.MSG_SERVER.getMsg("permissions.custom.dual", new Object[]{string, object, string2});
        }
        return DrivePlugin.MSG_SERVER.getMsg("permissions.custom.single", new Object[]{string, list.isEmpty() ? string2 : object});
    }

    @Nonnull
    private List<String> i(@Nonnull List<PermissionsData.PermissionsEntry> list) {
        for (PermissionsData.PermissionsEntry permissionsEntry : list) {
            if (!permissionsEntry.getKey().equals(UsersAndGroups.GROUPID_ALLUSERS.toString())) continue;
            return permissionsEntry.getPermissions();
        }
        return new ArrayList<String>();
    }

    @Nonnull
    private List<String> a(@Nonnull List<PermissionsData.PermissionsEntry> list, @Nonnull List<PermissionsData.PermissionsEntry> list2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (PermissionsData.PermissionsEntry permissionsEntry : list) {
            if (hashSet.isEmpty()) {
                hashSet.addAll(permissionsEntry.getPermissions());
                continue;
            }
            if (hashSet.size() == permissionsEntry.getPermissions().size() && hashSet.containsAll(permissionsEntry.getPermissions())) continue;
            return new ArrayList<String>();
        }
        for (PermissionsData.PermissionsEntry permissionsEntry : list2) {
            if (permissionsEntry.isOwner()) continue;
            if (hashSet.isEmpty()) {
                hashSet.addAll(permissionsEntry.getPermissions());
                continue;
            }
            if (hashSet.size() == permissionsEntry.getPermissions().size() && hashSet.containsAll(permissionsEntry.getPermissions())) continue;
            return new ArrayList<String>();
        }
        return new ArrayList<String>(hashSet);
    }

    private static boolean s(DriveEntry driveEntry) {
        return driveEntry.executeFeature(Permissions.class, permissions -> !permissions.getPermissions(true).isEmpty() || !permissions.getPermissions(false).isEmpty(), false);
    }

    @Nonnull
    private static List<PermissionsData.PermissionsEntry> a(@Nonnull @Nonnull Map<@Nonnull GUID, Map<String, Boolean>> map, Function<GUID, String> function) {
        if (map == null || map.isEmpty()) {
            return new ArrayList<PermissionsData.PermissionsEntry>();
        }
        ArrayList<PermissionsData.PermissionsEntry> arrayList = new ArrayList<PermissionsData.PermissionsEntry>();
        for (Map.Entry<GUID, Map<String, Boolean>> entry : map.entrySet()) {
            @Nonnull GUID gUID = entry.getKey();
            String string = function.apply(gUID);
            if (string == null) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (DrivePermissionType drivePermissionType : a.dw()) {
                if (!Boolean.TRUE.equals(entry.getValue().get(drivePermissionType.getPermissionTypeName()))) continue;
                arrayList2.add(drivePermissionType.getPermissionTypeName());
            }
            if (arrayList2.isEmpty()) continue;
            arrayList.add(PermissionsData.PermissionsEntry.forUserOrGroup(entry.getKey(), string, arrayList2));
        }
        return arrayList;
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (SingleIDData)object);
    }
}

