/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.webgui.server.data.DriveGuiEntry;
import com.inet.drive.webgui.server.model.fields.c;
import com.inet.lib.util.StringFunctions;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@Schema(description="Response data for a drive entry meta data request")
public class DriveMetaResponseData {
    private static final Set<MetaKey<?>> SKIP_KEYS = new HashSet<Object>(Arrays.asList(MetaData.CREATOR, MetaData.HOMEFOLDER, MetaData.ID, MetaData.KEYWORDS, MetaData.NAME, MetaData.PARENT_ID, MetaData.PATH, MetaData.TEXT, "THUMBNAIL", MetaData.MODIFIED));
    @Schema(description="Unique identifier of the drive entry")
    @Nullable
    private String id;
    @Schema(description="Name of the drive entry")
    @Nullable
    private String name;
    @Schema(description="Type of the drive entry")
    @Nullable
    private String type;
    @JsonExcludeNull
    @Schema(description="Full path of the drive entry")
    @Nullable
    private String path;
    @Schema(description="Last modification timestamp")
    private long lastModified = 0L;
    @Schema(description="URL to request the content of this entry")
    private String contentHref;
    @JsonExcludeNull
    @Schema(description="Additional meta data properties")
    @Nullable
    private Map<String, Object> metaData;
    @JsonExcludeNull
    @Schema(description="List of permissions for the current user")
    @Nullable
    private List<String> userPermissions;
    @JsonExcludeNull
    @Schema(description="List of child entries if this is a folder")
    @Nullable
    private List<DriveMetaResponseData> children;
    @JsonExcludeNull
    @Schema(description="Error message if something went wrong")
    @Nullable
    private String error;

    private DriveMetaResponseData() {
    }

    public static DriveMetaResponseData from(@Nonnull DriveEntry entry, @Nonnull HttpServletRequest request) {
        return DriveMetaResponseData.from(entry, request, true);
    }

    public static DriveMetaResponseData from(@Nonnull DriveEntry entry, @Nonnull HttpServletRequest request, boolean goDeeper) {
        DriveMetaResponseData driveMetaResponseData;
        block6: {
            String string;
            int n2;
            driveMetaResponseData = new DriveMetaResponseData();
            driveMetaResponseData.id = entry.getID();
            driveMetaResponseData.name = new c().D(entry);
            driveMetaResponseData.lastModified = entry.getLastModified();
            driveMetaResponseData.type = DriveGuiEntry.a.w(entry).name();
            @Nullable StringBuffer stringBuffer = request.getRequestURL();
            if (stringBuffer != null && (n2 = (string = stringBuffer.toString()).toLowerCase().indexOf("/api/drive/meta")) > 0) {
                String string2 = string.substring(0, n2);
                driveMetaResponseData.contentHref = string2 + "/api/drive/content/" + entry.getID();
            }
            if (!goDeeper) {
                return driveMetaResponseData;
            }
            try {
                entry.runFeature(MetaData.class, meta -> {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    responseData.metaData = hashMap;
                    for (MetaKey<?> metaKey : com.inet.drive.server.search.c.bR()) {
                        Object object;
                        if (SKIP_KEYS.contains(metaKey) || (object = meta.getMetaData(metaKey)) == null) continue;
                        @Nonnull String string = metaKey.getKey().toLowerCase();
                        if (metaKey == MetaData.CREATOR_ID) {
                            object = metaKey.formatValue(object);
                            string = "creator";
                        }
                        if (metaKey == MetaData.MODIFIEDBY) {
                            object = metaKey.formatValue(object);
                            string = "modifiedBy";
                        }
                        if (metaKey == MetaData.CREATE) {
                            string = "created";
                        }
                        hashMap.put(string, object);
                    }
                });
            }
            catch (Throwable throwable) {
                driveMetaResponseData.error = StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable);
            }
            driveMetaResponseData.path = entry.getPath();
            try {
                entry.runFeature(Folder.class, folder -> {
                    responseData.children = folder.getChildren().stream().map(f2 -> DriveMetaResponseData.from(f2, request, false)).collect(Collectors.toList());
                });
            }
            catch (Throwable throwable) {
                if (driveMetaResponseData.error != null) break block6;
                driveMetaResponseData.error = StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable);
            }
        }
        return driveMetaResponseData;
    }
}

