/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.setup.repository.permission;

import com.inet.annotations.InternalApi;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.Permission;
import com.inet.drive.api.feature.Permissions;
import com.inet.id.GUID;
import com.inet.lib.json.JsonException;
import com.inet.permissions.url.PermissionJsonUtils;
import com.inet.permissions.url.PermissionUrlObject;
import com.inet.setupwizard.api.SetupLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

@InternalApi
public class PermissionMigrator {
    public static void migrateOldRepositoryPermission(DriveEntry folder, InputStream permissions) throws IllegalArgumentException, JsonException, FileNotFoundException {
        PermissionUrlObject permissionUrlObject = PermissionJsonUtils.read((InputStream)permissions);
        PermissionMigrator.a(folder, permissionUrlObject);
    }

    public static void migrateOldRepositoryPermission(DriveEntry folder, File permissions) throws IllegalArgumentException, JsonException, FileNotFoundException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(permissions);){
            PermissionUrlObject permissionUrlObject = PermissionJsonUtils.read((InputStream)fileInputStream);
            PermissionMigrator.a(folder, permissionUrlObject);
        }
    }

    public static void migrateOldRepositoryPermission(DriveEntry folder, String permissions) throws IllegalArgumentException, JsonException {
        PermissionUrlObject permissionUrlObject = PermissionJsonUtils.read((String)permissions);
        PermissionMigrator.a(folder, permissionUrlObject);
    }

    private static void a(DriveEntry driveEntry, PermissionUrlObject permissionUrlObject) throws IllegalArgumentException {
        if (!driveEntry.hasFeature(Folder.class)) {
            throw new IllegalArgumentException("DriveEntry must be a folder");
        }
        if (permissionUrlObject != null) {
            Permissions permissions;
            if (SetupLogger.LOGGER.isDebug()) {
                SetupLogger.LOGGER.debug((Object)"\tmigrate folder permissions");
            }
            if ((permissions = driveEntry.getFeature(DriveEntry.PERMISSIONS)) != null) {
                GUID[] gUIDArray;
                GUID[] gUIDArray2 = gUIDArray = permissionUrlObject.getRoleIds();
                int n2 = gUIDArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    GUID gUID = gUIDArray2[i2];
                    int n3 = permissionUrlObject.getRolePermission(gUID);
                    if (SetupLogger.LOGGER.isDebug()) {
                        SetupLogger.LOGGER.debug((Object)("\t\tgroup permission :" + n3));
                    }
                    if ((n3 & 4) == 4) {
                        permissions.addPermissions(gUID, true, Permissions.VIEWER_PERMISSION);
                    }
                    if ((n3 & 2) == 2) {
                        permissions.addPermissions(gUID, true, Permissions.EDITOR_PERMISSION);
                    }
                    if ((n3 & 1) != 1) continue;
                    permissions.addPermissions(gUID, true, new Permission("execute", Boolean.TRUE));
                }
                for (GUID gUID : gUIDArray2 = permissionUrlObject.getUserIds()) {
                    int n4 = permissionUrlObject.getUserPermission(gUID);
                    if (SetupLogger.LOGGER.isDebug()) {
                        SetupLogger.LOGGER.debug((Object)("\tuser permission :" + String.valueOf(gUID) + ":" + n4));
                    }
                    if ((n4 & 4) == 4) {
                        permissions.addPermissions(gUID, false, Permissions.VIEWER_PERMISSION);
                    }
                    if ((n4 & 2) == 2) {
                        permissions.addPermissions(gUID, false, Permissions.EDITOR_PERMISSION);
                    }
                    if ((n4 & 1) != 1) continue;
                    permissions.addPermissions(gUID, false, new Permission("execute", Boolean.TRUE));
                }
            }
        }
    }
}

