/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.maintenance;

import com.inet.annotations.JsonData;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.server.a;
import com.inet.http.ClientMessageException;
import com.inet.maintenance.api.cache.MaintenanceCacheAction;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccountScope;

@JsonData
public class DriveCacheAction
extends MaintenanceCacheAction {
    public static final int INDEXER_COUNT_NOT_AVAILABLE = -1;
    private int driveIndexerCount = -1;
    private int driveIndexerFolderCount = -1;
    private int driveIndexerFileCount = -1;
    private int driveIndexerMountCount = -1;
    private boolean driveIndexerRunning = false;

    public DriveCacheAction() {
        super("reloadDriveCache");
        this.setDefaultState(false);
    }

    public void updateAction() {
        com.inet.drive.server.search.a a2 = ((a)com.inet.drive.webgui.server.a.du()).J();
        if (a2 == null) {
            this.setDefaultState(false);
            this.driveIndexerCount = -1;
        } else {
            IndexSearchEngine<String> indexSearchEngine = a2.bM();
            this.driveIndexerRunning = indexSearchEngine.isReindexRunning();
            this.setDefaultState(this.driveIndexerRunning);
            if (this.driveIndexerRunning) {
                this.driveIndexerCount = indexSearchEngine.getRunningIndexCount();
                this.driveIndexerFolderCount = -1;
                this.driveIndexerFileCount = -1;
                this.driveIndexerMountCount = -1;
            } else {
                this.updateCount();
            }
        }
    }

    private void updateCount() {
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            DriveUtils.b b2 = DriveUtils.getAllSubelements(com.inet.drive.webgui.server.a.du().resolve("Drive"), com.inet.drive.webgui.server.a.du());
            this.driveIndexerCount = b2.t().size();
            this.driveIndexerFolderCount = b2.q().size();
            this.driveIndexerMountCount = b2.r().size();
            this.driveIndexerFileCount = b2.p().size();
        }
    }

    public String executeAction() throws ClientMessageException {
        com.inet.drive.server.search.a a2 = ((a)com.inet.drive.webgui.server.a.du()).J();
        if (a2 == null) {
            return DrivePlugin.MSG_SERVER.getMsg("drive.cache.notready", new Object[0]);
        }
        a2.bM().reIndexAsync();
        return DriveCacheAction.getDefaultExecuteActionMessage();
    }

    public int getDriveIndexerCount() {
        return this.driveIndexerCount;
    }

    public int getDriveFolderCount() {
        return this.driveIndexerFolderCount;
    }

    public int getDriveFileCount() {
        return this.driveIndexerFileCount;
    }

    public int getDriveMountCount() {
        return this.driveIndexerMountCount;
    }

    public boolean isIndexerRunning() {
        return this.driveIndexerRunning;
    }
}

