/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.google;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.server.google.GoogleResourceResponse;
import com.inet.drive.server.google.a;
import com.inet.drive.server.google.c;
import com.inet.drive.server.oauth.b;
import com.inet.error.ErrorCode;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.Json;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class f
implements MetaData,
a {
    @Nonnull
    private b bP;
    @Nonnull
    private c bQ;

    f(@Nonnull b b2, @Nonnull c c2) {
        this.bP = b2;
        this.bQ = c2;
    }

    @Override
    public <T> void setMetaData(@Nonnull MetaKey<T> key, @Nullable T value) throws DriveEntry.UnmodifiableEntryException, DriveOperationConflictException {
        if (key == NAME) {
            if (this.bQ.ac().getParent() == null) {
                throw new IllegalArgumentException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.cannotchangename", new Object[]{this.bQ.getName(), value}));
            }
            if (value == null || value.toString().isBlank()) {
                DriveOperationConflictException.SingleEntryConflict singleEntryConflict = new DriveOperationConflictException.SingleEntryConflict(null, this.bQ.getID(), DriveOperationConflictException.CONFLICT.invalidName, DrivePlugin.MSG_SERVER.getMsg("drive.entry.cannotchangename", new Object[]{this.bQ.getName(), value}));
                throw DriveOperationConflictException.createSingleConflictException(false, singleEntryConflict);
            }
            @Nullable c c2 = this.bQ.ad();
            if (c2 != null && c2.hasFeature(Folder.class)) {
                for (DriveEntry object : c2.getFeature(Folder.class).getChildren()) {
                    if (object == this.bQ || !object.getName().equals(value)) continue;
                    DriveOperationConflictException.SingleEntryConflict string = DriveOperationConflictException.createAlreadyExistConflict(object.getID(), this.bQ.getID(), this.bQ.getName(), object.getPath(), object.hasFeature(Folder.class));
                    throw DriveOperationConflictException.createSingleConflictException(false, string);
                }
            }
            try {
                HashMap<String, T> hashMap = new HashMap<String, T>();
                hashMap.put("name", value);
                FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
                new Json().toJson((Object)hashMap, (OutputStream)fastByteArrayOutputStream);
                String string = this.bQ.ab();
                if (string == null) {
                    DriveOperationConflictException.SingleEntryConflict inputStream = new DriveOperationConflictException.SingleEntryConflict(this.bQ.getID(), DriveOperationConflictException.CONFLICT.sourceNotFound);
                    throw DriveOperationConflictException.createSingleConflictException(false, inputStream);
                }
                InputStream inputStream = this.bP.a(this.a(string, new String[]{"uploadType=multipart"}), "PATCH", HttpRequest.BodyPublishers.ofInputStream(() -> new FastByteArrayInputStream(fastByteArrayOutputStream.toByteArray())), "application/json; charset=utf-8");
                GoogleResourceResponse googleResourceResponse = (GoogleResourceResponse)new Json().fromJson(inputStream, GoogleResourceResponse.class, new HashMap(), null);
                this.bQ.a(googleResourceResponse);
                return;
            }
            catch (IOException iOException) {
                throw (RuntimeException)ErrorCode.throwAny((Throwable)iOException);
            }
        }
        if (key == MetaData.MODIFIED || key == MetaData.PARENT_ID || key == MetaData.ID || key == MetaData.SIZE || key == MetaData.PATH || key == MetaData.FILETYPE) {
            throw new DriveEntry.UnmodifiableEntryException(this.bQ);
        }
    }

    @Override
    @Nullable
    public <T> T getMetaData(@Nonnull MetaKey<T> key) {
        if (key == MetaData.PARENT_ID) {
            return this.bQ.getMetaData(key);
        }
        if (key == MetaData.PATH) {
            return (T)this.bQ.getPath();
        }
        if (key == MetaData.NAME) {
            return (T)this.bQ.getName();
        }
        if (key == MetaData.FILETYPE) {
            if (this.bQ.hasFeature(Folder.class)) {
                return null;
            }
            return (T)(this.bQ.hasFeature(Content.class) ? DriveFileTypeHandler.getSuffix(this.bQ.getName()) : null);
        }
        if (key == MetaData.ID) {
            return (T)this.bQ.getID();
        }
        if (key == MetaData.MODIFIED) {
            return (T)Long.valueOf(this.bQ.ac().getModifiedTime());
        }
        if (key == MetaData.SIZE) {
            return (T)(this.bQ.hasFeature(Folder.class) ? null : Long.valueOf(this.bQ.ac().getSize()));
        }
        return null;
    }
}

