/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api;

import com.inet.annotations.InternalApi;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.OperationProgressListener;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.DriveFeature;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.Lock;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.api.feature.RandomAccess;
import com.inet.drive.api.feature.Revision;
import com.inet.drive.api.feature.Synchronization;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.drive.api.feature.b;
import com.inet.drive.api.feature.c;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface DriveEntry {
    @Nonnull
    public static final @Nonnull Class<@Nonnull Folder> FOLDER = Folder.class;
    @Nonnull
    public static final @Nonnull Class<@Nonnull Content> CONTENT = Content.class;
    @Nonnull
    public static final @Nonnull Class<@Nonnull RandomAccess> RANDOMACCESS = RandomAccess.class;
    @Nonnull
    public static final @Nonnull Class<@Nonnull Permissions> PERMISSIONS = Permissions.class;
    @Nonnull
    public static final @Nonnull Class<@Nonnull MetaData> META_DATA = MetaData.class;
    @Nonnull
    public static final @Nonnull Class<@Nonnull Revision> REVISON = Revision.class;
    @Nonnull
    public static final @Nonnull Class<@Nonnull Lock> LOCK = Lock.class;
    @Nonnull
    public static final @Nonnull Class<@Nonnull Mount> MOUNT = Mount.class;
    @Nonnull
    public static final @Nonnull Class<@Nonnull com.inet.drive.api.feature.a> LINK = com.inet.drive.api.feature.a.class;
    @Nonnull
    public static final @Nonnull Class<@Nonnull c> SHARE = c.class;
    @Nonnull
    public static final @Nonnull Class<@Nonnull Thumbnail> THUMBNAIL = Thumbnail.class;
    @Nonnull
    public static final @Nonnull Class<@Nonnull Synchronization> SYNCHRO = Synchronization.class;
    public static final Class<b> INDEX = b.class;

    @Nonnull
    public String getExtensionName();

    @Nonnull
    public String getName();

    @Nonnull
    public String getPath();

    @Nonnull
    public String getID();

    public long getLastModified() throws DriveIOException;

    public boolean exists();

    default public <T extends DriveFeature, E extends Throwable> boolean runFeature(@Nonnull Class<T> type, @Nonnull FeatureConsumer<T, E> action) throws E {
        return this.runFeature(type, action, () -> {});
    }

    default public <T extends DriveFeature, E extends Throwable> boolean runFeature(@Nonnull Class<T> type, @Nonnull FeatureConsumer<T, E> action, @Nonnull Runnable runIfFeatureMissing) throws E {
        try {
            if (!this.hasFeature(type)) {
                runIfFeatureMissing.run();
                return false;
            }
        }
        catch (DriveIOException driveIOException) {
            runIfFeatureMissing.run();
            return false;
        }
        @Nullable T t2 = this.getFeature(type);
        if (t2 != null) {
            action.accept(t2);
            return true;
        }
        runIfFeatureMissing.run();
        return false;
    }

    @Nullable
    default public <T extends DriveFeature, E extends Throwable, R> R executeFeature(@Nonnull Class<T> type, @Nonnull FeatureConsumerWithResult<T, E, R> action, @Nonnull Supplier<@Nullable R> resultIfMissing) throws E {
        try {
            if (!this.hasFeature(type)) {
                return resultIfMissing.get();
            }
        }
        catch (DriveIOException driveIOException) {
            return resultIfMissing.get();
        }
        @Nullable T t2 = this.getFeature(type);
        if (t2 != null) {
            return action.accept(t2);
        }
        return resultIfMissing.get();
    }

    @Nonnull
    default public <T extends DriveFeature, E extends Throwable, R> R executeFeatureNN(@Nonnull Class<T> type, @Nonnull FeatureConsumerWithResult<T, E, R> action, @Nonnull a<R> resultIfMissing) throws E {
        try {
            if (!this.hasFeature(type)) {
                return resultIfMissing.get();
            }
        }
        catch (DriveIOException driveIOException) {
            return resultIfMissing.get();
        }
        @Nullable T t2 = this.getFeature(type);
        if (t2 != null) {
            return action.accept(t2);
        }
        return resultIfMissing.get();
    }

    default public <T extends DriveFeature, E extends Throwable> boolean executeFeature(@Nonnull Class<T> type, @Nonnull @Nonnull FeatureConsumerWithBooleanResult<T, @Nonnull E> action, boolean defaultValue) throws E {
        try {
            if (!this.hasFeature(type)) {
                return defaultValue;
            }
        }
        catch (DriveIOException driveIOException) {
            return defaultValue;
        }
        @Nullable T t2 = this.getFeature(type);
        if (t2 != null) {
            return action.accept(t2);
        }
        return defaultValue;
    }

    default public <T extends DriveFeature, E extends Throwable> long executeFeature(@Nonnull Class<T> type, @Nonnull @Nonnull FeatureConsumerWithLongResult<T, @Nonnull E> action, long defaultValue) throws E {
        try {
            if (!this.hasFeature(type)) {
                return defaultValue;
            }
        }
        catch (DriveIOException driveIOException) {
            return defaultValue;
        }
        @Nullable T t2 = this.getFeature(type);
        if (t2 != null) {
            return action.accept(t2);
        }
        return defaultValue;
    }

    @Nullable
    default public <T> T getMetaData(@Nonnull MetaKey<T> key) {
        if (!this.hasFeature(MetaData.class)) {
            return null;
        }
        @Nullable MetaData metaData = this.getFeature(MetaData.class);
        return metaData != null ? (T)metaData.getMetaData(key) : null;
    }

    @Nonnull
    default public String getDislayName() {
        return this.getName();
    }

    public boolean hasFeature(@Nonnull Class<? extends DriveFeature> var1) throws DriveIOException;

    @Nullable
    public <T extends DriveFeature> T getFeature(@Nonnull Class<T> var1) throws DriveIOException;

    @Nullable
    public DriveEntry getParent();

    public void delete(@Nullable OperationProgressListener var1) throws DriveOperationConflictException;

    @FunctionalInterface
    @InternalApi
    public static interface FeatureConsumer<T, E extends Throwable> {
        public void accept(@Nonnull T var1) throws E;
    }

    @FunctionalInterface
    @InternalApi
    public static interface FeatureConsumerWithResult<T, E extends Throwable, R> {
        public R accept(@Nonnull T var1) throws E;
    }

    @FunctionalInterface
    public static interface a<@Nonnull T> {
        @Nonnull
        public T get();
    }

    @FunctionalInterface
    @InternalApi
    public static interface FeatureConsumerWithBooleanResult<T, E extends Throwable> {
        public boolean accept(@Nonnull T var1) throws E;
    }

    @FunctionalInterface
    @InternalApi
    public static interface FeatureConsumerWithLongResult<T, E extends Throwable> {
        public long accept(@Nonnull T var1) throws E;
    }

    @InternalApi
    public static class UnmodifiableEntryException
    extends RuntimeException {
        @Nonnull
        private final DriveEntry k;

        public UnmodifiableEntryException(@Nonnull DriveEntry e2) {
            this.k = e2;
        }

        @Nonnull
        public DriveEntry getEntry() {
            return this.k;
        }
    }
}

