/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.actions.share;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DrivePermission;
import com.inet.drive.api.DrivePermissionType;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.feature.ShareAnonymLink;
import com.inet.drive.webgui.server.actions.permissions.PermissionsData;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class ShareDialogData
extends PermissionsData {
    private List<String> permissionsKeys = new ArrayList<String>();
    private List<String> permissionsNames = new ArrayList<String>();
    private List<String> allowedPermissionKeys = new ArrayList<String>();
    @Nonnull
    private List<ShareLinkData> shareLinks = new ArrayList<ShareLinkData>();
    @JsonExcludeNull
    private List<@Nonnull String> nonInheritFolders;
    private boolean shareLinksAllowed;
    private boolean shareUaGAllowed;

    private ShareDialogData() {
    }

    public ShareDialogData(@Nonnull String entryID, @Nonnull List<PermissionsData.PermissionsEntry> groups, @Nonnull List<PermissionsData.PermissionsEntry> users) {
        super(entryID, groups, users, false);
        this.shareLinksAllowed = SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_SHARE_LINK_PERMISSION);
        this.shareUaGAllowed = SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER);
    }

    public void setAvailablePermissions(List<DrivePermissionType> permissions, List<String> allowedPermissions) {
        permissions.forEach(p2 -> {
            this.permissionsKeys.add(p2.getPermissionTypeName());
            this.permissionsNames.add(p2.getDisplayName());
        });
        this.allowedPermissionKeys = allowedPermissions != null ? allowedPermissions : this.permissionsKeys;
    }

    public void addShareLink(@Nonnull ShareLinkData linkData) {
        this.shareLinks.add(linkData);
        Collections.sort(this.shareLinks);
    }

    public void setShareLinks(@Nonnull List<ShareLinkData> shareLinks) {
        this.shareLinks = shareLinks;
        Collections.sort(shareLinks);
    }

    @Nonnull
    public List<ShareLinkData> getShareLinks() {
        return this.shareLinks;
    }

    public void setNonInheritFolders(@Nullable List<@Nonnull String> nonInheritFolders) {
        this.nonInheritFolders = nonInheritFolders;
    }

    @JsonData
    public static class ShareLinkData
    implements Comparable<ShareLinkData> {
        @Nonnull
        private String id;
        private String link;
        @Nonnull
        private String creatorID;
        private String creatorName;
        private String creationDate;
        private long creationDateLong;
        private String expirationDate;
        private long expirationDateLong;
        @Nonnull
        private List<String> permissions;
        private String password;

        public ShareLinkData(@Nonnull String id, @Nonnull GUID creatorID, long creationDate, @Nonnull List<String> permissions, @Nullable String password, long expirationDateLong) {
            UserAccount userAccount;
            this.id = id;
            this.password = password;
            this.expirationDateLong = expirationDateLong;
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, ClientLocale.getThreadLocale());
            if (expirationDateLong > 0L) {
                this.expirationDate = dateFormat.format(expirationDateLong);
            }
            this.creatorID = creatorID.toString();
            this.creationDateLong = creationDate;
            this.creationDate = dateFormat.format(creationDate);
            this.creatorName = this.creatorID;
            if (SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER) && (userAccount = UserManager.getInstance().getUserAccount(creatorID)) != null) {
                this.creatorName = userAccount.getDisplayName();
            }
            this.permissions = permissions;
        }

        private ShareLinkData() {
        }

        @Nonnull
        public static ShareLinkData from(@Nonnull ShareAnonymLink link) {
            String string = link.getId();
            GUID gUID = link.getOwner();
            return new ShareLinkData(string, gUID, link.getCreationTime(), link.getPermissions(), link.getPassword(), link.getExpirationTime());
        }

        @Nonnull
        public ShareAnonymLink toLink(@Nonnull DriveEntry entry, @Nullable ShareAnonymLink existing) {
            long l2 = existing != null ? existing.getCreationTime() : System.currentTimeMillis();
            GUID gUID = GUID.valueOf((String)this.creatorID);
            if (gUID == null) {
                throw new IllegalStateException("CreatorID not set for link " + this.id);
            }
            String string = entry.getID();
            Mount mount = entry.getFeature(DriveEntry.MOUNT);
            if (mount != null) {
                string = mount.getOriginID();
            }
            return new ShareAnonymLink(this.id, gUID, string, this.permissions, l2, this.password, this.expirationDateLong);
        }

        @Override
        public int compareTo(@Nonnull ShareLinkData o2) {
            int n2 = Long.compare(this.creationDateLong, o2.creationDateLong);
            if (n2 != 0) {
                return n2;
            }
            return this.id.compareTo(o2.id);
        }

        @Nonnull
        public String getId() {
            return this.id;
        }
    }
}

