/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.pluginapi;

import com.inet.annotations.InternalApi;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.webgui.pluginapi.ContextMenuExtension;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@InternalApi
public abstract class AbstractContextMenuExtension
implements ContextMenuExtension {
    @Nonnull
    private String dA;
    @Nonnull
    private String actionKey;
    private int it;
    private List<String> iu;

    public AbstractContextMenuExtension(@Nonnull String extensionName, @Nonnull String actionKey, int priority, String ... implicitPermissions) {
        this.dA = extensionName;
        this.actionKey = actionKey;
        this.it = priority;
        this.iu = implicitPermissions != null ? Collections.unmodifiableList(Arrays.asList(implicitPermissions)) : null;
    }

    @Override
    public String getActionKey() {
        return this.actionKey;
    }

    @Nonnull
    public String getExtensionName() {
        return this.dA;
    }

    @Override
    public int getPriority() {
        return this.it;
    }

    protected boolean isUserHomeFolder(DriveEntry e2) {
        if (e2.hasFeature(Folder.class) && e2.hasFeature(MetaData.class) && "Home".equals(e2.getName())) {
            UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
            if (userAccount == null) {
                return true;
            }
            GUID gUID = userAccount.getID();
            if (!UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)gUID)) {
                String string = DriveUtils.getHomeFolderID(userAccount);
                return e2.getID().equals(string);
            }
        }
        return false;
    }

    @Override
    public List<String> getImplicitPermissions(@Nonnull DriveEntry e2) {
        if (this.addForEntry(e2) != ContextMenuExtension.AddType.none) {
            return this.iu;
        }
        return null;
    }
}

