/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webapi.handler;

import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.webapi.a;
import com.inet.drive.webapi.data.DriveMetaResponseData;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

@Tag(name="Drive", description="Drive meta data operations")
public class c
extends RequestHandler.WithCurrentPathToken<Void, DriveMetaResponseData, String> {
    public c(String ... stringArray) {
        super(stringArray);
    }

    public c() {
        super(new String[]{"path"});
    }

    public String ap(String string) {
        return string;
    }

    public String getHelpPageKey() {
        return "webapi.drive.meta.id";
    }

    @Operation(summary="Get meta data for a drive entry", description="Retrieves meta data and optional children for a drive entry specified by ID or path. Returns detailed information including permissions, last modified time, and child entries for folders.", responses={@ApiResponse(responseCode="200", description="Meta data successfully retrieved", content={@Content(mediaType="application/json", schema=@Schema(implementation=DriveMetaResponseData.class))}), @ApiResponse(responseCode="404", description="Drive entry not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=DriveMetaResponseData.class))}), @ApiResponse(responseCode="403", description="Access forbidden - insufficient permissions")})
    public DriveMetaResponseData c(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Parameter(hidden=true) @Nullable Void void_, @Parameter(description="ID or path of the drive entry. For folders, ensure the path ends with a trailing slash.", required=true, schema=@Schema(type="string")) @Nullable String string, @Parameter(description="Additional path segments for nested operations", required=false, schema=@Schema(type="array")) List<String> list, @Parameter(hidden=true) boolean bl) throws IOException {
        String string2;
        list = a.a(httpServletRequest, string, list);
        try {
            string2 = a.a(httpServletResponse, list);
        }
        catch (FileNotFoundException fileNotFoundException) {
            httpServletResponse.setStatus(404);
            return null;
        }
        DriveEntry driveEntry = Drive.getInstance().resolve(string2);
        if (driveEntry == null) {
            httpServletResponse.setStatus(404);
            return null;
        }
        try {
            return DriveMetaResponseData.from(driveEntry, httpServletRequest);
        }
        catch (Exception exception) {
            httpServletResponse.setStatus(403);
            return null;
        }
    }

    public boolean isMethodAllowedForData(HttpServletRequest request) {
        return "GET".equals(request.getMethod());
    }

    @Operation(summary="Get meta data for a drive entry", description="Retrieves meta data and optional children for a drive entry specified by ID or path. Returns detailed information including permissions, last modified time, and child entries for folders.", responses={@ApiResponse(responseCode="200", description="Meta data successfully retrieved", content={@Content(mediaType="application/json", schema=@Schema(implementation=DriveMetaResponseData.class))}), @ApiResponse(responseCode="404", description="Drive entry not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=DriveMetaResponseData.class))}), @ApiResponse(responseCode="403", description="Access forbidden - insufficient permissions")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Parameter(hidden=true) @Nullable Object object, @Parameter(description="ID or path of the drive entry. For folders, ensure the path ends with a trailing slash.", required=true, schema=@Schema(type="string")) @Nullable Object object2, @Parameter(description="Additional path segments for nested operations", required=false, schema=@Schema(type="array")) List list, @Parameter(hidden=true) boolean bl) throws IOException {
        return this.c(httpServletRequest, httpServletResponse, (Void)object, (String)object2, list, bl);
    }

    public /* synthetic */ Object typeFor(String string) {
        return this.ap(string);
    }
}

