/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.eventlog;

import com.inet.annotations.JsonData;
import com.inet.drive.server.eventlog.PermissionChange;
import com.inet.id.GUID;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JsonData
public class PermissionsChangeLog {
    private HashSet<GUID> addedID = new HashSet();
    private HashSet<GUID> removedID = new HashSet();
    private HashSet<PermissionChange> changes = new HashSet();

    private PermissionsChangeLog() {
    }

    public PermissionsChangeLog(Map<GUID, Map<String, Boolean>> oldPermissions, Map<GUID, Map<String, Boolean>> newPermissions) {
        Set<GUID> set = this.getAllIDs(oldPermissions.keySet(), newPermissions.keySet());
        for (GUID gUID : set) {
            boolean bl = oldPermissions.containsKey(gUID);
            boolean bl2 = newPermissions.containsKey(gUID);
            if (bl && bl2) {
                Map<String, Boolean> map = oldPermissions.get(gUID);
                Map<String, Boolean> map2 = newPermissions.get(gUID);
                Set<String> set2 = this.getAllPermissions(map.keySet(), map2.keySet());
                this.processPermissionChanges(gUID, set2, map.keySet(), map2.keySet());
                continue;
            }
            this.processIDChanges(bl, bl2, gUID);
        }
    }

    public PermissionsChangeLog(boolean share, Map<GUID, Set<String>> oldPermissions, Map<GUID, Set<String>> newPermissions) {
        Set<GUID> set = this.getAllIDs(oldPermissions.keySet(), newPermissions.keySet());
        for (GUID gUID : set) {
            boolean bl = oldPermissions.containsKey(gUID);
            boolean bl2 = newPermissions.containsKey(gUID);
            if (bl && bl2) {
                Set<String> set2 = oldPermissions.get(gUID);
                Set<String> set3 = newPermissions.get(gUID);
                Set<String> set4 = this.getAllPermissions(set2, set3);
                this.processPermissionChanges(gUID, set4, set2, set3);
                continue;
            }
            this.processIDChanges(bl, bl2, gUID);
        }
    }

    private void processIDChanges(boolean oldContainsID, boolean newContainsID, GUID id) {
        if (oldContainsID && newContainsID) {
            return;
        }
        if (oldContainsID) {
            this.removedID.add(id);
        } else {
            this.addedID.add(id);
        }
    }

    private void processPermissionChanges(GUID id, Set<String> allPermissions, Set<String> oldPermissions, Set<String> newPermissions) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string : allPermissions) {
            boolean bl = oldPermissions.contains(string);
            boolean bl2 = newPermissions.contains(string);
            if (bl && bl2) continue;
            if (bl) {
                hashSet2.add(string);
                continue;
            }
            hashSet.add(string);
        }
        if (!hashSet.isEmpty() || !hashSet2.isEmpty()) {
            this.changes.add(new PermissionChange(id, hashSet, hashSet2));
        }
    }

    private Set<GUID> getAllIDs(Set<GUID> oldKeys, Set<GUID> newKeys) {
        HashSet<GUID> hashSet = new HashSet<GUID>();
        hashSet.addAll(oldKeys);
        hashSet.addAll(newKeys);
        return hashSet;
    }

    private Set<String> getAllPermissions(Set<String> oldPermissions, Set<String> newPermissions) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(oldPermissions);
        hashSet.addAll(newPermissions);
        return hashSet;
    }
}

