/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server;

import com.inet.authentication.AccessForbiddenException;
import com.inet.cache.MemoryStoreMap;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DataEntry;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.DrivePermission;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.LockException;
import com.inet.drive.api.OperationProgressListener;
import com.inet.drive.api.PersistenceCloudEvent;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.DriveFeature;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.api.feature.UploadListener;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountManager;
import com.inet.drive.api.permission.PermissionChecker;
import com.inet.drive.server.eventlog.OperationEntryForEventLog;
import com.inet.drive.server.persistence.e;
import com.inet.drive.server.persistence.i;
import com.inet.drive.server.persistence.m;
import com.inet.drive.server.sharing.ShareManager;
import com.inet.drive.server.sharing.h;
import com.inet.drive.webgui.pluginapi.ResolveRenameHandler;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.PersistenceListener;
import com.inet.search.ResultLineFactory;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchCommand;
import com.inet.search.index.SearchResultListener;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.ThreadPool;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
implements Drive,
PersistenceListener<PersistenceCloudEvent> {
    private com.inet.drive.server.persistence.c aI;
    private final DriveEntry aJ = new d();
    @Nonnull
    private m aK;
    private List<DriveObserver> aL = Collections.unmodifiableList(new ArrayList());
    private com.inet.drive.server.search.a aM;
    private final com.inet.drive.server.search.b aN = new com.inet.drive.server.search.b();
    private MemoryStoreMap<String, Object> aO = new MemoryStoreMap(30000, true);
    private MemoryStoreMap<String, DriveEntry> aP = new MemoryStoreMap(30000, true);
    private GUID aQ = GUID.generateNew();
    private final AtomicInteger aR = new AtomicInteger();

    public void H() {
        this.aI = null;
        this.aO = new MemoryStoreMap(30000, true);
        this.aP = new MemoryStoreMap(30000, true);
        this.aK = new m(this);
        this.aQ = GUID.generateNew();
        this.aL = Collections.unmodifiableList(new ArrayList());
        this.addObserver(this.J());
        this.addObserver(this.aK);
        this.addObserver(ShareManager.bU());
    }

    @Override
    @Nonnull
    public PermissionChecker getPermissionChecker() {
        return this.aK;
    }

    public MemoryStoreMap<String, Object> I() {
        return this.aO;
    }

    public a() {
        this.aK = new m(this);
        this.addObserver(new c());
        this.addObserver(this.aK);
    }

    public void a(@Nonnull com.inet.drive.server.search.a a2) {
        if (this.aM != null) {
            this.removeObserver(this.aM);
            this.aM.bM().removeSearchResultListener((SearchResultListener)this.aN);
        }
        this.aM = a2;
        this.aM.bM().addSearchResultListener((SearchResultListener)this.aN);
        this.addObserver(this.aM);
    }

    @Nonnull
    public com.inet.drive.server.search.a J() {
        if (this.aM == null) {
            this.a(com.inet.drive.server.search.a.bK());
        }
        return this.aM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DriveEntry getRoot() {
        if (this.aI == null) {
            a a2 = this;
            synchronized (a2) {
                if (this.aI == null) {
                    PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("/drive/Drive");
                    if (!persistenceEntry.exists()) {
                        com.inet.drive.server.persistence.c.a(this);
                    }
                    this.aI = new com.inet.drive.server.persistence.c("Drive", this);
                }
            }
        }
        return this.aI;
    }

    @Override
    @Nullable
    public DriveEntry resolve(@Nullable String pathOrID) {
        if (!DriveUtils.hasValidLicense()) {
            throw new AccessForbiddenException(DrivePlugin.MSG_SERVER.getMsg("drive.invalid.license", new Object[0]));
        }
        if (!SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_PERMISSION)) {
            return null;
        }
        if (pathOrID == null || pathOrID.isBlank() || pathOrID.trim().equals("/") || pathOrID.equals("Drive")) {
            return this.getRoot();
        }
        long l2 = System.currentTimeMillis();
        DriveEntry driveEntry = pathOrID.startsWith("/") ? this.b(pathOrID) : this.d(pathOrID);
        long l3 = System.currentTimeMillis() - l2;
        if (l3 > 500L) {
            DrivePlugin.LOGGER.warn((Object)("Resolving the entry with " + pathOrID + " takes too long. " + l3));
        }
        return driveEntry;
    }

    @Override
    @Nullable
    public DriveEntry resolve(@Nullable Path path) {
        if (path == null) {
            return null;
        }
        String string = path.toString().replace('\\', '/');
        return this.b(string);
    }

    @Override
    @Nonnull
    public Map<Drive.ROOT_TYPES, List<DriveEntry>> getRoots() {
        Folder folder;
        HashMap<Drive.ROOT_TYPES, List<DriveEntry>> hashMap = new HashMap<Drive.ROOT_TYPES, List<DriveEntry>>();
        hashMap.put(Drive.ROOT_TYPES.DRIVE, List.of(this.getRoot()));
        DriveEntry driveEntry = this.resolve("SharedWithMe");
        if (driveEntry != null) {
            folder = driveEntry.getFeature(DriveEntry.FOLDER);
            GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
            if (folder != null && folder.hasChildren() || gUID != null && !ShareManager.bU().n(gUID).isEmpty()) {
                hashMap.put(Drive.ROOT_TYPES.SHARED, List.of(driveEntry));
            }
        }
        if ((folder = this.aJ.getFeature(Folder.class)) != null && folder.hasChildren()) {
            hashMap.put(Drive.ROOT_TYPES.MOUNTS, folder.getChildren());
        }
        return hashMap;
    }

    public DriveEntry b(String string) {
        DriveEntry driveEntry = this.b(this.getRoot(), string);
        if (driveEntry == null && string.startsWith(com.inet.drive.server.sharing.a.gb.getPath())) {
            driveEntry = this.b((DriveEntry)com.inet.drive.server.sharing.a.gb, string.substring(com.inet.drive.server.sharing.a.gb.getPath().length()));
        }
        if (driveEntry == null) {
            driveEntry = this.b(this.aJ, string);
        }
        return driveEntry;
    }

    public DriveEntry b(DriveEntry driveEntry, String string) {
        DriveEntry driveEntry2;
        String[] stringArray;
        if (string.isBlank()) {
            return driveEntry;
        }
        if (DriveIDUtils.isID(string) && (stringArray = this.resolve(string)) != null && stringArray.getPath().startsWith(driveEntry.getPath())) {
            return stringArray;
        }
        if ("MountRoot".equals(driveEntry.getExtensionName()) && (stringArray = driveEntry.getFeature(DriveEntry.MOUNT)) != null && (driveEntry2 = stringArray.getDescription().resolve(driveEntry, "/", string)) != null && driveEntry2.exists()) {
            return new com.inet.drive.server.linked.a(driveEntry, stringArray.getDescription(), this, "/", driveEntry2.getPath());
        }
        if (driveEntry == this.getRoot() && (stringArray = this.c(string)) != null) {
            return stringArray;
        }
        if (driveEntry instanceof i) {
            return ((i)driveEntry).resolve(string);
        }
        stringArray = DriveUtils.splitPath(string);
        boolean bl = stringArray[stringArray.length - 1].isEmpty();
        if (driveEntry.hasFeature(Folder.class)) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                Folder folder = driveEntry.getFeature(Folder.class);
                if (folder == null) {
                    DrivePlugin.LOGGER.warn((Object)("No Folder for ID. " + driveEntry.getID() + " (" + driveEntry.getPath() + ")"));
                    return null;
                }
                boolean bl2 = false;
                List<DriveEntry> list = folder.getChildren();
                for (DriveEntry driveEntry3 : list) {
                    if (driveEntry3 == null || !string2.equals(driveEntry3.getName()) || !driveEntry3.hasFeature(Folder.class) && (bl || i2 != stringArray.length - 1)) continue;
                    driveEntry = driveEntry3;
                    if (driveEntry instanceof i) {
                        i i3 = (i)driveEntry;
                        Object object = "";
                        for (int i4 = i2 + 1; i4 < stringArray.length; ++i4) {
                            object = (String)object + stringArray[i4];
                            if (i4 + 1 >= stringArray.length) continue;
                            object = (String)object + "/";
                        }
                        return ((String)object).isEmpty() ? i3 : i3.resolve("/" + (String)object);
                    }
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                return null;
            }
        }
        return driveEntry;
    }

    @Nullable
    private DriveEntry c(String object) {
        Set<String> set;
        SearchCommand searchCommand = DriveUtils.getSearchCommand((String)object);
        if (!((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        if ((set = this.a(searchCommand)).size() == 1) {
            for (String string : set) {
                DriveEntry driveEntry = this.d(string);
                if (driveEntry != null && this.getPermissionChecker().hasPermission(string, false, Permissions.READ_ACCESS) && ((String)object).equals(driveEntry.getPath())) {
                    return driveEntry;
                }
                DrivePlugin.LOGGER.debug((Object)("Search returned the following ID '" + string + "', which could not be resolved."));
            }
        }
        return null;
    }

    public DriveEntry d(String string) {
        Object object;
        Object object2;
        Object object3;
        PersistenceEntry persistenceEntry;
        if (string.equals("Drive")) {
            return this.getRoot();
        }
        if (string.equals("SharedWithMe")) {
            Folder folder = com.inet.drive.server.sharing.a.gb.getFeature(DriveEntry.FOLDER);
            GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
            if (folder != null && folder.hasChildren() || gUID != null && !ShareManager.bU().n(gUID).isEmpty()) {
                return com.inet.drive.server.sharing.a.gb;
            }
            return null;
        }
        if (DriveIDUtils.isIDWithPath(string)) {
            String string2 = DriveIDUtils.extractID(string);
            String string3 = DriveIDUtils.extractPath(string);
            DriveEntry driveEntry = this.d(string2);
            if (driveEntry != null) {
                return this.b(driveEntry, string3);
            }
            return null;
        }
        if (DriveIDUtils.getSharedRootID(string) != null) {
            persistenceEntry = DriveIDUtils.getSharedRootID(string);
            object3 = com.inet.drive.server.sharing.a.gb.getFeature(DriveEntry.FOLDER);
            if (persistenceEntry != null && object3 != null) {
                object2 = object3.getChildren().iterator();
                while (object2.hasNext()) {
                    object = (DriveEntry)object2.next();
                    if (!object.getID().equals("s_" + (String)persistenceEntry)) continue;
                    String string4 = DriveIDUtils.getProviderID(string);
                    if (string4 == null) {
                        return object;
                    }
                    MountDescription mountDescription = h.gq;
                    return mountDescription.resolve((DriveEntry)object, "s_" + (String)persistenceEntry, string4);
                }
            }
        }
        if (DriveIDUtils.getMountRootID(string) != null) {
            persistenceEntry = DriveIDUtils.getMountRootID(string);
            object3 = MountManager.getInstance().getMountDescription(GUID.valueOf((String)persistenceEntry));
            if (object3 != null) {
                object2 = UserManager.getInstance().getCurrentUserAccountID();
                if (!m.a(UserManager.getInstance().getCurrentUserAccount()) && !((MountDescription)object3).getUserID().equals(object2)) {
                    return null;
                }
                object = ((MountDescription)object3).getRoot();
                String string5 = DriveIDUtils.getProviderID(string);
                if (string5 != null) {
                    return new com.inet.drive.server.linked.a((DriveEntry)object, (MountDescription)object3, this, "/", string5);
                }
                return object;
            }
            return null;
        }
        if (string.startsWith("/")) {
            return null;
        }
        if (!DriveIDUtils.hasMoreIDs(string)) {
            if (!DriveIDUtils.isID(string)) {
                return null;
            }
            persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("/drive/" + e.y(string));
            if (persistenceEntry.exists() && string.length() > 3) {
                return this.e(string);
            }
        }
        if ((object2 = DriveIDUtils.getMountBaseID((String)(object3 = (persistenceEntry = DriveIDUtils.splittID(string))[0]))) == null) {
            return null;
        }
        object = null;
        for (int i2 = 1; i2 < ((PersistenceEntry)persistenceEntry).length; ++i2) {
            object = object == null ? persistenceEntry[i2] : DriveIDUtils.mergeID((String)object, new String[]{persistenceEntry[i2]});
        }
        PersistenceEntry persistenceEntry2 = Persistence.getRecoveryEnabledInstance().resolve("/drive/link/" + (String)object2);
        if (persistenceEntry2.exists()) {
            if (!this.aK.hasPermission((String)object2, false, Permissions.READ_ACCESS)) {
                return null;
            }
            DriveEntry driveEntry = (DriveEntry)this.aP.get((Object)string);
            if (driveEntry != null && object == null) {
                return driveEntry;
            }
            i i3 = new i((String)object3, this);
            if (object == null) {
                this.aP.put((Object)string, (Object)i3);
                return i3;
            }
            return i3.resolve((String)object);
        }
        return null;
    }

    @Nullable
    public DriveEntry e(@Nonnull String string) {
        if (!this.aK.hasPermission(string, false, Permissions.READ_ACCESS)) {
            return null;
        }
        DriveEntry driveEntry = (DriveEntry)this.aP.get((Object)string);
        if (driveEntry != null) {
            return driveEntry;
        }
        PersistenceEntry persistenceEntry = e.w(string);
        if (persistenceEntry.exists()) {
            com.inet.drive.server.persistence.c c2 = new com.inet.drive.server.persistence.c(string, this);
            this.aP.put((Object)string, (Object)c2);
            return c2;
        }
        return null;
    }

    private DriveEntry a(DriveEntry driveEntry) {
        if (driveEntry instanceof i) {
            return driveEntry;
        }
        Mount mount = driveEntry.getFeature(DriveEntry.MOUNT);
        if (mount == null) {
            return driveEntry;
        }
        while (mount.getChild() != null) {
            mount = mount.getChild();
        }
        return mount.getDescription().resolve(null, "/", mount.getOriginID());
    }

    private boolean a(DriveEntry driveEntry, DriveEntry driveEntry2) {
        DriveEntry driveEntry3 = this.a(driveEntry);
        DriveEntry driveEntry4 = this.a(driveEntry2);
        if (this.b(driveEntry, driveEntry2) && driveEntry3 != null && driveEntry4 != null) {
            return this.a(driveEntry2.getPath(), driveEntry3.getPath());
        }
        return false;
    }

    private boolean b(DriveEntry driveEntry, DriveEntry driveEntry2) {
        Mount mount = driveEntry.getFeature(DriveEntry.MOUNT);
        Mount mount2 = driveEntry2.getFeature(DriveEntry.MOUNT);
        if (mount != null && mount2 != null) {
            if (mount.getProviderKey().equals(mount2.getProviderKey()) && "PERSISTENCE_PROVIDER".equals(mount.getProviderKey())) {
                return true;
            }
            return mount.getDescription().getID().equals((Object)mount2.getDescription().getID());
        }
        if (mount != null && "PERSISTENCE_PROVIDER".equals(mount.getProviderKey()) || mount2 != null && "PERSISTENCE_PROVIDER".equals(mount2.getProviderKey())) {
            return true;
        }
        return mount == null && mount2 == null;
    }

    private boolean a(String string, String string2) {
        String[] stringArray = DriveUtils.splitPath(string);
        String[] stringArray2 = DriveUtils.splitPath(string2);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string3 = stringArray2.length > i2 ? stringArray2[i2] : null;
            String string4 = stringArray[i2];
            if (string3 == null || string3.isBlank()) {
                return true;
            }
            if (string3.equals(string4)) continue;
            return false;
        }
        return stringArray.length == stringArray2.length;
    }

    private boolean b(DriveEntry driveEntry) {
        if ("PERSISTENCE_PROVIDER".equals(driveEntry.getExtensionName()) || "Persistence".equals(driveEntry.getExtensionName())) {
            DriveUtils.b b2 = DriveUtils.getAllSubelements(driveEntry, this);
            for (String string : b2.t()) {
                if (this.getPermissionChecker().hasPermission(string, false, "EDITOR")) continue;
                return false;
            }
        }
        return true;
    }

    private List<DriveEntry> a(@Nonnull List<DriveEntry> list, Map<String, DriveOperationConflictException.SingleEntryConflict> map) {
        ArrayList<DriveEntry> arrayList = new ArrayList<DriveEntry>(list);
        HashSet<String> hashSet = new HashSet<String>();
        for (DriveEntry driveEntry : list) {
            DriveOperationConflictException.SingleEntryConflict singleEntryConflict = map.get(driveEntry.getID());
            if (hashSet.contains(driveEntry.getID()) || singleEntryConflict != null && (singleEntryConflict.getResolution() == DriveOperationConflictException.RESOLUTION.skip || singleEntryConflict.getResolution() == DriveOperationConflictException.RESOLUTION.skipAll)) {
                arrayList.remove(driveEntry);
            }
            hashSet.add(driveEntry.getID());
        }
        return arrayList;
    }

    @Override
    @Nullable
    public DriveEntry move(@Nonnull DriveEntry entry, @Nonnull DriveEntry target, @Nullable List<DriveOperationConflictException.SingleEntryConflict> conflictResolutions, boolean onlyConflict, @Nullable OperationProgressListener listener) throws DriveOperationConflictException {
        List<DriveEntry> list = this.move(List.of(entry), target, conflictResolutions, onlyConflict, listener);
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<DriveEntry> move(@Nonnull List<DriveEntry> entries, @Nonnull DriveEntry target, List<DriveOperationConflictException.SingleEntryConflict> conflictResolutions, boolean onlyConflict, OperationProgressListener listener) throws DriveOperationConflictException {
        try {
            List<Object> list;
            DriveUtils.startOperation(DriveUtils.a.Q);
            Map<String, DriveOperationConflictException.SingleEntryConflict> map = this.b(conflictResolutions);
            entries = this.a(entries, map);
            if (!onlyConflict) {
                list = this.a(entries, target, map, false);
                if (!list.isEmpty()) {
                    throw new DriveOperationConflictException(false, list);
                }
                for (DriveEntry object2 : entries) {
                    if (this.a(object2, target)) {
                        throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(object2.getID(), DriveOperationConflictException.CONFLICT.samepath));
                    }
                    if (this.b(object2)) continue;
                    throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(object2.getID(), DriveOperationConflictException.CONFLICT.protectedChild));
                }
            }
            list = new ArrayList();
            @Nonnull ArrayList<E> arrayList = new ArrayList();
            b b2 = this.a(entries, listener);
            for (DriveEntry driveEntry : entries) {
                DriveEntry driveEntry2 = this.a(driveEntry, target, map, arrayList, b2, true);
                if (driveEntry2 == null) continue;
                list.add(driveEntry2);
            }
            if (!arrayList.isEmpty()) {
                throw new DriveOperationConflictException(true, arrayList);
            }
            List<Object> list2 = !list.isEmpty() ? list : null;
            return list2;
        }
        finally {
            DriveUtils.startOperation(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private DriveEntry a(@Nonnull DriveEntry driveEntry, @Nonnull DriveEntry driveEntry2, Map<String, DriveOperationConflictException.SingleEntryConflict> map, List<DriveOperationConflictException.SingleEntryConflict> list, @Nonnull b b2, boolean bl) {
        DriveOperationConflictException.SingleEntryConflict singleEntryConflict = map.get(driveEntry.getID());
        if (singleEntryConflict != null && singleEntryConflict.getResolution() == DriveOperationConflictException.RESOLUTION.skip) {
            return null;
        }
        b2.c(driveEntry);
        String string = driveEntry2.getPath();
        DriveEntry driveEntry3 = null;
        try {
            Object object;
            String string2 = string + (!string.endsWith("/") ? "/" : "") + driveEntry.getName();
            DriveEntry driveEntry4 = this.resolve(string2);
            if (driveEntry4 == null) {
                object = UserAccountScope.createPrivileged();
                try {
                    driveEntry4 = this.b(string2);
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
                if (driveEntry4 != null) {
                    list.add(new DriveOperationConflictException.SingleEntryConflict(driveEntry.getID(), DriveOperationConflictException.CONFLICT.writeProtected));
                    return null;
                }
            }
            if (driveEntry4 == null) {
                if (this.c(driveEntry, driveEntry2)) {
                    b2.a(driveEntry.getPath(), driveEntry2.getPath(), null);
                    e.a(driveEntry, (com.inet.drive.server.persistence.c)driveEntry2);
                    return this.a(driveEntry, b2, bl);
                }
                DriveUtils.startOperation(null);
                object = this.a(driveEntry, driveEntry2, map, list, b2);
                try {
                    driveEntry.delete(b2);
                    return object;
                }
                catch (Throwable throwable) {
                    DrivePlugin.LOGGER.warn((Object)("Error after move operation for delete the source entry " + String.valueOf(throwable)));
                }
                return object;
            }
            if (singleEntryConflict == null) {
                list.add(DriveOperationConflictException.createAlreadyExistConflict(driveEntry4.getID(), driveEntry.getID(), driveEntry4.getName(), driveEntry4.getPath(), driveEntry4.hasFeature(Folder.class)));
                return null;
            }
            if (singleEntryConflict.getResolution() == DriveOperationConflictException.RESOLUTION.rename && this.c(driveEntry, driveEntry2)) {
                object = ResolveRenameHandler.getRenameName(driveEntry.getName(), driveEntry2);
                b2.a(driveEntry.getPath(), driveEntry2.getPath() + (String)object, DriveOperationConflictException.RESOLUTION.rename);
                return this.a(this.a(driveEntry, driveEntry2, list, (String)object, b2, bl), b2, bl);
            }
            if (driveEntry.hasFeature(DriveEntry.FOLDER)) {
                Object object2;
                if (singleEntryConflict.getResolution() == DriveOperationConflictException.RESOLUTION.rename) {
                    object = driveEntry2;
                    object2 = ResolveRenameHandler.getRenameName(driveEntry.getName(), (DriveEntry)object);
                    b2.a(driveEntry.getPath(), object.getPath() + (String)object2, DriveOperationConflictException.RESOLUTION.rename);
                    Folder folder = object.getFeature(Folder.class);
                    if (folder == null) {
                        this.a(driveEntry, list, "Move + Rename operation. Parent has no Folder feature, an other process deleted the files/folders ?");
                        return null;
                    }
                    driveEntry4 = folder.createChild((String)object2);
                } else {
                    b2.a(driveEntry.getPath(), driveEntry4.getPath(), DriveOperationConflictException.RESOLUTION.overwrite);
                }
                this.d(driveEntry, driveEntry4);
                object = driveEntry.getFeature(Folder.class);
                if (object == null) {
                    this.a(driveEntry, list, "The entry that has Folder feature, didn't return the folder");
                    return driveEntry3;
                }
                object2 = object.getChildren().iterator();
                while (true) {
                    if (!object2.hasNext()) {
                        driveEntry3 = this.a(driveEntry4, b2, bl);
                        driveEntry.delete(b2);
                        return driveEntry3;
                    }
                    DriveEntry driveEntry5 = (DriveEntry)object2.next();
                    map.put(driveEntry5.getID(), new DriveOperationConflictException.SingleEntryConflict(driveEntry5.getID(), singleEntryConflict.getResolution()));
                    this.a(driveEntry5, driveEntry4, map, list, b2, false);
                }
            }
            object = driveEntry.getFeature(DriveEntry.CONTENT);
            if (object == null) {
                list.add(new DriveOperationConflictException.SingleEntryConflict(driveEntry.getID(), DriveOperationConflictException.CONFLICT.format));
                return driveEntry3;
            }
            try (InputStream inputStream = object.getInputStream();){
                if (inputStream != null) {
                    if (singleEntryConflict.getResolution() == DriveOperationConflictException.RESOLUTION.rename) {
                        String string3 = ResolveRenameHandler.getRenameName(driveEntry.getName(), driveEntry2);
                        DataEntry dataEntry = new DataEntry(string3, inputStream);
                        dataEntry.setListener(b2.getUploadListener());
                        driveEntry3 = this.createFile(string, dataEntry);
                    } else {
                        b2.a(driveEntry.getPath(), string, singleEntryConflict.getResolution());
                        driveEntry4.runFeature(DriveEntry.CONTENT, content -> content.setInputStream(inputStream, b2.getUploadListener()));
                        driveEntry3 = driveEntry4;
                    }
                    driveEntry3 = this.a(driveEntry3, b2, bl);
                    driveEntry.delete(null);
                    return driveEntry3;
                }
                this.a(driveEntry, list, "The moved file was deleted");
                DriveEntry driveEntry6 = null;
                return driveEntry6;
            }
        }
        catch (Throwable throwable) {
            this.a(throwable, driveEntry, list);
        }
        return driveEntry3;
    }

    private boolean c(DriveEntry driveEntry, DriveEntry driveEntry2) {
        return (driveEntry instanceof com.inet.drive.server.persistence.c || driveEntry instanceof i) && driveEntry2 instanceof com.inet.drive.server.persistence.c;
    }

    private DriveEntry a(DriveEntry driveEntry, b b2, boolean bl) {
        if (bl) {
            com.inet.drive.server.eventlog.a.bC.a(driveEntry, b2.N());
            DriveUtils.startOperation(null);
        }
        return driveEntry;
    }

    private DriveEntry a(DriveEntry driveEntry, DriveEntry driveEntry2, List<DriveOperationConflictException.SingleEntryConflict> list, String string, b b2, boolean bl) throws DriveOperationConflictException {
        b2.a(driveEntry.getPath(), driveEntry2.getPath() + string, null);
        MetaData metaData = driveEntry.getFeature(DriveEntry.META_DATA);
        if (metaData == null) {
            this.a(driveEntry, list, "Move + Rename operation. Metadata not found, an other process deleted the files/folders ?");
            return null;
        }
        metaData.setMetaData(MetaData.NAME, string);
        e.a(driveEntry, (com.inet.drive.server.persistence.c)driveEntry2);
        return driveEntry;
    }

    @Override
    @Nullable
    public DriveEntry copy(@Nonnull DriveEntry entry, @Nonnull DriveEntry target, List<DriveOperationConflictException.SingleEntryConflict> conflictResolutions, boolean onlyConflict, @Nullable OperationProgressListener listener) throws DriveOperationConflictException {
        List<DriveEntry> list = this.copy(List.of(entry), target, conflictResolutions, onlyConflict, listener);
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<DriveEntry> copy(@Nonnull List<DriveEntry> entries, @Nonnull DriveEntry target, List<DriveOperationConflictException.SingleEntryConflict> conflictResolutions, boolean onlyConflict, OperationProgressListener listener) throws DriveOperationConflictException {
        try {
            Object object;
            DriveUtils.startOperation(DriveUtils.a.P);
            Map<String, DriveOperationConflictException.SingleEntryConflict> map = this.b(conflictResolutions);
            entries = this.a(entries, map);
            if (!onlyConflict && !(object = this.a(entries, target, map, true)).isEmpty()) {
                throw new DriveOperationConflictException(false, (List<DriveOperationConflictException.SingleEntryConflict>)object);
            }
            object = this.a(entries, listener);
            ArrayList<DriveEntry> arrayList = new ArrayList<DriveEntry>();
            ArrayList<DriveOperationConflictException.SingleEntryConflict> arrayList2 = new ArrayList<DriveOperationConflictException.SingleEntryConflict>();
            for (DriveEntry driveEntry : entries) {
                DriveEntry driveEntry2 = this.a(driveEntry, target, map, arrayList2, (b)object);
                if (driveEntry2 == null) continue;
                arrayList.add(driveEntry2);
                com.inet.drive.server.eventlog.a.bD.a(driveEntry2, ((b)object).N());
            }
            if (!arrayList2.isEmpty()) {
                throw new DriveOperationConflictException(true, arrayList2);
            }
            ArrayList<DriveEntry> arrayList3 = !arrayList.isEmpty() ? arrayList : null;
            return arrayList3;
        }
        finally {
            DriveUtils.startOperation(null);
        }
    }

    @Nonnull
    private b a(List<DriveEntry> list, OperationProgressListener operationProgressListener) {
        HashSet<String> hashSet = new HashSet<String>();
        for (DriveEntry driveEntry : list) {
            hashSet.addAll(DriveUtils.getAllSubelements(driveEntry, this).t());
        }
        b b2 = new b(operationProgressListener);
        b2.operateElements(hashSet);
        return b2;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Nullable
    private DriveEntry a(@Nonnull DriveEntry var1_1, @Nonnull DriveEntry var2_2, Map<String, DriveOperationConflictException.SingleEntryConflict> var3_3, List<DriveOperationConflictException.SingleEntryConflict> var4_4, @Nonnull b var5_5) {
        block45: {
            block46: {
                block47: {
                    block43: {
                        if (!this.a(var5_5, var1_1)) {
                            DrivePlugin.LOGGER.debug((Object)("Skip because not an operating entry = " + var1_1.getPath() + "\tshould operate " + this.a(var5_5, var1_1)));
                            return null;
                        }
                        var6_6 = var3_3.get(var1_1.getID());
                        if (var6_6 != null && var6_6.getResolution() == DriveOperationConflictException.RESOLUTION.skip) {
                            DrivePlugin.LOGGER.debug((Object)("Skip because of user decision entry = " + var1_1.getPath()));
                            return null;
                        }
                        var5_5.c(var1_1);
                        var7_7 = var2_2.getPath();
                        var8_8 = null;
                        var9_9 = var7_7 + (var7_7.endsWith("/") == false ? "/" : "") + var1_1.getName();
                        var10_11 = null;
                        try {
                            var10_11 = this.resolve(var9_9);
                            if (var10_11 != null || var2_2.getMetaData(MetaData.HOMEFOLDER) != null) break block43;
                            var11_12 = UserAccountScope.createPrivileged();
                            try {
                                var10_11 = this.b(var9_9);
                            }
                            finally {
                                if (var11_12 != null) {
                                    var11_12.close();
                                }
                            }
                            if (var10_11 != null) {
                                var4_4.add(new DriveOperationConflictException.SingleEntryConflict(var1_1.getID(), DriveOperationConflictException.CONFLICT.writeProtected));
                                return null;
                            }
                        }
                        catch (MountManager.b var11_13) {
                            DrivePlugin.LOGGER.debug((Object)("Skip because target didn't exist = " + var1_1.getPath()));
                        }
                        catch (Throwable var11_14) {
                            ErrorCode.throwAny((Throwable)var11_14);
                        }
                    }
                    var11_15 = false;
                    if (!(var10_11 != null && var10_11.exists() || (var12_17 = this.a(var1_1, var7_7, var5_5)) == null)) {
                        var11_15 = true;
                        var8_8 = var10_11 = var12_17;
                        var5_5.a(var1_1.getPath(), var12_17.getPath(), null);
                    }
                    if (var10_11 == null) break block45;
                    if (var1_1.hasFeature(DriveEntry.FOLDER) && !"LINKED_ROOT".equals(var10_11.getExtensionName())) {
                        if (var6_6 != null && var6_6.getResolution() == DriveOperationConflictException.RESOLUTION.rename && (var12_17 = var10_11.getParent()) != null) {
                            var13_19 = ResolveRenameHandler.getRenameName(var1_1.getName(), (DriveEntry)var12_17);
                            var14_21 = var12_17.getFeature(Folder.class);
                            if (var14_21 != null) {
                                var10_11 = var14_21.createChild(var13_19);
                                var5_5.a(var1_1.getPath(), var10_11.getPath(), var6_6.getResolution());
                            } else {
                                this.a(var1_1, var4_4, "No parent found, deleted during drive operation ?");
                                return null;
                            }
                        }
                        this.d(var1_1, var10_11);
                        var12_17 = var1_1.getFeature(DriveEntry.FOLDER);
                        if (var12_17 == null) {
                            this.a(var1_1, var4_4, "No folder feature found, deleted during drive operation ?");
                            return null;
                        }
                        for (Object var14_21 : var12_17.getChildren()) {
                            if (!this.a(var5_5, var1_1)) continue;
                            var5_5.c((DriveEntry)var14_21);
                            if (var6_6 != null && var6_6.getResolution() != DriveOperationConflictException.RESOLUTION.rename) {
                                var3_3.put(var14_21.getID(), new DriveOperationConflictException.SingleEntryConflict(var14_21.getID(), var3_3.get(var1_1.getID()).getResolution()));
                            }
                            this.a((DriveEntry)var14_21, var10_11, var3_3, var4_4, var5_5);
                        }
                        var8_8 = var10_11;
                        break block45;
                    }
                    if (!var1_1.hasFeature(DriveEntry.CONTENT) || var11_15) break block45;
                    var12_17 = var3_3.get(var1_1.getID());
                    if (var12_17 == null) {
                        var4_4.add(DriveOperationConflictException.createAlreadyExistConflict(var10_11.getID(), var1_1.getID(), var10_11.getName(), var10_11.getPath(), var10_11.hasFeature(Folder.class)));
                        return null;
                    }
                    var13_20 = var1_1.getFeature(DriveEntry.CONTENT);
                    if (var13_20 == null) {
                        this.a(var1_1, var4_4, "No content feature found, deleted during drive operation ?");
                        return null;
                    }
                    if (var12_17.getResolution() != DriveOperationConflictException.RESOLUTION.rename) ** GOTO lbl106
                    var14_22 = ResolveRenameHandler.getRenameName(var1_1.getName(), var2_2);
                    var15_24 = var13_20.getInputStream();
                    if (var15_24 != null) break block46;
                    this.a(var1_1, var4_4, "No content stream found, deleted during drive operation ?");
                    var16_26 = null;
                    if (var15_24 == null) break block47;
                    var15_24.close();
                }
                return var16_26;
            }
            try {
                var16_27 = new DataEntry(var14_22, var15_24);
                var16_27.setListener(var5_5.getUploadListener());
                var8_8 = this.createFile(var7_7, var16_27);
                if (var8_8 != null) {
                    var5_5.a(var1_1.getPath(), var8_8.getPath(), var12_17.getResolution());
                }
                break block45;
                {
                    catch (Throwable var16_28) {
                        throw var16_28;
                    }
                }
                finally {
                    if (var15_24 != null) {
                        var15_24.close();
                    }
                }
lbl106:
                // 1 sources

                if (!var10_11.getID().equals(var1_1.getID())) {
                    var14_23 = var10_11.getFeature(DriveEntry.CONTENT);
                    if (var14_23 == null) {
                        this.a(var1_1, var4_4, "No target content feature found, deleted during drive operation ?");
                        return null;
                    }
                    var15_25 = var13_20.getInputStream();
                    try {
                        if (var15_25 == null) ** GOTO lbl122
                        var14_23.setInputStream(var15_25, var5_5.getUploadListener());
                        var5_5.a(var1_1.getPath(), var10_11.getPath(), var12_17.getResolution());
                    }
                    finally {
                        if (var15_25 != null) {
                            var15_25.close();
                        }
                    }
                } else {
                    var5_5.a(var1_1.getPath(), var10_11.getPath(), DriveOperationConflictException.RESOLUTION.skipSameFile);
                }
lbl122:
                // 3 sources

                var8_8 = var10_11;
            }
            catch (Exception var9_10) {
                this.a(var9_10, var1_1, var4_4);
            }
        }
        if (var8_8 == null) {
            DrivePlugin.LOGGER.warn((Object)("Unexpected operated entry = " + var1_1.getPath()));
        }
        return var8_8;
    }

    private void a(@Nonnull DriveEntry driveEntry, @Nonnull List<DriveOperationConflictException.SingleEntryConflict> list, @Nonnull String string) {
        list.add(new DriveOperationConflictException.SingleEntryConflict(driveEntry.getID(), DriveOperationConflictException.CONFLICT.exception, string));
    }

    private void a(Throwable throwable, DriveEntry driveEntry, List<DriveOperationConflictException.SingleEntryConflict> list) {
        if (throwable instanceof DriveOperationConflictException) {
            list.addAll(((DriveOperationConflictException)throwable).getConflicts());
        } else if (throwable instanceof AccessDeniedException) {
            list.add(new DriveOperationConflictException.SingleEntryConflict(driveEntry.getID(), DriveOperationConflictException.CONFLICT.writeProtected));
        } else if (throwable instanceof LockException) {
            list.add(new DriveOperationConflictException.SingleEntryConflict(driveEntry.getID(), DriveOperationConflictException.CONFLICT.locked));
        } else {
            list.add(new DriveOperationConflictException.SingleEntryConflict(driveEntry.getID(), DriveOperationConflictException.CONFLICT.exception, throwable.getMessage()));
            DrivePlugin.LOGGER.error((Object)("Exception during copy process: " + String.valueOf(throwable)));
        }
    }

    private boolean a(@Nonnull b b2, DriveEntry driveEntry) {
        return b2.M().contains(driveEntry.getID());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private DriveEntry a(DriveEntry driveEntry, String string, @Nonnull b b2) throws IOException {
        DriveEntry driveEntry2 = null;
        if ("LINKED_ROOT".equals(driveEntry.getExtensionName())) {
            DriveEntry driveEntry3 = this.f(string);
            com.inet.drive.api.feature.a a2 = driveEntry3.getFeature(DriveEntry.LINK);
            if (a2 != null) return a2.a(driveEntry.getName(), driveEntry);
            return this.createFolder(string, driveEntry.getName());
        }
        if (driveEntry.hasFeature(DriveEntry.FOLDER)) {
            return this.createFolder(string, driveEntry.getName());
        }
        if (driveEntry.hasFeature(DriveEntry.CONTENT)) {
            Content content = driveEntry.getFeature(DriveEntry.CONTENT);
            if (content == null) return driveEntry2;
            try (InputStream inputStream = content.getInputStream();){
                if (inputStream == null) return driveEntry2;
                DataEntry dataEntry = new DataEntry(driveEntry.getName(), inputStream);
                dataEntry.setListener(b2.getUploadListener());
                driveEntry2 = this.createFile(string, dataEntry);
                return driveEntry2;
            }
        } else {
            DrivePlugin.LOGGER.error((Object)("Entry has an invalid type for the copy operation. Extensionname = " + driveEntry.getExtensionName()));
        }
        return driveEntry2;
    }

    private void d(DriveEntry driveEntry, DriveEntry driveEntry2) {
        Permissions permissions;
        if (driveEntry2.getFeature(MetaData.class) != null && driveEntry2.getFeature(DriveEntry.PERMISSIONS) != null && driveEntry.getFeature(DriveEntry.PERMISSIONS) != null && driveEntry2.getFeature(DriveEntry.MOUNT) == null && driveEntry.getFeature(DriveEntry.MOUNT) == null && driveEntry2.getMetaData(MetaData.HOMEFOLDER) == null && (permissions = driveEntry2.getFeature(DriveEntry.PERMISSIONS)) != null) {
            this.a(driveEntry, permissions, true);
            this.a(driveEntry, permissions, false);
        }
    }

    private void a(DriveEntry driveEntry, Permissions permissions, boolean bl) {
        Permissions permissions2 = driveEntry.getFeature(DriveEntry.PERMISSIONS);
        if (permissions2 != null) {
            Map<GUID, Map<String, Boolean>> map = permissions2.getPermissions(bl);
            permissions.setPermissions(bl, map);
        }
    }

    private List<DriveOperationConflictException.SingleEntryConflict> a(List<DriveEntry> list, @Nullable DriveEntry driveEntry, Map<String, DriveOperationConflictException.SingleEntryConflict> map, boolean bl) {
        ArrayList<DriveOperationConflictException.SingleEntryConflict> arrayList = new ArrayList<DriveOperationConflictException.SingleEntryConflict>();
        if (list.isEmpty()) {
            return arrayList;
        }
        if (driveEntry == null) {
            arrayList.add(new DriveOperationConflictException.SingleEntryConflict("", DriveOperationConflictException.CONFLICT.targetNotFound));
            return arrayList;
        }
        if (driveEntry.hasFeature(DriveEntry.CONTENT)) {
            arrayList.addAll(map.values());
            if (list.size() > 1) {
                for (DriveEntry driveEntry2 : list) {
                    arrayList.add(new DriveOperationConflictException.SingleEntryConflict(driveEntry2.getID(), DriveOperationConflictException.CONFLICT.format));
                }
                return arrayList;
            }
            DriveEntry driveEntry3 = list.get(0);
            DriveOperationConflictException.SingleEntryConflict singleEntryConflict = !driveEntry3.hasFeature(DriveEntry.CONTENT) ? new DriveOperationConflictException.SingleEntryConflict(driveEntry.getID(), driveEntry3.getID(), DriveOperationConflictException.CONFLICT.format) : this.a(driveEntry3, driveEntry, map);
            if (singleEntryConflict != null) {
                arrayList.add(singleEntryConflict);
            }
            return arrayList;
        }
        Stack<a> stack = new Stack<a>();
        for (DriveEntry driveEntry4 : list) {
            stack.add(new a(driveEntry4, driveEntry));
        }
        while (!stack.isEmpty()) {
            Folder folder;
            DriveEntry driveEntry4;
            a a2 = (a)stack.pop();
            driveEntry4 = a2.K();
            if (!this.getPermissionChecker().hasPermission(a2.L().getID(), false, "EDITOR")) {
                this.a(arrayList, new DriveOperationConflictException.SingleEntryConflict(driveEntry4.getID(), a2.L().getID(), DriveOperationConflictException.CONFLICT.writeProtected), map);
                continue;
            }
            if (!bl && this.a(driveEntry4, a2.L())) {
                if (map.containsKey(a2.L().getID()) && map.get(a2.L().getID()).getResolution() != null) continue;
                arrayList.add(new DriveOperationConflictException.SingleEntryConflict(driveEntry4.getID(), a2.L().getID(), DriveOperationConflictException.CONFLICT.samepath));
            }
            if ((folder = a2.L().getFeature(DriveEntry.FOLDER)) == null) continue;
            List<DriveEntry> list2 = folder.getChildren();
            for (DriveEntry driveEntry5 : list2) {
                DriveOperationConflictException.SingleEntryConflict singleEntryConflict;
                if (!driveEntry4.getName().equals(driveEntry5.getName()) || map.containsKey(driveEntry5.getID()) && map.get(driveEntry5.getID()).getResolution() != null || (singleEntryConflict = this.a(driveEntry4, driveEntry5, map)) == null) continue;
                arrayList.add(singleEntryConflict);
            }
        }
        return arrayList;
    }

    private void a(ArrayList<DriveOperationConflictException.SingleEntryConflict> arrayList, DriveOperationConflictException.SingleEntryConflict singleEntryConflict, Map<String, DriveOperationConflictException.SingleEntryConflict> map) {
        if (!map.containsKey(singleEntryConflict.getExistingEntryID())) {
            arrayList.add(singleEntryConflict);
        }
    }

    @Nullable
    private DriveOperationConflictException.SingleEntryConflict a(DriveEntry driveEntry, DriveEntry driveEntry2, Map<String, DriveOperationConflictException.SingleEntryConflict> map) {
        if (map.containsKey(driveEntry.getID()) || map.containsKey(driveEntry2.getID())) {
            return null;
        }
        if (driveEntry.getName().equals(driveEntry2.getName())) {
            if (driveEntry.hasFeature(DriveEntry.CONTENT) && driveEntry2.hasFeature(DriveEntry.CONTENT)) {
                if (this.getPermissionChecker().hasPermission(driveEntry2.getID(), false, "EDITOR")) {
                    return DriveOperationConflictException.createAlreadyExistConflict(driveEntry2.getID(), driveEntry.getID(), driveEntry2.getName(), driveEntry2.getPath(), false);
                }
                return new DriveOperationConflictException.SingleEntryConflict(driveEntry2.getID(), driveEntry.getID(), DriveOperationConflictException.CONFLICT.writeProtected);
            }
            if (driveEntry.hasFeature(DriveEntry.FOLDER) && driveEntry2.hasFeature(DriveEntry.FOLDER)) {
                return new DriveOperationConflictException.SingleEntryConflict(driveEntry2.getID(), driveEntry.getID(), DriveOperationConflictException.CONFLICT.alreadyExistsFolder);
            }
            return new DriveOperationConflictException.SingleEntryConflict(driveEntry2.getID(), driveEntry.getID(), DriveOperationConflictException.CONFLICT.format);
        }
        return null;
    }

    private Map<String, DriveOperationConflictException.SingleEntryConflict> b(List<DriveOperationConflictException.SingleEntryConflict> list) {
        HashMap<String, DriveOperationConflictException.SingleEntryConflict> hashMap = new HashMap<String, DriveOperationConflictException.SingleEntryConflict>();
        if (list != null) {
            for (DriveOperationConflictException.SingleEntryConflict singleEntryConflict : list) {
                if (singleEntryConflict.getResolution() == null) continue;
                if (singleEntryConflict.getReplacementEntryID() != null) {
                    hashMap.put(singleEntryConflict.getReplacementEntryID(), singleEntryConflict);
                }
                if (singleEntryConflict.getExistingEntryID() == null) continue;
                hashMap.put(singleEntryConflict.getExistingEntryID(), singleEntryConflict);
            }
        }
        return hashMap;
    }

    private Set<String> a(SearchCommand searchCommand) {
        Set set = this.J().bM().simpleSearch(searchCommand);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!this.getPermissionChecker().hasPermission(string, false, "VIEWER")) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    @Nonnull
    public SearchResult<String> search(@Nonnull SearchCommand searchCommand) {
        SearchResult searchResult = this.J().bM().search(searchCommand);
        ArrayList<SearchResultEntry> arrayList = new ArrayList<SearchResultEntry>();
        block11: for (final SearchResultEntry searchResultEntry : searchResult.getEntries()) {
            String string;
            if (this.getPermissionChecker().hasPermission((String)searchResultEntry.getId(), false, "VIEWER")) {
                arrayList.add(searchResultEntry);
                continue;
            }
            UserAccountScope userAccountScope = UserAccountScope.createPrivileged();
            try {
                DriveEntry driveEntry = this.d((String)searchResultEntry.getId());
                if (driveEntry == null) continue;
                string = driveEntry.getPath();
            }
            finally {
                if (userAccountScope == null) continue;
                userAccountScope.close();
                continue;
            }
            userAccountScope = Persistence.getRecoveryEnabledInstance().resolve("/drive/link/");
            for (PersistenceEntry persistenceEntry : userAccountScope.getChildren()) {
                String string2 = persistenceEntry.getName();
                if (!this.getPermissionChecker().hasPermission(string2, false, "VIEWER")) continue;
                final i i2 = new i(string2, this);
                UserAccountScope userAccountScope2 = UserAccountScope.createPrivileged();
                try {
                    DriveEntry driveEntry = i2.getDescription().resolve(null);
                    if (driveEntry == null || !string.startsWith(driveEntry.getPath())) continue;
                    arrayList.add(new SearchResultEntry<String>(){

                        public String getId() {
                            return DriveIDUtils.mergeID(i2.getID(), (String)searchResultEntry.getId());
                        }

                        public String getFirstResultLine() {
                            return searchResultEntry.getFirstResultLine();
                        }

                        public String getSecondResultLine() {
                            return searchResultEntry.getSecondResultLine();
                        }

                        public Set<String> getMatchedFields() {
                            return searchResultEntry.getMatchedFields();
                        }

                        public void setDisplayName(@Nullable Comparable value) {
                            searchResultEntry.setDisplayName(value);
                        }

                        public void setFieldsInculdeInDisplayName(List<String> includedFields) {
                            searchResultEntry.setFieldsInculdeInDisplayName(includedFields);
                        }

                        public void setFieldKeyForSecondResultLine(String fieldKeyForSecondResultLine) {
                            searchResultEntry.setFieldKeyForSecondResultLine(fieldKeyForSecondResultLine);
                        }

                        public void setResultLinesFactory(ResultLineFactory resultLineFactory) {
                            searchResultEntry.setResultLinesFactory(resultLineFactory);
                        }

                        public void setCacheEntry(Map<String, Object> cacheEntry) {
                            searchResultEntry.setCacheEntry(cacheEntry);
                        }

                        public int a(SearchResultEntry<String> searchResultEntry2) {
                            return searchResultEntry.compareTo(searchResultEntry2);
                        }

                        public /* synthetic */ int compareTo(Object object) {
                            return this.a((SearchResultEntry<String>)((SearchResultEntry)object));
                        }
                    });
                    continue block11;
                }
                finally {
                    if (userAccountScope2 == null) continue block11;
                    userAccountScope2.close();
                    continue block11;
                }
            }
        }
        return new SearchResult(arrayList, searchResult.isPartialResult());
    }

    @Nonnull
    private DriveEntry f(String string) throws DriveOperationConflictException {
        String[] stringArray;
        DriveEntry driveEntry = this.resolve(string);
        if (driveEntry != null) {
            return driveEntry;
        }
        driveEntry = this.getRoot();
        for (String string2 : stringArray = DriveUtils.splitPath(string)) {
            if (string2.isEmpty() || !driveEntry.hasFeature(Folder.class)) continue;
            Folder folder = driveEntry.getFeature(Folder.class);
            boolean bl = false;
            if (folder == null) continue;
            for (DriveEntry driveEntry2 : folder.getChildren()) {
                if (!driveEntry2.getName().equals(string2) || !driveEntry2.hasFeature(Folder.class)) continue;
                driveEntry = driveEntry2;
                bl = true;
                break;
            }
            if (bl) continue;
            driveEntry = folder.createChild(string2);
        }
        return driveEntry;
    }

    @Override
    public DriveEntry createFolder(@Nonnull String parentPathOrID, @Nonnull String name) throws DriveOperationConflictException {
        DriveEntry driveEntry = this.f(parentPathOrID);
        Folder folder = driveEntry.getFeature(Folder.class);
        if (folder != null) {
            DriveEntry driveEntry2 = folder.createChild(name);
            this.aP.put((Object)driveEntry2.getID(), (Object)driveEntry2);
            return driveEntry2;
        }
        return null;
    }

    @Override
    public DriveEntry createFile(@Nonnull String parentPathOrID, @Nonnull DataEntry dataEntry) throws DriveOperationConflictException {
        DriveEntry driveEntry = this.f(parentPathOrID);
        Folder folder = driveEntry.getFeature(Folder.class);
        if (folder != null) {
            DriveEntry driveEntry2 = folder.createChild(dataEntry);
            this.aP.put((Object)driveEntry2.getID(), (Object)driveEntry2);
            return driveEntry2;
        }
        return null;
    }

    @Override
    public synchronized void addObserver(@Nonnull DriveObserver observer) {
        if (this.aL.contains(observer)) {
            return;
        }
        ArrayList<DriveObserver> arrayList = new ArrayList<DriveObserver>();
        for (DriveObserver driveObserver : this.aL) {
            if (!driveObserver.synchronizedEvent()) continue;
            arrayList.add(driveObserver);
        }
        if (observer.synchronizedEvent()) {
            arrayList.add(observer);
        }
        for (DriveObserver driveObserver : this.aL) {
            if (driveObserver.synchronizedEvent()) continue;
            arrayList.add(driveObserver);
        }
        if (!observer.synchronizedEvent()) {
            arrayList.add(observer);
        }
        this.aL = Collections.unmodifiableList(arrayList);
    }

    @Override
    public synchronized void removeObserver(@Nonnull DriveObserver observer) {
        if (!this.aL.contains(observer)) {
            return;
        }
        ArrayList<DriveObserver> arrayList = new ArrayList<DriveObserver>(this.aL);
        arrayList.remove(observer);
        this.aL = Collections.unmodifiableList(arrayList);
    }

    @Override
    public <T> void notifyObservers(@Nonnull DriveObserver.EventType<T> type, @Nonnull T eventData) {
        this.a(type, eventData);
        Persistence.getRecoveryEnabledInstance().sendEvent((Object)new PersistenceCloudEvent(this.aQ, type, eventData));
    }

    public <T> void a(DriveObserver.EventType<T> eventType, T t2) {
        this.aR.incrementAndGet();
        if (DrivePlugin.LOGGER.isDebug()) {
            if (t2 instanceof DriveEntry) {
                DrivePlugin.LOGGER.debug((Object)("Event Received: " + String.valueOf(eventType) + "\tdata: " + ((DriveEntry)t2).getID()));
            } else {
                DrivePlugin.LOGGER.debug((Object)("Event Received: " + String.valueOf(eventType) + "\tdata: " + String.valueOf(t2)));
            }
        }
        for (DriveObserver driveObserver : this.aL) {
            if (!driveObserver.isValid()) continue;
            if (driveObserver.synchronizedEvent()) {
                driveObserver.changed(eventType, t2);
                continue;
            }
            this.aR.incrementAndGet();
            ForkJoinPool.commonPool().execute(() -> {
                try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                    driveObserver.changed(eventType, t2);
                }
                catch (Throwable throwable) {
                    DrivePlugin.LOGGER.error("An event occured an error: ", throwable);
                }
                finally {
                    this.aR.decrementAndGet();
                }
            });
        }
        this.aR.decrementAndGet();
    }

    public <T> void b(DriveObserver.EventType<T> eventType, T t2) {
        for (DriveObserver driveObserver : this.aL) {
            if (!driveObserver.isValid() || driveObserver == this.J()) continue;
            driveObserver.changed(eventType, t2);
        }
    }

    public void a(@Nonnull PersistenceCloudEvent persistenceCloudEvent) {
        if (!this.aQ.equals((Object)persistenceCloudEvent.getPersistenceID())) {
            ThreadPool.DEFAULT.startSubThread(() -> {
                if (DriveObserver.EventType.MODIFIED == persistenceCloudEvent.getEventType()) {
                    this.b(persistenceCloudEvent.getEventType(), persistenceCloudEvent.getMetaDataChangeEvent());
                } else {
                    DriveObserver.EventType<?> eventType = persistenceCloudEvent.getEventType();
                    if (eventType == DriveObserver.EventType.REMOVED) {
                        this.b(DriveObserver.EventType.REMOVED, persistenceCloudEvent.getRemoveEvent());
                    } else if (eventType == DriveObserver.EventType.REFRESH) {
                        this.b(DriveObserver.EventType.REFRESH, new GUID(persistenceCloudEvent.getEntryID()));
                    } else if (eventType == DriveObserver.EventType.SHARE) {
                        if (persistenceCloudEvent.getShareEvent() == null) {
                            DrivePlugin.LOGGER.debug((Object)"Cloud Share event was null");
                        } else {
                            this.b(DriveObserver.EventType.SHARE, persistenceCloudEvent.getShareEvent());
                        }
                    } else {
                        DriveEntry driveEntry;
                        if (persistenceCloudEvent.getEntryID().startsWith("m_")) {
                            driveEntry = new com.inet.drive.api.mount.a(persistenceCloudEvent.getEntryID(), persistenceCloudEvent.getParentID(), persistenceCloudEvent.isFolder());
                        } else {
                            driveEntry = this.e(persistenceCloudEvent.getEntryID());
                            int n2 = 500;
                            while (driveEntry == null) {
                                if (n2 < 0) {
                                    return;
                                }
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    throw new RuntimeException(interruptedException);
                                }
                                driveEntry = this.e(persistenceCloudEvent.getEntryID());
                                n2 -= 10;
                            }
                        }
                        this.b(eventType, driveEntry);
                    }
                }
            }, (RunnableSession)new BaseRunnableSession(UserManager.PRIVILEGED_ACCOUNT_ID));
        }
    }

    public /* synthetic */ void eventReceived(@Nonnull Object object) {
        this.a((PersistenceCloudEvent)object);
    }

    static class d
    implements DriveEntry {
        private static final List<Class<? extends DriveFeature>> at = new ArrayList<Class<? extends DriveFeature>>();

        d() {
        }

        @Override
        @Nonnull
        public String getPath() {
            return "";
        }

        @Override
        @Nonnull
        public String getName() {
            return "";
        }

        @Override
        @Nonnull
        public String getID() {
            return "MountID";
        }

        @Override
        public long getLastModified() throws DriveIOException {
            return 0L;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean hasFeature(@Nonnull Class<? extends DriveFeature> type) throws DriveIOException {
            return at.contains(type);
        }

        @Override
        @Nullable
        public <T extends DriveFeature> T getFeature(@Nonnull Class<T> type) throws DriveIOException {
            if (type == Folder.class) {
                return (T)new Folder(){

                    @Override
                    @Nonnull
                    public List<DriveEntry> getChildren() {
                        ArrayList<DriveEntry> arrayList = new ArrayList<DriveEntry>();
                        if (!SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_MOUNT_PERMISSION)) {
                            return arrayList;
                        }
                        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
                        if (userAccount != null) {
                            List<MountDescription> list = MountManager.getInstance().getMountDescriptions(userAccount.getID());
                            for (MountDescription mountDescription : list) {
                                if (("PERSISTENCE_PROVIDER".equals(mountDescription.getProvider()) || "sharing".equals(mountDescription.getProvider())) && mountDescription.getName().isBlank()) continue;
                                arrayList.add(mountDescription.getRoot());
                            }
                        }
                        return arrayList;
                    }

                    @Override
                    public boolean hasChildren() {
                        return !this.getChildren().isEmpty();
                    }

                    @Override
                    @Nonnull
                    public DriveEntry createChild(@Nonnull String name) throws DriveOperationConflictException {
                        throw new IllegalArgumentException("This entry is only for interal usage");
                    }

                    @Override
                    @Nonnull
                    public DriveEntry createChild(@Nonnull DataEntry dataEntry) throws DriveOperationConflictException {
                        throw new IllegalArgumentException("This entry is only for interal usage");
                    }
                };
            }
            return null;
        }

        @Override
        @Nullable
        public DriveEntry getParent() {
            return null;
        }

        @Override
        public void delete(@Nullable OperationProgressListener listener) throws DriveOperationConflictException {
        }

        @Override
        @Nonnull
        public String getExtensionName() {
            return "";
        }

        static {
            at.add(Folder.class);
        }
    }

    class c
    implements DriveObserver {
        c() {
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public boolean synchronizedEvent() {
            return true;
        }

        @Override
        public <T> void changed(@Nonnull DriveObserver.EventType<T> type, @Nonnull T eventData) {
            if (type == DriveObserver.EventType.MODIFIED) {
                DriveObserver.EventType.MetaDataChange metaDataChange = (DriveObserver.EventType.MetaDataChange)eventData;
                if (metaDataChange.getNewValue() == null) {
                    a.this.I().remove((Object)DriveUtils.getCacheEntry(metaDataChange.getID(), metaDataChange.getMetaKey().getKey()));
                } else {
                    a.this.I().put((Object)DriveUtils.getCacheEntry(metaDataChange.getID(), metaDataChange.getMetaKey().getKey()), metaDataChange.getNewValue());
                }
            } else if (type == DriveObserver.EventType.REMOVED) {
                String string = ((DriveObserver.EventType.RemoveEvent)eventData).getId();
                for (MetaKey<?> metaKey : com.inet.drive.server.search.c.bR()) {
                    a.this.I().remove((Object)DriveUtils.getCacheEntry(string, metaKey.getKey()));
                }
                a.this.aP.remove((Object)string);
            }
        }
    }

    static class b
    implements OperationProgressListener {
        private final OperationProgressListener aX;
        private HashSet<String> aY = new HashSet();
        private final HashSet<String> aZ = new HashSet();
        private final HashSet<OperationEntryForEventLog> ba = new HashSet();

        public b(OperationProgressListener operationProgressListener) {
            this.aX = operationProgressListener;
        }

        public HashSet<String> M() {
            return this.aY;
        }

        @Override
        public void operateElements(HashSet<String> elements) {
            if (this.aX != null) {
                this.aX.operateElements(elements);
            }
            this.aY = elements;
        }

        @Override
        public void startOperationFor(@Nonnull String entryID) {
            if (this.aX != null && !this.aZ.contains(entryID)) {
                this.aX.startOperationFor(entryID);
            }
            this.aZ.add(entryID);
        }

        public void c(@Nonnull DriveEntry driveEntry) {
            this.startOperationFor(driveEntry.getID());
            String string = DriveIDUtils.getOriginID(driveEntry);
            if (!driveEntry.getID().equals(string)) {
                this.aZ.add(string);
            }
        }

        @Override
        @Nullable
        public UploadListener getUploadListener() {
            if (this.aX != null) {
                return this.aX.getUploadListener();
            }
            return null;
        }

        public void a(String string, String string2, @Nullable DriveOperationConflictException.RESOLUTION rESOLUTION) {
            this.ba.add(new OperationEntryForEventLog(string, string2, rESOLUTION));
        }

        public HashSet<OperationEntryForEventLog> N() {
            return this.ba;
        }
    }

    private static class a {
        private final DriveEntry aV;
        private final DriveEntry aW;

        public a(DriveEntry driveEntry, DriveEntry driveEntry2) {
            this.aV = driveEntry;
            this.aW = driveEntry2;
        }

        public DriveEntry K() {
            return this.aV;
        }

        public DriveEntry L() {
            return this.aW;
        }
    }
}

