/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api.mount;

import com.inet.annotations.InternalApi;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountProvider;
import com.inet.drive.server.persistence.e;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.ServerPluginManager;
import com.inet.thread.ServerLock;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class MountManager {
    private static MountManager ao;
    public static final Map<String, MountProvider> PROVIDERS;
    private final ConcurrentHashMap<String, Set<GUID>> ap = new ConcurrentHashMap();
    private final ConcurrentHashMap<GUID, MountDescription> aq = new ConcurrentHashMap();
    private final ConcurrentHashMap<GUID, List<String>> ar = new ConcurrentHashMap();
    private Drive as;

    @Nullable
    public static MountProvider<?> getProvider(String providerExtensionName) {
        MountProvider mountProvider = PROVIDERS.get(providerExtensionName);
        if (mountProvider == null) {
            try {
                mountProvider = (MountProvider)ServerPluginManager.getInstance().getSingleInstanceByName(MountProvider.class, providerExtensionName, false);
                PROVIDERS.put(providerExtensionName, mountProvider);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mountProvider;
    }

    public void setDrive(Drive drive) {
        this.as = drive;
    }

    private com.inet.drive.server.a C() {
        return this.as == null ? (com.inet.drive.server.a)com.inet.drive.webgui.server.a.du() : (com.inet.drive.server.a)this.as;
    }

    public static MountManager getInstance() {
        if (ao == null) {
            ao = new MountManager();
        }
        return ao;
    }

    public void reset() {
        this.ap.clear();
        this.aq.clear();
        this.ar.clear();
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("/drive/mountmanager/");
        for (PersistenceEntry persistenceEntry2 : persistenceEntry.getChildren()) {
            MountDescription mountDescription = this.c(GUID.valueOf((String)persistenceEntry2.getName()));
            if (mountDescription == null) continue;
            this.addMountsID(mountDescription.getID(), mountDescription.getName());
            this.aq.put(mountDescription.getID(), mountDescription);
            Set<GUID> set = this.ap.get(mountDescription.getUserID().toString());
            if (set == null) {
                set = this.d(mountDescription.getUserID());
                this.ap.put(mountDescription.getUserID().toString(), set);
            }
            set.add(mountDescription.getID());
            this.b(mountDescription.getUserID());
        }
    }

    MountManager() {
        this.reset();
    }

    @Nonnull
    public List<String> getMountsIDForDescriptionID(@Nonnull GUID mID) {
        List<String> list = this.ar.get(mID);
        return list == null ? new ArrayList<String>() : new ArrayList<String>(list);
    }

    public void addMountsID(GUID descriptionID, String mountID) {
        List list = this.ar.computeIfAbsent(descriptionID, gUID -> new ArrayList());
        list.add(mountID);
    }

    public void removeMountsID(@Nonnull GUID descriptionID, String mountID) {
        List<String> list = this.ar.get(descriptionID);
        if (list != null) {
            list.remove(mountID);
            if (list.isEmpty()) {
                this.ar.remove(descriptionID);
            }
        }
    }

    public MountDescription addInternalDescription(@Nonnull GUID userID) throws DriveOperationConflictException {
        return this.addMountDescription("PERSISTENCE_PROVIDER", new HashMap<String, String>(), userID, "");
    }

    public MountDescription addMountDescription(@Nonnull String provider, Map<String, String> providerConfig, @Nonnull GUID userID, String name) throws DriveOperationConflictException {
        if (!provider.equals("PERSISTENCE_PROVIDER") && !provider.equals("sharing")) {
            if (name.isBlank() || name.contains("/")) {
                throw new IllegalArgumentException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.invalidname", new Object[]{name}));
            }
            e.aZ().a(name, true, null, false);
        }
        MountDescription mountDescription = new MountDescription(provider, providerConfig, userID, name);
        mountDescription.save();
        this.aq.put(mountDescription.getID(), mountDescription);
        Set<GUID> set = this.ap.get(userID.toString());
        if (set == null) {
            set = this.d(userID);
            this.ap.put(userID.toString(), set);
        }
        set.add(mountDescription.getID());
        this.b(userID);
        this.C().notifyObservers(DriveObserver.EventType.CREATED, mountDescription.getRoot());
        return mountDescription;
    }

    public void removeMountDescription(MountDescription mountDescription) {
        GUID gUID = mountDescription.getID();
        GUID gUID2 = mountDescription.getUserID();
        Set<GUID> set = this.ap.get(gUID2.toString());
        if (set != null) {
            set.remove(gUID);
        }
        List<String> list = this.getMountsIDForDescriptionID(gUID);
        for (String string : list) {
            this.removeMountsID(gUID, string);
            try {
                this.a(string, 0);
            }
            catch (DriveOperationConflictException driveOperationConflictException) {
                Object object = "";
                for (DriveOperationConflictException.SingleEntryConflict singleEntryConflict : driveOperationConflictException.getConflicts()) {
                    object = (String)object + singleEntryConflict.getExistingEntryID() + " - " + String.valueOf((Object)singleEntryConflict.getConflict()) + "\n";
                }
                DrivePlugin.LOGGER.warn((Object)("Couldn't delete link with the id " + string + "\nProblem by delete was " + (String)object));
            }
        }
        this.b(gUID2);
        this.aq.remove(gUID);
        mountDescription.delete();
        this.C().notifyObservers(DriveObserver.EventType.REMOVED, new DriveObserver.EventType.RemoveEvent(DriveIDUtils.getMountRootID(gUID), null, mountDescription.getName()));
    }

    private void a(String string, int n2) throws DriveOperationConflictException {
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            DriveEntry driveEntry = this.C().resolve(string);
            if (driveEntry != null) {
                driveEntry.delete(null);
            }
        }
        catch (DriveOperationConflictException driveOperationConflictException) {
            if (n2 < 10) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.a(string, n2 + 1);
            }
            throw driveOperationConflictException;
        }
    }

    @Nonnull
    public List<MountDescription> getMountDescriptions(@Nullable GUID userID) {
        HashSet<MountDescription> hashSet = new HashSet<MountDescription>();
        if (userID != null) {
            Set<GUID> set = this.a(userID);
            for (GUID gUID : set) {
                MountDescription mountDescription = this.getMountDescription(gUID);
                if (mountDescription == null) continue;
                hashSet.add(mountDescription);
            }
        }
        return new ArrayList<MountDescription>(hashSet);
    }

    @Nullable
    public MountDescription getMountDescription(GUID mountID) {
        if (mountID == null) {
            return null;
        }
        MountDescription mountDescription = this.aq.get(mountID);
        if (mountDescription == null && (mountDescription = this.c(mountID)) != null) {
            this.aq.put(mountID, mountDescription);
        }
        return mountDescription;
    }

    @Nonnull
    private Set<GUID> a(GUID gUID) {
        Set<GUID> set = this.ap.get(gUID.toString());
        if (set == null) {
            set = this.d(gUID);
            this.ap.put(gUID.toString(), set);
        }
        return this.d(gUID);
    }

    public List<MountDescription> getAllMountDescriptions() {
        return new ArrayList<MountDescription>(this.aq.values());
    }

    private void b(@Nonnull GUID gUID) {
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("/drive/mountmanager/user/" + String.valueOf(gUID));
        Set<GUID> set = this.ap.get(gUID.toString());
        if (set == null || set.isEmpty()) {
            if (persistenceEntry.exists()) {
                persistenceEntry.deleteValue();
            }
        } else {
            persistenceEntry.setString(new Json().toJson(set));
        }
    }

    @Nullable
    private MountDescription c(@Nullable GUID gUID) {
        if (gUID == null) {
            return null;
        }
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("/drive/mountmanager/" + String.valueOf(gUID));
        try (ServerLock serverLock = Persistence.getRecoveryEnabledInstance().getReadLock("/drive/mountmanager/" + String.valueOf(gUID), 200L);){
            PersistenceEntry persistenceEntry2 = persistenceEntry.getCryptoInstance(gUID.toString().toCharArray(), gUID.toString().getBytes(StandardCharsets.UTF_8));
            String string = persistenceEntry2.getString();
            if (string != null && persistenceEntry.exists()) {
                MountDescription mountDescription = (MountDescription)new Json().fromJson(string, MountDescription.class);
                return mountDescription;
            }
        }
        return null;
    }

    @Nonnull
    private Set<GUID> d(@Nonnull GUID gUID) {
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("/drive/mountmanager/user/" + String.valueOf(gUID));
        String string = persistenceEntry.getString();
        if (string != null) {
            try {
                Object object = new Json().fromJson(string, (Type)new JsonParameterizedType(HashSet.class, new Type[]{GUID.class}));
                if (object != null) {
                    return (HashSet)object;
                }
            }
            catch (Exception exception) {
                DrivePlugin.LOGGER.warn((Object)exception);
            }
        }
        return new HashSet<GUID>();
    }

    static {
        PROVIDERS = ServerPluginManager.getInstance().get(MountProvider.class).stream().collect(Collectors.toMap(NamedExtension::getExtensionName, Function.identity()));
    }

    public static class a
    extends DriveIOException {
        public a(String string) {
            super(string);
        }
    }

    public static class c
    extends DriveIOException {
        public c(String string) {
            super(string);
        }
    }

    public static class d
    extends DriveIOException {
        public d(String string) {
            super(DrivePlugin.MSG_SERVER.getMsg("provider.notConnection.otherUser", new Object[]{string}));
        }

        public d(String string, String string2) {
            super(DrivePlugin.MSG_SERVER.getMsg("provider.notConnection.owner", new Object[]{string, string2}));
        }
    }

    public static class b
    extends DriveIOException {
        public b(String string) {
            super(string);
        }
    }
}

