/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.actions.share;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DrivePermission;
import com.inet.drive.api.feature.ShareAnonymLink;
import com.inet.drive.api.feature.ShareData;
import com.inet.drive.api.feature.c;
import com.inet.drive.webgui.server.actions.permissions.PermissionsData;
import com.inet.drive.webgui.server.actions.share.ShareDialogData;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
extends ServiceMethod<ShareDialogData, Void> {
    public String getMethodName() {
        return "drive.share.create";
    }

    public short getMethodType() {
        return 1;
    }

    public Void a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, ShareDialogData shareDialogData) throws IOException {
        @Nullable GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID == null) {
            throw new IllegalStateException("Only logged in users can modify or create shares");
        }
        String string = shareDialogData.getId();
        if (!SystemPermissionChecker.checkAccess((Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER, DrivePermission.DRIVE_SHARE_LINK_PERMISSION})) {
            throw new AccessDeniedException(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER);
        }
        @Nullable DriveEntry driveEntry = com.inet.drive.webgui.server.a.du().resolve(string);
        if (!(driveEntry != null && driveEntry.exists() && driveEntry.hasFeature(c.class) && com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission(driveEntry.getID(), false, "EDITOR"))) {
            throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("permissions.error.noaccess", new Object[]{string}));
        }
        @Nullable c c2 = driveEntry.getFeature(c.class);
        if (c2 == null) {
            throw new IllegalStateException("This entry cannot be shared");
        }
        if (SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_SHARE_LINK_PERMISSION)) {
            this.a(driveEntry, shareDialogData);
        }
        if (SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            List<PermissionsData.PermissionsEntry> list;
            List<PermissionsData.PermissionsEntry> list2;
            @Nullable ShareData shareData = c2.w();
            if (shareData == null) {
                shareData = new ShareData(driveEntry.getID());
            }
            if ((list2 = shareDialogData.getGroupPermissions()) != null) {
                shareData.setPermissions(true, list2.stream().collect(Collectors.toMap(permissionsEntry -> new GUID(permissionsEntry.getKey()), permissionsEntry -> new HashSet<String>(permissionsEntry.getPermissions()))));
            }
            if ((list = shareDialogData.getUserPermissions()) != null) {
                shareData.setPermissions(false, list.stream().collect(Collectors.toMap(permissionsEntry -> new GUID(permissionsEntry.getKey()), permissionsEntry -> new HashSet<String>(permissionsEntry.getPermissions()))));
            }
            if (!shareData.hasPermissions()) {
                c2.a((ShareData)null);
            } else {
                c2.a(shareData);
            }
        }
        return null;
    }

    private void a(@Nonnull DriveEntry driveEntry, @Nonnull ShareDialogData shareDialogData) {
        c c2 = driveEntry.getFeature(c.class);
        if (c2 == null) {
            return;
        }
        Map<@Nonnull String, T> map = c2.y().stream().collect(Collectors.toMap(ShareAnonymLink::getId, Function.identity()));
        for (ShareDialogData.ShareLinkData object : shareDialogData.getShareLinks()) {
            if (map.get(object.getId()) == null) {
                c2.a(object.toLink(driveEntry, (ShareAnonymLink)map.get(object.getId())));
                continue;
            }
            c2.b(object.toLink(driveEntry, (ShareAnonymLink)map.get(object.getId())));
        }
        for (String string : map.keySet()) {
            boolean bl = false;
            for (ShareDialogData.ShareLinkData shareLinkData : shareDialogData.getShareLinks()) {
                if (!string.equals(shareLinkData.getId())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            c2.a(string);
        }
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (ShareDialogData)object);
    }
}

