/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.persistence;

import com.inet.annotations.InternalApi;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DrivePermissionType;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.feature.Permission;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.server.eventlog.PermissionsChangeLog;
import com.inet.drive.server.persistence.c;
import com.inet.drive.server.persistence.e;
import com.inet.drive.server.persistence.i;
import com.inet.id.GUID;
import com.inet.lib.json.Bon;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public class PersistencePermissions
implements Permissions {
    private final c dV;
    private final String fi;
    private final String fj;
    private i fk;

    public void setMountDriveEntry(i mountDriveEntry) {
        this.fk = mountDriveEntry;
    }

    public PersistencePermissions(c entry) {
        this.dV = entry;
        this.fi = entry.u(entry.getID()) + ".puser";
        this.fj = entry.u(entry.getID()) + ".pgroup";
    }

    public PersistencePermissions(c entry, GUID userID) {
        this(entry);
        HashMap hashMap = new HashMap();
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        for (Permission permission : Permissions.getReadWriteAccess()) {
            hashMap2.put(permission.getPermissionType(), Boolean.TRUE);
        }
        hashMap.put(userID, hashMap2);
        e.a(this.fi, new Bon().toBinary(hashMap));
    }

    private void b(Map<GUID, Map<String, Boolean>> map, boolean bl) {
        Map<GUID, Map<String, Boolean>> map2 = this.getPermissions(bl);
        if (PersistencePermissions.a(map2, map)) {
            e.a(bl ? this.fj : this.fi, new Bon().toBinary(map));
            this.dV.C().notifyObservers(DriveObserver.EventType.PERMISSION, this.fk == null ? this.dV : this.fk);
            if (DriveUtils.getOperation() == null) {
                PermissionsChangeLog permissionsChangeLog = new PermissionsChangeLog(map2, map);
                if (bl) {
                    com.inet.drive.server.eventlog.a.bE.a(this.dV, permissionsChangeLog);
                } else {
                    com.inet.drive.server.eventlog.a.bF.a(this.dV, permissionsChangeLog);
                }
            }
        }
    }

    private static boolean a(Map<GUID, Map<String, Boolean>> map, Map<GUID, Map<String, Boolean>> map2) {
        if (!Objects.equals(map.keySet(), map2.keySet())) {
            return true;
        }
        for (GUID gUID : map.keySet()) {
            Map<String, Boolean> map3 = map.get(gUID);
            Map<String, Boolean> map4 = map2.get(gUID);
            if (map4 == null) {
                return true;
            }
            Set<String> set = map3.keySet();
            if (!set.equals(map4.keySet())) {
                return true;
            }
            for (String string : set) {
                Boolean bl;
                Boolean bl2 = map3.get(string);
                if (Objects.equals(bl2, bl = map4.get(string))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public Map<GUID, Map<String, Boolean>> getPermissions(boolean isGroup) {
        byte[] byArray = e.x(isGroup ? this.fj : this.fi);
        if (byArray == null || byArray.length == 0) {
            return new HashMap<GUID, Map<String, Boolean>>();
        }
        a a2 = (a)new Bon().fromBinary(byArray, a.class);
        return a2 == null ? new HashMap() : a2;
    }

    @Override
    public boolean hasPermission(@Nonnull String permissionType) {
        return this.dV.a(false, permissionType);
    }

    @Override
    public void addPermissions(@Nonnull GUID userOrGroupId, boolean isGroup, Permission ... permission) {
        this.dV.aW();
        Map<GUID, Map<String, Boolean>> map = this.getPermissions(isGroup);
        Map<String, Boolean> map2 = map.get(userOrGroupId);
        if (map2 == null) {
            map2 = new HashMap<String, Boolean>();
            map.put(userOrGroupId, map2);
            for (int i2 = 0; i2 < permission.length; ++i2) {
                if (permission[i2].isAllowed() != null && Boolean.FALSE.equals(permission[i2].isAllowed())) {
                    throw new IllegalArgumentException(DrivePlugin.MSG_SERVER.getMsg("drive.permission.error", new Object[]{permission[i2].getPermissionType()}));
                }
                map2.put(permission[i2].getPermissionType(), permission[i2].isAllowed());
            }
        } else {
            for (int i3 = 0; i3 < permission.length; ++i3) {
                Boolean bl = map2.get(permission[i3].getPermissionType());
                if (bl == permission[i3].isAllowed()) continue;
                if (permission[i3].isAllowed() == null) {
                    map2.remove(permission[i3].getPermissionType());
                    continue;
                }
                if (Boolean.FALSE.equals(permission[i3].isAllowed())) {
                    throw new IllegalArgumentException(DrivePlugin.MSG_SERVER.getMsg("drive.permission.error", new Object[]{permission[i3].getPermissionType()}));
                }
                map2.put(permission[i3].getPermissionType(), permission[i3].isAllowed());
            }
            if (map2.isEmpty()) {
                map.remove(userOrGroupId);
            }
        }
        this.b(map, isGroup);
    }

    @Override
    public void removePermission(@Nonnull GUID userOrGroupId, boolean isGroup, String ... permission) {
        this.dV.aW();
        Map<GUID, Map<String, Boolean>> map = this.getPermissions(isGroup);
        Map<String, Boolean> map2 = map.get(userOrGroupId);
        if (map2 == null) {
            throw new IllegalArgumentException(DrivePlugin.MSG_SERVER.getMsg("drive.permission.error.idnotfound", new Object[]{userOrGroupId}));
        }
        for (int i2 = 0; i2 < permission.length; ++i2) {
            if (map2.get(permission[i2]) == null) continue;
            map2.remove(permission[i2]);
        }
        this.b(map, isGroup);
    }

    @Override
    public void setPermissions(boolean isGroup, @Nonnull Map<GUID, Map<String, Boolean>> permissions) {
        this.dV.aW();
        this.b(permissions, isGroup);
    }

    @Override
    public void clearPermission() {
        this.dV.aW();
        boolean bl = false;
        byte[] byArray = new Bon().toBinary(new HashMap());
        Map<GUID, Map<String, Boolean>> map = this.getPermissions(true);
        if (!map.isEmpty()) {
            e.a(this.fj, byArray);
            com.inet.drive.server.eventlog.a.bE.a(this.dV, new PermissionsChangeLog(map, new HashMap<GUID, Map<String, Boolean>>()));
            bl = true;
        }
        if (!(map = this.getPermissions(false)).isEmpty()) {
            e.a(this.fi, byArray);
            com.inet.drive.server.eventlog.a.bF.a(this.dV, new PermissionsChangeLog(map, new HashMap<GUID, Map<String, Boolean>>()));
            bl = true;
        }
        if (bl) {
            this.dV.C().notifyObservers(DriveObserver.EventType.PERMISSION, this.dV);
        }
    }

    @Override
    @Nonnull
    public List<String> getAvailablePermissions() {
        this.dV.aj();
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ServerPluginManager.getInstance().get(DrivePermissionType.class);
        for (DrivePermissionType drivePermissionType : list) {
            if (!"PERSISTENCE_PROVIDER".equals(drivePermissionType.getProvider())) continue;
            arrayList.add(drivePermissionType.getPermissionTypeName());
        }
        return arrayList;
    }

    private static class a
    extends HashMap<GUID, Map<String, Boolean>> {
        private a() {
        }
    }
}

