/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webapi.handler;

import com.inet.drive.api.DataEntry;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.webapi.data.DriveConflictResponseData;
import com.inet.drive.webgui.server.handler.h;
import com.inet.drive.webgui.server.model.fields.c;
import com.inet.drive.webgui.server.utils.e;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.remote.gui.angular.AngularContentService;
import com.inet.shared.servlet.ServletUtils;
import com.inet.usersandgroups.api.user.UserAccountScope;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Drive", description="Drive content operations")
public class a
extends RequestHandler.WithCurrentPathToken<Void, DriveConflictResponseData, String> {
    public a(String ... stringArray) {
        super(stringArray);
    }

    public a() {
        super(new String[]{"path"});
    }

    public String ap(String string) {
        return string;
    }

    public String getHelpPageKey() {
        return "webapi.drive.content.id";
    }

    @Operation(summary="Get or modify content of a drive entry", description="Retrieves or modifies the content of a drive entry specified by ID or path. Supports GET for download and PUT/POST for upload.", responses={@ApiResponse(responseCode="200", description="Content successfully retrieved or modified", content={@Content(mediaType="application/json", schema=@Schema(implementation=DriveConflictResponseData.class))}), @ApiResponse(responseCode="404", description="Drive entry not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=DriveConflictResponseData.class))}), @ApiResponse(responseCode="409", description="Operation failed due to conflict", content={@Content(mediaType="application/json", schema=@Schema(implementation=DriveConflictResponseData.class))}), @ApiResponse(responseCode="403", description="Access forbidden")})
    public DriveConflictResponseData b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Parameter(hidden=true) @Nullable Void void_, @Parameter(description="ID or path of the drive entry. For folders, ensure the path ends with a trailing slash.", required=true, schema=@Schema(type="string")) @Nullable String string, @Parameter(description="Additional path segments for nested operations", required=false, schema=@Schema(type="array")) List<String> list, @Parameter(hidden=true) boolean bl) throws IOException {
        String string2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl2;
        String string3;
        list = com.inet.drive.webapi.a.a(httpServletRequest, string, list);
        try {
            string3 = com.inet.drive.webapi.a.a(httpServletResponse, list);
        }
        catch (FileNotFoundException fileNotFoundException) {
            httpServletResponse.setStatus(404);
            return com.inet.drive.webapi.a.g(null, fileNotFoundException.getMessage());
        }
        DriveEntry driveEntry = com.inet.drive.webgui.server.a.du().resolve(string3);
        @Nullable String string4 = httpServletRequest.getMethod();
        if ("delete".equalsIgnoreCase(string4)) {
            if (driveEntry == null) {
                httpServletResponse.setStatus(404);
                return com.inet.drive.webapi.a.g(string3, string3);
            }
            try {
                if (bl) {
                    if (!com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission(driveEntry.getID(), false, "EDITOR")) {
                        httpServletResponse.setStatus(403);
                        return com.inet.drive.webapi.a.h(string3, string3);
                    }
                    return null;
                }
                driveEntry.delete(null);
            }
            catch (DriveOperationConflictException driveOperationConflictException) {
                return this.a(httpServletResponse, driveOperationConflictException, driveEntry.getPath());
            }
            return null;
        }
        if ("get".equalsIgnoreCase(string4)) {
            if (driveEntry == null) {
                httpServletResponse.setStatus(404);
                return com.inet.drive.webapi.a.g(string3, string3);
            }
            if (driveEntry.hasFeature(com.inet.drive.api.feature.Content.class)) {
                if (bl) {
                    return null;
                }
                @Nullable com.inet.drive.api.feature.Content content = driveEntry.getFeature(com.inet.drive.api.feature.Content.class);
                if (content == null) {
                    httpServletResponse.setStatus(404);
                    return com.inet.drive.webapi.a.g(string3, string3);
                }
                long l2 = driveEntry.getLastModified();
                String string5 = MimeTypes.getMimeType((String)driveEntry.getName());
                try (InputStream inputStream = content.getInputStream();){
                    if (inputStream != null) {
                        httpServletResponse.setContentLengthLong(content.getSize());
                        ServletUtils.setContentDisposition((HttpServletResponse)httpServletResponse, (String)driveEntry.getName(), (boolean)false);
                        AngularContentService.serveStaticContent((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (InputStream)inputStream, (long)l2, (String)string5, (boolean)false);
                    }
                }
                catch (DriveIOException | IOException exception) {
                    httpServletResponse.setStatus(404);
                    return com.inet.drive.webapi.a.g(string3, string3);
                }
                return null;
            }
            if (driveEntry.hasFeature(Folder.class)) {
                if (bl) {
                    return null;
                }
                h.a(httpServletResponse, Arrays.asList(driveEntry), new c().D(driveEntry) + ".zip");
                return null;
            }
            httpServletResponse.setStatus(404);
            return com.inet.drive.webapi.a.g(string3, string3);
        }
        boolean bl3 = bl2 = httpServletRequest.getContentType() != null && httpServletRequest.getContentType().contains("multipart");
        if ("put".equalsIgnoreCase(string4) && !bl2) {
            if (DriveIDUtils.isID(string3) && driveEntry == null) {
                httpServletResponse.setStatus(404);
                return com.inet.drive.webapi.a.g(string3, string3);
            }
            if (driveEntry == null && !DriveIDUtils.isID(string3) && httpServletRequest.getPathInfo().endsWith("/")) {
                try (Object object6 = httpServletRequest.getInputStream();){
                    if (((InputStream)object6).read() >= 0) {
                        httpServletResponse.setStatus(409);
                        DriveConflictResponseData driveConflictResponseData = com.inet.drive.webapi.a.a(string3, string3, DriveOperationConflictException.CONFLICT.invalidName, null);
                        return driveConflictResponseData;
                    }
                }
                if (bl) {
                    object6 = this.b(string3, driveEntry);
                    if (object6 != null) {
                        httpServletResponse.setStatus(this.a(((DriveConflictResponseData)object6).getConflicts().get(0).getConflict()));
                    }
                    return object6;
                }
                DriveUtils.getOrCreateFolder(com.inet.drive.webgui.server.a.du().resolve("/"), string3);
                return null;
            }
            if (driveEntry != null) {
                if (!driveEntry.hasFeature(com.inet.drive.api.feature.Content.class)) {
                    try (ServletInputStream servletInputStream = httpServletRequest.getInputStream();){
                        if (servletInputStream.read() < 0) {
                            DriveConflictResponseData driveConflictResponseData = null;
                            return driveConflictResponseData;
                        }
                    }
                    httpServletResponse.setStatus(409);
                    return com.inet.drive.webapi.a.i(string3, string3);
                }
                if (bl) {
                    boolean bl4 = com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission(driveEntry.getID(), false, "EDITOR");
                    if (!bl4) {
                        httpServletResponse.setStatus(403);
                        return com.inet.drive.webapi.a.h(string3, string3);
                    }
                    return null;
                }
                this.a(httpServletRequest, driveEntry);
            } else {
                object5 = com.inet.drive.webgui.server.a.du().resolve("Drive");
                if (object5 == null) {
                    httpServletResponse.setStatus(403);
                    return com.inet.drive.webapi.a.i(string3, string3);
                }
                object4 = new e((DriveEntry)object5, null, null);
                object3 = ((e)object4).aR(string3);
                if (object3 != null) {
                    return this.a(httpServletResponse, (DriveOperationConflictException)object3, string3);
                }
                if (bl) {
                    return null;
                }
                try {
                    int n2 = string3.lastIndexOf(47);
                    object2 = n2 >= 0 ? string3.substring(0, n2) : "";
                    object = n2 >= 0 ? string3.substring(n2 + 1) : string3;
                    string2 = httpServletRequest.getInputStream();
                    try {
                        DriveUtils.getOrCreateChild(com.inet.drive.webgui.server.a.du(), (String)object2, new DataEntry((String)object, (InputStream)((Object)string2)));
                    }
                    finally {
                        if (string2 != null) {
                            ((InputStream)((Object)string2)).close();
                        }
                    }
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    return this.a(httpServletResponse, driveOperationConflictException, string3);
                }
            }
        }
        if ("post".equalsIgnoreCase(string4) || "put".equalsIgnoreCase(string4) && bl2) {
            if (driveEntry != null && driveEntry.hasFeature(com.inet.drive.api.feature.Content.class)) {
                httpServletResponse.setStatus(409);
                return com.inet.drive.webapi.a.i(string3, string3);
            }
            if (driveEntry == null && DriveIDUtils.isID(string3)) {
                httpServletResponse.setStatus(404);
                return com.inet.drive.webapi.a.g(string3, string3);
            }
            if (driveEntry == null) {
                if (bl) {
                    object5 = this.b(string3, driveEntry);
                    if (object5 != null) {
                        httpServletResponse.setStatus(this.a(((DriveConflictResponseData)object5).getConflicts().get(0).getConflict()));
                        return object5;
                    }
                    return null;
                }
                try {
                    driveEntry = DriveUtils.getOrCreateFolder(com.inet.drive.webgui.server.a.du().resolve("/"), string3);
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    return this.a(httpServletResponse, driveOperationConflictException, string3);
                }
            }
            if ((object5 = driveEntry.getFeature(Folder.class)) == null) {
                httpServletResponse.setStatus(403);
                return com.inet.drive.webapi.a.h(string3, string3);
            }
            try {
                object4 = httpServletRequest.getParts();
            }
            catch (ServletException servletException) {
                throw new IOException(servletException);
            }
            object3 = new DriveConflictResponseData();
            String string6 = driveEntry.getPath();
            object2 = object4.iterator();
            while (object2.hasNext()) {
                Object object7;
                Object object8;
                Object object9;
                object = (Part)object2.next();
                try {
                    string2 = object.getSubmittedFileName();
                    if (StringFunctions.isEmpty((String)string2)) {
                        string2 = object.getName();
                    }
                    object9 = string6 + string2;
                    object8 = com.inet.drive.webgui.server.a.du().resolve((String)object9);
                    if (bl) {
                        if (object8 == null) {
                            object7 = UserAccountScope.createPrivileged();
                            try {
                                object8 = com.inet.drive.webgui.server.a.du().resolve((String)object9);
                                if (object8 != null) {
                                    throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(object8.getID(), DriveOperationConflictException.CONFLICT.alreadyExists));
                                }
                            }
                            finally {
                                if (object7 != null) {
                                    object7.close();
                                }
                            }
                            object7 = this.b(string3, driveEntry);
                            if (object7 == null) continue;
                            ((DriveConflictResponseData)object3).add((DriveConflictResponseData)object7);
                            continue;
                        }
                        if (!object8.hasFeature(Folder.class)) continue;
                        throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(object8.getID(), DriveOperationConflictException.CONFLICT.alreadyExistsFolder));
                    }
                    if (object8 != null && object8.hasFeature(Folder.class)) {
                        throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(object8.getID(), DriveOperationConflictException.CONFLICT.alreadyExistsFolder));
                    }
                    if (object8 == null) {
                        object7 = object.getInputStream();
                        try {
                            int n3 = ((String)object9).lastIndexOf(47);
                            String string7 = ((String)object9).substring(0, n3);
                            String string8 = ((String)object9).substring(n3 + 1);
                            if (object7 != null) {
                                DriveUtils.getOrCreateChild(com.inet.drive.webgui.server.a.du(), string7, new DataEntry(string8, (InputStream)object7));
                                continue;
                            }
                            DriveUtils.getOrCreateChild(com.inet.drive.webgui.server.a.du(), string7, new DataEntry(string8, new byte[0]));
                            continue;
                        }
                        finally {
                            if (object7 != null) {
                                ((InputStream)object7).close();
                            }
                            continue;
                        }
                    }
                    object8.runFeature(com.inet.drive.api.feature.Content.class, arg_0 -> a.a((Part)object, arg_0));
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    object9 = driveOperationConflictException.getConflicts();
                    object8 = object9.iterator();
                    while (object8.hasNext()) {
                        object7 = object8.next();
                        ((DriveConflictResponseData)object3).add((DriveOperationConflictException.SingleEntryConflict)object7, object9.size() <= 1 ? string3 : null);
                    }
                }
            }
            if (((DriveConflictResponseData)object3).hasData()) {
                httpServletResponse.setStatus(200);
                return object3;
            }
        }
        return null;
    }

    private DriveConflictResponseData b(@Nonnull String string, @Nullable DriveEntry driveEntry) {
        Drive drive = com.inet.drive.webgui.server.a.du();
        if (driveEntry != null) {
            if (!drive.getPermissionChecker().hasPermission(driveEntry.getID(), false, "EDITOR")) {
                return com.inet.drive.webapi.a.h(driveEntry.getID(), driveEntry.getPath());
            }
            return null;
        }
        String[] stringArray = DriveUtils.splitPath(string);
        StringBuilder stringBuilder = new StringBuilder("");
        String string2 = "Drive";
        for (String string3 : stringArray) {
            String string4 = stringBuilder.toString() + "/";
            stringBuilder.append('/').append(string3);
            driveEntry = drive.resolve(stringBuilder.toString());
            if (driveEntry == null) {
                if (!drive.getPermissionChecker().hasPermission(string2, false, "EDITOR")) {
                    return com.inet.drive.webapi.a.h(string2, string4);
                }
                try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                    driveEntry = drive.resolve(stringBuilder.toString());
                }
                if (driveEntry != null) {
                    return com.inet.drive.webapi.a.a(driveEntry.getID(), stringBuilder.toString(), DriveOperationConflictException.CONFLICT.protectedChild, null);
                }
                return null;
            }
            if (!driveEntry.hasFeature(Folder.class)) {
                return com.inet.drive.webapi.a.a(driveEntry.getID(), stringBuilder.toString(), DriveOperationConflictException.CONFLICT.format, null);
            }
            string2 = driveEntry.getID();
        }
        if (driveEntry == null) {
            return null;
        }
        if (!drive.getPermissionChecker().hasPermission(driveEntry.getID(), false, "EDITOR")) {
            return com.inet.drive.webapi.a.h(driveEntry.getID(), stringBuilder.toString());
        }
        return null;
    }

    private DriveConflictResponseData a(@Nonnull HttpServletResponse httpServletResponse, @Nonnull DriveOperationConflictException driveOperationConflictException, @Nullable String string) throws IOException {
        DriveConflictResponseData driveConflictResponseData = new DriveConflictResponseData();
        @Nonnull List<@Nonnull DriveOperationConflictException.SingleEntryConflict> list = driveOperationConflictException.getConflicts();
        if (list.size() == 1) {
            @Nonnull @Nonnull DriveOperationConflictException.SingleEntryConflict singleEntryConflict = list.get(0);
            driveConflictResponseData.add(singleEntryConflict, string);
            if (string != null) {
                httpServletResponse.setStatus(this.a(singleEntryConflict.getConflict()));
            }
        } else {
            for (DriveOperationConflictException.SingleEntryConflict singleEntryConflict : list) {
                driveConflictResponseData.add(singleEntryConflict, null);
            }
        }
        return driveConflictResponseData;
    }

    private int a(@Nonnull DriveOperationConflictException.CONFLICT cONFLICT) {
        switch (cONFLICT) {
            case writeProtected: 
            case writeProtectedFolder: {
                return 403;
            }
            case sourceNotFound: {
                return 404;
            }
        }
        return 409;
    }

    private void a(HttpServletRequest httpServletRequest, @Nonnull DriveEntry driveEntry) throws IOException, DriveOperationConflictException {
        driveEntry.runFeature(com.inet.drive.api.feature.Content.class, content -> {
            try (ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                 OutputStream outputStream = content.getOutputStream();){
                IOFunctions.copyData((InputStream)servletInputStream, (OutputStream)outputStream);
            }
        });
    }

    public boolean isMethodAllowedForData(HttpServletRequest request) {
        return "GET".equals(request.getMethod()) || "POST".equals(request.getMethod()) || "PUT".equals(request.getMethod()) || "DELETE".equals(request.getMethod());
    }

    @Operation(summary="Get or modify content of a drive entry", description="Retrieves or modifies the content of a drive entry specified by ID or path. Supports GET for download and PUT/POST for upload.", responses={@ApiResponse(responseCode="200", description="Content successfully retrieved or modified", content={@Content(mediaType="application/json", schema=@Schema(implementation=DriveConflictResponseData.class))}), @ApiResponse(responseCode="404", description="Drive entry not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=DriveConflictResponseData.class))}), @ApiResponse(responseCode="409", description="Operation failed due to conflict", content={@Content(mediaType="application/json", schema=@Schema(implementation=DriveConflictResponseData.class))}), @ApiResponse(responseCode="403", description="Access forbidden")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Parameter(hidden=true) @Nullable Object object, @Parameter(description="ID or path of the drive entry. For folders, ensure the path ends with a trailing slash.", required=true, schema=@Schema(type="string")) @Nullable Object object2, @Parameter(description="Additional path segments for nested operations", required=false, schema=@Schema(type="array")) List list, @Parameter(hidden=true) boolean bl) throws IOException {
        return this.b(httpServletRequest, httpServletResponse, (Void)object, (String)object2, list, bl);
    }

    public /* synthetic */ Object typeFor(String string) {
        return this.ap(string);
    }

    private static /* synthetic */ void a(Part part, com.inet.drive.api.feature.Content content) throws IOException {
        try (InputStream inputStream = part.getInputStream();
             OutputStream outputStream = content.getOutputStream();){
            IOFunctions.copyData((InputStream)inputStream, (OutputStream)outputStream);
        }
    }
}

