/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webapi;

import com.inet.authentication.base.LoginManager;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.webapi.data.DriveConflictResponseData;
import com.inet.drive.webgui.server.model.fields.c;
import com.inet.http.servlet.SessionStore;
import com.inet.plugin.webapi.api.PathTokenizer;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Drive", description="Drive root operations")
public class a
extends RequestHandler.WithCurrentPathToken<Void, Map<String, String>, String> {
    public a() {
        super(new String[]{"root"});
    }

    public String getHelpPageKey() {
        return "webapi.drive.id";
    }

    public String ap(String string) {
        return string;
    }

    @Operation(summary="List available drive roots", description="Lists all available root nodes in the drive and their display names", responses={@ApiResponse(responseCode="200", description="Successfully retrieved root nodes", content={@Content(mediaType="application/json", schema=@Schema(type="object", description="Map of root node IDs to their display names"))}), @ApiResponse(responseCode="403", description="Access forbidden")})
    public Map<String, String> a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Parameter(hidden=true) @Nullable Void void_, @Parameter(description="Root path element", required=false) @Nullable String string, @Parameter(description="Additional path segments", required=false) List<String> list, @Parameter(hidden=true) boolean bl) throws IOException {
        string = (list = a.a(httpServletRequest, string, list)).isEmpty() ? "Drive" : list.get(0);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        @Nonnull Map<Drive.ROOT_TYPES, List<DriveEntry>> map = com.inet.drive.webgui.server.a.du().getRoots();
        c c2 = new c();
        for (Drive.ROOT_TYPES rOOT_TYPES : Drive.ROOT_TYPES.values()) {
            @Nullable List<DriveEntry> list2 = map.get((Object)rOOT_TYPES);
            if (list2 == null) continue;
            for (DriveEntry driveEntry : list2) {
                linkedHashMap.put(driveEntry.getID(), c2.D(driveEntry));
            }
        }
        return linkedHashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static String a(@Nonnull HttpServletResponse httpServletResponse, @Nonnull List<String> list) throws FileNotFoundException {
        if (list.isEmpty()) {
            return "Drive";
        }
        Object object = "/";
        String string = list.get(0);
        boolean bl = a.aq(string);
        if (DriveIDUtils.isID(string) && !bl) {
            object = string;
            if (list.size() <= 1) return object;
            DriveEntry driveEntry = Drive.getInstance().resolve((String)object);
            if (driveEntry == null) {
                throw new FileNotFoundException((String)object);
            }
            list = list.subList(1, list.size());
            if (!driveEntry.hasFeature(Folder.class)) throw new FileNotFoundException((String)object);
            return driveEntry.getPath() + String.join((CharSequence)"/", list);
        }
        if (string.equals("Drive")) {
            list = list.subList(1, list.size());
        }
        if (bl && list.size() == 1) {
            return string;
        }
        if (DriveIDUtils.getMountRootID(string) == null) return "/" + String.join((CharSequence)"/", list);
        if (list.size() != 1) return "/" + String.join((CharSequence)"/", list);
        return string;
    }

    @Nonnull
    public static DriveConflictResponseData g(@Nullable String string, @Nullable String string2) {
        return a.a(string, string2, DriveOperationConflictException.CONFLICT.sourceNotFound, null);
    }

    @Nonnull
    public static DriveConflictResponseData h(@Nullable String string, @Nullable String string2) {
        return a.a(string, string2, DriveOperationConflictException.CONFLICT.writeProtected, null);
    }

    @Nonnull
    public static DriveConflictResponseData i(@Nullable String string, @Nullable String string2) {
        return a.a(string, string2, DriveOperationConflictException.CONFLICT.alreadyExistsFolder, null);
    }

    @Nonnull
    public static DriveConflictResponseData a(@Nullable String string, @Nullable String string2, @Nonnull DriveOperationConflictException.CONFLICT cONFLICT, @Nullable String string3) {
        if (!DriveIDUtils.isID(string)) {
            string = null;
        }
        if (DriveIDUtils.isID(string2)) {
            string2 = null;
        }
        DriveOperationConflictException.SingleEntryConflict singleEntryConflict = string3 == null ? new DriveOperationConflictException.SingleEntryConflict(string, cONFLICT) : new DriveOperationConflictException.SingleEntryConflict(string, null, cONFLICT, string3);
        return new DriveConflictResponseData().add(singleEntryConflict, string2);
    }

    public static boolean aq(@Nullable String string) {
        if (string == null) {
            return false;
        }
        @Nonnull Map<Drive.ROOT_TYPES, List<DriveEntry>> map = Drive.getInstance().getRoots();
        for (List<DriveEntry> list : map.values()) {
            for (DriveEntry driveEntry : list) {
                if (!string.equals(driveEntry.getID())) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static List<String> a(@Nonnull HttpServletRequest httpServletRequest, @Nullable String string, @Nullable List<String> list) {
        List list2 = PathTokenizer.convertPathToTokens((String)httpServletRequest.getPathInfo());
        int n2 = (string == null || string.isBlank() ? 0 : 1) + (list != null ? list.size() : 0);
        list = list2.subList(list2.size() - n2, list2.size());
        return list;
    }

    public boolean isAvailable() {
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        if (httpServletRequest != null) {
            return !LoginManager.isApplicationRequest((HttpServletRequest)httpServletRequest) || httpServletRequest.getParameter("method") == null;
        }
        return false;
    }

    @Operation(summary="List available drive roots", description="Lists all available root nodes in the drive and their display names", responses={@ApiResponse(responseCode="200", description="Successfully retrieved root nodes", content={@Content(mediaType="application/json", schema=@Schema(type="object", description="Map of root node IDs to their display names"))}), @ApiResponse(responseCode="403", description="Access forbidden")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Parameter(hidden=true) @Nullable Object object, @Parameter(description="Root path element", required=false) @Nullable Object object2, @Parameter(description="Additional path segments", required=false) List list, @Parameter(hidden=true) boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (Void)object, (String)object2, list, bl);
    }

    public /* synthetic */ Object typeFor(String string) {
        return this.ap(string);
    }
}

