/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.linked;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DataEntry;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountManager;
import com.inet.drive.server.linked.e;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class c
implements Folder {
    private final DriveEntry cz;
    private final MountDescription ax;
    private final DriveEntry al;
    private final String cH;

    protected abstract Folder G();

    public c(@Nonnull DriveEntry driveEntry, @Nonnull MountDescription mountDescription) {
        this(driveEntry, mountDescription, driveEntry, "/");
    }

    public c(@Nonnull DriveEntry driveEntry, @Nonnull MountDescription mountDescription, @Nonnull DriveEntry driveEntry2, String string) {
        this.cz = driveEntry;
        this.ax = mountDescription;
        this.al = driveEntry2;
        this.cH = string;
    }

    @Override
    @Nonnull
    public List<DriveEntry> getChildren() {
        e.f(this.al);
        ArrayList<DriveEntry> arrayList = new ArrayList<DriveEntry>();
        String string = null;
        Mount mount = this.al.getFeature(DriveEntry.MOUNT);
        if (mount != null) {
            string = mount.getLinkID();
        }
        try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)this.ax.getUserID());){
            Folder folder = this.G();
            if (folder != null) {
                for (DriveEntry driveEntry : folder.getChildren()) {
                    Mount mount2 = driveEntry.getFeature(DriveEntry.MOUNT);
                    if (mount2 != null && mount2.isLinkRoot() && string != null && string.equals(mount2.getLinkID())) {
                        arrayList.add(driveEntry);
                        continue;
                    }
                    arrayList.add(new com.inet.drive.server.linked.a(this.ax, this.cz.getID(), this.cz, this.al, driveEntry, com.inet.drive.webgui.server.a.du(), this.cH));
                }
            }
        }
        catch (Throwable throwable) {
            this.a(throwable);
        }
        return arrayList;
    }

    private void a(Throwable throwable) {
        String string = "";
        if (throwable instanceof DriveIOException) {
            string = ((DriveIOException)throwable).getServerDetails();
        }
        while (!(throwable instanceof ConnectException) && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        boolean bl = this.ax.getUserID().equals((Object)UserManager.getInstance().getCurrentUserAccountID());
        if (throwable instanceof ConnectException || throwable instanceof UnknownHostException) {
            if (bl) {
                throw new MountManager.d(string, throwable.getLocalizedMessage());
            }
            throw new MountManager.d(this.ax.getProvider());
        }
        if (throwable instanceof AccessDeniedException) {
            Object object = "ID " + String.valueOf(this.ax.getUserID());
            UserAccount userAccount = UserManager.getInstance().getUserAccount(this.ax.getUserID());
            if (userAccount != null) {
                object = userAccount.getDisplayName();
            }
            throwable = new AccessDeniedException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied.link", new Object[]{object, this.al.getPath()}));
        }
        ErrorCode.throwAny((Throwable)throwable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasChildren() {
        e.f(this.al);
        try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)this.ax.getUserID());){
            Folder folder = this.G();
            if (folder == null) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = folder.hasChildren();
            return bl;
        }
        catch (Throwable throwable3) {
            this.a(throwable3);
            return false;
        }
    }

    @Override
    public DriveEntry createChild(@Nonnull String name) throws DriveOperationConflictException {
        return this.a(() -> this.G().createChild(name));
    }

    @Override
    public DriveEntry createChild(@Nonnull DataEntry dataEntry) throws DriveOperationConflictException {
        return this.a(() -> this.G().createChild(dataEntry));
    }

    private DriveEntry a(a a2) throws DriveOperationConflictException {
        DriveEntry driveEntry;
        this.an();
        try {
            driveEntry = e.a(this.al.getID(), this.ax, () -> {
                DriveEntry driveEntry = a2.createChild();
                e.a(this.ax, DriveObserver.EventType.CREATED, e.a(this.ax, driveEntry));
                if (e.g(this.al)) {
                    com.inet.drive.server.eventlog.a.by.a(new com.inet.drive.server.linked.a(this.ax, this.cz.getID(), this.cz, this.al, driveEntry, com.inet.drive.webgui.server.a.du(), this.cH), new Object[0]);
                }
                return driveEntry;
            });
        }
        catch (DriveOperationConflictException driveOperationConflictException) {
            if (!"PERSISTENCE_PROVIDER".equals(this.ax.getProvider())) {
                for (DriveOperationConflictException.SingleEntryConflict singleEntryConflict : driveOperationConflictException.getConflicts()) {
                    if (singleEntryConflict.getExistingEntryID() == null) continue;
                    singleEntryConflict.setExistingEntryID(DriveIDUtils.getMountRootID(this.ax.getID(), singleEntryConflict.getExistingEntryID()));
                }
            }
            throw driveOperationConflictException;
        }
        return new com.inet.drive.server.linked.a(this.ax, this.cz.getID(), this.cz, this.al, driveEntry, com.inet.drive.webgui.server.a.du(), this.cH);
    }

    private void an() throws DriveOperationConflictException {
        if (!e.a(this.al, false)) {
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(this.al.getID(), DriveOperationConflictException.CONFLICT.writeProtected));
        }
        if (this.G() == null) {
            String string = "No login";
            UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
            if (userAccount != null) {
                string = userAccount.getDisplayName();
            }
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(this.cz.getID(), DriveOperationConflictException.CONFLICT.targetNotFound, "Pfad/ID = " + this.cH + "\tuser = " + string));
        }
    }

    private static interface a {
        public DriveEntry createChild() throws DriveOperationConflictException;
    }
}

