/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKeyParser;
import com.inet.config.ConfigurationManager;
import com.inet.config.LicenseInfo;
import com.inet.config.LicenseListener;
import com.inet.config.LicenseManager;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DataEntry;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.Lock;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.server.persistence.i;
import com.inet.drive.server.persistence.r;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.thread.ServerLock;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class DriveUtils {
    public static final I18nMessages MSG = DrivePlugin.MSG_SERVER;
    private static boolean M = true;
    public static final String ROOT_ID = "Drive";
    public static final String MOUNT_ROOT_ID = "MountID";
    public static final String SHARED_ROOT_ID = "SharedWithMe";
    public static final String DIR_NAME_HOME = "Home";
    public static final String DIR_NAME_HOME_PATH = "/Home/";
    public static final String SYSTEM_CREATOR = "System";
    private static final List<DriveFileTypeHandler> N = new ArrayList<DriveFileTypeHandler>();
    private static final ThreadLocal<a> O = new ThreadLocal();
    @Deprecated
    public static final UserField<String> USERFIELD_DRIVE_HOMEFOLDER = new UserField<String>("driveuserhome"){

        public boolean isValueChangeLoggable() {
            return false;
        }
    };

    public static void startOperation(@Nullable a operation) {
        if (operation == null) {
            O.remove();
        } else {
            if (O.get() != null) {
                DrivePlugin.LOGGER.debug((Object)("Thread contain already a drive operation " + String.valueOf((Object)O.get()) + " and cannot overwritten with " + String.valueOf((Object)operation)));
                return;
            }
            O.set(operation);
        }
    }

    public static void replaceOperation(@Nullable a operation) {
        if (operation == null) {
            O.remove();
        } else {
            O.set(operation);
        }
    }

    public static a getOperation() {
        return O.get();
    }

    public static void initDefaultHandler() {
        LicenseManager.getInstance().addLicenseListener(new LicenseListener(){

            public void licenseChanged(LicenseInfo info) {
                M = ConfigKeyParser.hasValidLicenseFor((String)"drive") || ConfigurationManager.isRecoveryMode();
            }
        });
        N.add(new com.inet.drive.server.handler.a());
    }

    public static boolean hasValidLicense() {
        return M || UserManager.getInstance().getCurrentUserAccountID() == UserManager.PRIVILEGED_ACCOUNT_ID;
    }

    public static List<DriveFileTypeHandler> getDriveTypeHandler() {
        ArrayList<DriveFileTypeHandler> arrayList = new ArrayList<DriveFileTypeHandler>();
        arrayList.addAll(N);
        arrayList.addAll(ServerPluginManager.getInstance().get(DriveFileTypeHandler.class));
        return arrayList;
    }

    @Nullable
    public static String getHomeFolderID(@Nullable UserAccount userAccount) {
        if (userAccount == null) {
            return null;
        }
        Object object = r.bH().get(userAccount.getID().toString());
        return object == null ? null : object.toString();
    }

    public static DriveEntry getOrCreateChild(@Nonnull Drive drive, @Nonnull String path) throws DriveOperationConflictException {
        DriveEntry driveEntry = drive.resolve(path);
        if (driveEntry != null) {
            return driveEntry;
        }
        return DriveUtils.getOrCreateFolder(null, path);
    }

    @Nonnull
    public static String[] splitPath(@Nonnull String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        while ((n3 = path.indexOf("/")) >= 0) {
            String string = path.substring(n2, n3);
            path = path.substring(n3 + 1);
            arrayList.add(string);
        }
        arrayList.add(path);
        return arrayList.toArray(new String[0]);
    }

    public static DriveEntry getOrCreateFolder(@Nullable DriveEntry startFolder, @Nonnull String path) throws DriveOperationConflictException {
        Object object;
        String[] stringArray = DriveUtils.splitPath(path);
        if (startFolder == null) {
            Drive drive = com.inet.drive.webgui.server.a.du();
            if (stringArray.length > 1 && (object = drive.resolve((path.startsWith("/") ? "/" : "") + stringArray[0])) != null) {
                startFolder = object;
                stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            }
            if (startFolder == null) {
                startFolder = drive.resolve("/");
            }
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            object = stringArray[i2];
            if (startFolder == null || !startFolder.hasFeature(Folder.class)) continue;
            Lock lock = startFolder.getFeature(Lock.class);
            if (lock == null) {
                startFolder = DriveUtils.a((DriveEntry)startFolder, (String)object);
                continue;
            }
            try (ServerLock serverLock = lock.tryLock(250L);){
                if (serverLock == null) {
                    throw DriveOperationConflictException.createSingleConflictException(startFolder.getID(), DriveOperationConflictException.CONFLICT.locked, null);
                }
                startFolder = DriveUtils.a((DriveEntry)startFolder, (String)object);
                continue;
            }
        }
        return startFolder;
    }

    private static DriveEntry a(@Nonnull DriveEntry driveEntry, String string) throws DriveOperationConflictException {
        boolean bl = false;
        com.inet.drive.server.a a2 = (com.inet.drive.server.a)com.inet.drive.webgui.server.a.du();
        DriveEntry driveEntry2 = a2.b(driveEntry, string);
        if (driveEntry2 != null) {
            return driveEntry2;
        }
        Folder folder = driveEntry.getFeature(Folder.class);
        if (folder == null) {
            throw DriveOperationConflictException.createSingleConflictException(driveEntry.getID(), DriveOperationConflictException.CONFLICT.exception, "The create folder didn't exist anymore.");
        }
        List<DriveEntry> list = folder.getChildren();
        for (DriveEntry driveEntry3 : list) {
            if (!driveEntry3.getName().equals(string) || !driveEntry3.hasFeature(Folder.class)) continue;
            driveEntry = driveEntry3;
            bl = true;
            break;
        }
        if (!bl) {
            driveEntry = folder.createChild(string);
        }
        return driveEntry;
    }

    public static DriveEntry getOrCreateChild(@Nonnull Drive drive, @Nonnull String path, @Nonnull DataEntry entry) throws DriveOperationConflictException {
        DriveEntry driveEntry = DriveUtils.getOrCreateChild(drive, path);
        if (driveEntry == null) {
            throw DriveOperationConflictException.createSingleConflictException(ROOT_ID, DriveOperationConflictException.CONFLICT.exception, "The parent could be created");
        }
        Folder folder = driveEntry.getFeature(DriveEntry.FOLDER);
        if (folder == null) {
            throw DriveOperationConflictException.createSingleConflictException(driveEntry.getID(), DriveOperationConflictException.CONFLICT.exception, "The create folder didn't exist anymore.");
        }
        return folder.createChild(entry);
    }

    public static List<String> getMountsForUser(Drive drive, String userID) {
        SearchCondition searchCondition = new SearchCondition(MetaData.CREATOR_ID.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)userID);
        SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{searchCondition});
        SearchResult<String> searchResult = drive.search(searchCommand);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SearchResultEntry searchResultEntry : searchResult.getEntries()) {
            if (!DriveIDUtils.isMountID((String)searchResultEntry.getId())) continue;
            arrayList.add((String)searchResultEntry.getId());
        }
        return arrayList;
    }

    @Nonnull
    public static b getAllSubelements(@Nonnull DriveEntry entry, Drive drive) {
        Mount mount = entry.getFeature(Mount.class);
        if (mount == null) {
            return new b(((com.inet.drive.server.a)drive).J(), entry.getID(), entry.getPath());
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        boolean bl = entry instanceof i;
        if (bl) {
            hashSet3.add(entry.getID());
        }
        DriveUtils.getChildrenIDs(entry, hashSet2, hashSet3, hashSet, bl);
        return new b(entry.getID(), entry.getPath(), hashSet, hashSet2, hashSet3);
    }

    public static void getChildrenIDs(@Nonnull DriveEntry entry, HashSet<String> files, HashSet<String> folders, HashSet<String> links, boolean isInLink) {
        if (files.contains(entry.getID()) || folders.contains(entry.getID()) || links.contains(entry.getID())) {
            return;
        }
        Mount mount = entry.getFeature(DriveEntry.MOUNT);
        if (mount != null && mount.isLinkRoot() && isInLink) {
            return;
        }
        isInLink = mount != null && mount.isLinkRoot();
        Folder folder = entry.getFeature(DriveEntry.FOLDER);
        if (folder != null) {
            if (isInLink) {
                links.add(entry.getID());
            } else {
                folders.add(entry.getID());
            }
            for (DriveEntry driveEntry : folder.getChildren()) {
                DriveUtils.getChildrenIDs(driveEntry, files, folders, links, isInLink);
            }
        } else {
            files.add(entry.getID());
        }
    }

    public static String getMessage(b subelements) {
        return DriveUtils.getMessage(subelements.t().size(), subelements.p().size(), subelements.q().size(), subelements.r().size());
    }

    public static String getMessage(int entryCount, int fileCount, int folderCount, int mountCount) {
        return DrivePlugin.MSG_SERVER.getMsg("counter.entries", new Object[]{entryCount, DrivePlugin.MSG_SERVER.getMsg("counter.files", new Object[]{fileCount}), DrivePlugin.MSG_SERVER.getMsg("counter.folders", new Object[]{folderCount}), DrivePlugin.MSG_SERVER.getMsg("counter.mounts", new Object[]{mountCount})});
    }

    public static String getCacheEntry(DriveEntry entry, String metaKey) {
        return DriveUtils.getCacheEntry(entry.getID(), metaKey);
    }

    public static String getCacheEntry(String entryID, String metaKey) {
        return entryID + "_" + metaKey;
    }

    public static SearchCommand getSearchCommand(@Nonnull String path) {
        AndSearchExpression andSearchExpression = new AndSearchExpression();
        SearchCondition.SearchTermOperator searchTermOperator = SearchCondition.SearchTermOperator.Equals;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        andSearchExpression.add((SearchExpression)new SearchCondition(MetaData.PATH.getKey(), searchTermOperator, (Object)path, true));
        return new SearchCommand(new SearchExpression[]{andSearchExpression});
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a P = new a();
        public static final /* enum */ a Q = new a();
        public static final /* enum */ a R = new a();
        public static final /* enum */ a S = new a();
        private static final /* synthetic */ a[] T;

        public static a[] values() {
            return (a[])T.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] o() {
            return new a[]{P, Q, R, S};
        }

        static {
            T = a.o();
        }
    }

    public static class b {
        private final com.inet.drive.server.search.a U;
        private final String entryID;
        private final String path;
        private HashSet<String> V;
        private HashSet<String> W;
        private HashSet<String> X;
        private boolean Y;
        private HashSet<String> Z;

        private b(String string, String string2, HashSet<String> hashSet, HashSet<String> hashSet2, HashSet<String> hashSet3) {
            this.U = null;
            this.Y = true;
            this.entryID = string;
            this.path = string2;
            this.V = hashSet;
            this.W = hashSet2;
            this.X = hashSet3;
            this.Z = new HashSet();
            this.Z.addAll(hashSet);
            this.Z.addAll(this.W);
            this.Z.addAll(this.X);
        }

        private b(com.inet.drive.server.search.a a2, String string, String string2) {
            this.U = a2;
            this.entryID = string;
            this.path = string2;
        }

        public HashSet<String> p() {
            if (this.s()) {
                return this.V;
            }
            AndSearchExpression andSearchExpression = this.u();
            andSearchExpression.add((SearchExpression)new SearchCondition(MetaData.FILETYPE.getKey(), SearchCondition.SearchTermOperator.Unequals, null));
            SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{andSearchExpression});
            Set set = this.U.bM().simpleSearch(searchCommand);
            return new HashSet<String>(set);
        }

        public HashSet<String> q() {
            if (this.s()) {
                return this.W;
            }
            AndSearchExpression andSearchExpression = this.u();
            andSearchExpression.add((SearchExpression)new SearchCondition(MetaData.FILETYPE.getKey(), SearchCondition.SearchTermOperator.Equals, null));
            SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{andSearchExpression});
            Set set = this.U.bM().simpleSearch(searchCommand);
            return new HashSet<String>(set);
        }

        public HashSet<String> r() {
            if (this.s()) {
                return this.X;
            }
            this.X = new HashSet();
            for (String string : this.q()) {
                if (!DriveIDUtils.isMountID(string)) continue;
                this.X.add(string);
            }
            return this.X;
        }

        public boolean s() {
            return this.Y;
        }

        public HashSet<String> t() {
            if (this.s()) {
                return this.Z;
            }
            SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{this.u()});
            Set set = this.U.bM().simpleSearch(searchCommand);
            return new HashSet<String>(set);
        }

        private AndSearchExpression u() {
            AndSearchExpression andSearchExpression = new AndSearchExpression();
            andSearchExpression.add((SearchExpression)new SearchCondition(MetaData.PATH.getKey(), SearchCondition.SearchTermOperator.StartsWith, (Object)(this.path.indexOf(47) == 0 ? this.path.substring(1) : this.path), true));
            return andSearchExpression;
        }
    }
}

