/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.persistence;

import com.inet.cache.MemoryStoreMap;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.LockException;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.server.eventlog.a;
import com.inet.drive.server.persistence.c;
import com.inet.drive.server.persistence.e;
import com.inet.drive.server.persistence.f;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.thread.ServerLock;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class k
implements MetaData {
    private c dV;
    private PersistenceEntry eP;
    private ConcurrentHashMap<String, Object> eQ;
    private static final List<MetaKey> eR = new ArrayList<MetaKey>();

    static k c(c c2) {
        String string = "Drive";
        if (Persistence.getRecoveryEnabledInstance().resolve(c2.u(string) + ".metadata").exists()) {
            return new k(string, c2);
        }
        return new k(c2);
    }

    private k(c c2) {
        String string = "Drive";
        this.dV = c2;
        this.eP = Persistence.getRecoveryEnabledInstance().resolve(c2.u(string) + ".metadata");
        this.eQ = new ConcurrentHashMap();
        this.eQ.put(ID.getKey(), string);
        this.eQ.put(CREATE.getKey(), System.currentTimeMillis());
        this.eQ.put(CREATOR.getKey(), "System");
        this.eQ.put(NAME.getKey(), "");
        this.eQ.put(PATH.getKey(), "/");
        try {
            this.bm();
        }
        catch (DriveOperationConflictException driveOperationConflictException) {
            // empty catch block
        }
    }

    public k(String string, c c2) {
        this.dV = c2;
        this.eP = Persistence.getRecoveryEnabledInstance().resolve(c2.u(string) + ".metadata");
        if (this.eP.exists()) {
            this.eQ = this.bo();
        } else {
            this.eQ = new ConcurrentHashMap();
            this.eQ.put(ID.getKey(), string);
            this.eQ.put(CREATE.getKey(), System.currentTimeMillis());
            UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
            if (userAccount == null) {
                throw new AccessDeniedException("No user is login");
            }
            this.eQ.put(CREATOR_ID.getKey(), userAccount.getID());
            this.eQ.put(CREATOR.getKey(), userAccount.getDisplayName());
            try {
                this.bm();
            }
            catch (DriveOperationConflictException driveOperationConflictException) {
                // empty catch block
            }
        }
    }

    private void bm() throws DriveOperationConflictException {
        try (ServerLock serverLock = e.f(this.eP);){
            this.bn();
        }
        catch (TimeoutException timeoutException) {
            DrivePlugin.LOGGER.debug(timeoutException.getMessage(), (Object)timeoutException);
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(this.dV.getID(), DriveOperationConflictException.CONFLICT.locked));
        }
    }

    private void bn() {
        for (String string : this.eQ.keySet()) {
            if (MetaData.ID.getKey().equals(string)) continue;
            Object object = this.eQ.get(string);
            this.dV.C().I().put((Object)DriveUtils.getCacheEntry(this.dV, string), object);
        }
        e.a(this.eP, this.eQ);
    }

    private ConcurrentHashMap<String, Object> bo() {
        if (this.eQ == null) {
            try (ServerLock serverLock = e.g(this.eP);){
                this.bp();
                MemoryStoreMap<String, Object> memoryStoreMap = this.dV.C().I();
                for (MetaKey<?> metaKey : com.inet.drive.server.search.c.bR()) {
                    Object object = this.eQ.get(metaKey.getKey());
                    if (object == null) {
                        memoryStoreMap.remove((Object)DriveUtils.getCacheEntry(this.dV, metaKey.getKey()));
                        continue;
                    }
                    memoryStoreMap.put((Object)DriveUtils.getCacheEntry(this.dV, metaKey.getKey()), object);
                }
            }
            catch (TimeoutException timeoutException) {
                DrivePlugin.LOGGER.debug(timeoutException.getMessage(), (Object)timeoutException);
                throw new LockException("Cannot acces entry " + this.dV.getID() + " because it is locked");
            }
        }
        return this.eQ;
    }

    private void bp() {
        if (this.eQ == null) {
            this.eQ = e.d(this.eP);
        }
    }

    @Override
    public <T> void setMetaData(@Nonnull MetaKey<T> key, @Nullable T value) throws DriveEntry.UnmodifiableEntryException, DriveOperationConflictException {
        if (!this.dV.b(false)) {
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(this.dV.getID(), DriveOperationConflictException.CONFLICT.writeProtected));
        }
        this.a(key, value, true);
    }

    <T> void c(@Nonnull MetaKey<T> metaKey, @Nullable T t2) throws DriveEntry.UnmodifiableEntryException, DriveOperationConflictException {
        this.a(metaKey, t2, false);
    }

    void a(@Nonnull @Nonnull Map<@Nonnull MetaKey<?>, Object> map, boolean bl) throws DriveOperationConflictException {
        HashMap<@Nonnull MetaKey<?>, Object> hashMap = new HashMap();
        for (MetaKey<?> metaKey : map.keySet()) {
            if (bl) {
                hashMap.put(metaKey, this.eQ.get(metaKey));
            }
            this.eQ.put(metaKey.getKey(), map.get(metaKey));
        }
        this.bm();
        if (bl) {
            for (MetaKey<?> metaKey : map.keySet()) {
                this.dV.C().notifyObservers(DriveObserver.EventType.MODIFIED, new DriveObserver.EventType.MetaDataChange(this.dV.getID(), metaKey, hashMap.get(metaKey), this.eQ.get(metaKey.getKey())));
            }
        }
    }

    private <T> void a(@Nonnull MetaKey<T> metaKey, @Nullable T t2, boolean bl) throws DriveEntry.UnmodifiableEntryException, DriveOperationConflictException {
        Object object;
        if (ID.getKey().equals(metaKey.getKey())) {
            throw new IllegalArgumentException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.cannotchangeid", new Object[]{this.getMetaData(ID), t2}));
        }
        Object object2 = this.eQ.get(metaKey.getKey());
        if (Objects.equals(object2, t2) && !SIZE.getKey().equals(metaKey.getKey())) {
            return;
        }
        if (eR.contains(metaKey)) {
            this.eQ.put(MetaData.MODIFIED.getKey(), System.currentTimeMillis());
            object = UserManager.getInstance().getCurrentUserAccountID();
            if (object != null) {
                this.eQ.put(MetaData.MODIFIEDBY.getKey(), object);
            } else {
                DrivePlugin.LOGGER.warn((Object)("No login User change meta data for key " + metaKey.getKey() + " for entry " + String.valueOf(this.eQ.get("PATH"))));
                this.eQ.remove(MetaData.MODIFIEDBY.getKey());
            }
        }
        object = null;
        Object object3 = null;
        if (NAME.getKey().equals(metaKey.getKey())) {
            String string;
            if (t2 == null || t2.toString().isBlank()) {
                DriveOperationConflictException.SingleEntryConflict singleEntryConflict = new DriveOperationConflictException.SingleEntryConflict(null, this.dV.getID(), DriveOperationConflictException.CONFLICT.invalidName, DrivePlugin.MSG_SERVER.getMsg("drive.entry.cannotchangename", new Object[]{object2, t2}));
                throw DriveOperationConflictException.createSingleConflictException(false, singleEntryConflict);
            }
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                String string2 = (String)this.eQ.get(MetaData.PARENT_ID.getKey());
                if (string2 == null) {
                    throw new IllegalArgumentException(DrivePlugin.MSG.getMsg("drive.entry.invalidparent", new Object[0]));
                }
                DriveEntry driveEntry = this.dV.C().d(string2);
                if (driveEntry == null) {
                    throw new IllegalArgumentException(DrivePlugin.MSG.getMsg("drive.entry.invalidparent", new Object[0]));
                }
                string = driveEntry.getPath() + String.valueOf(t2);
                f f2 = (f)driveEntry.getFeature(DriveEntry.FOLDER);
                if (f2 != null) {
                    f2.a(t2.toString(), this.dV.hasFeature(DriveEntry.FOLDER), this.dV.getID());
                }
            }
            object = PATH;
            object3 = this.eQ.get(((MetaKey)object).getKey());
            if (this.eQ.get(((MetaKey)object).getKey()) == null) {
                throw new IllegalArgumentException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.invalidmetadata", new Object[]{PATH.getKey()}));
            }
            if (this.dV.hasFeature(DriveEntry.FOLDER)) {
                string = string + "/";
            }
            this.eQ.put(((MetaKey)object).getKey(), string);
            e.a(this.dV, string, null, null, null);
        } else if (PATH.getKey().equals(metaKey.getKey())) {
            f f3;
            if (t2 == null) {
                throw new IllegalArgumentException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.cannotchangepath", new Object[]{object2, t2}));
            }
            object = NAME;
            object3 = this.eQ.get(((MetaKey)object).getKey());
            String[] stringArray = DriveUtils.splitPath(t2.toString());
            String string = stringArray[stringArray.length - 1];
            if (string.isBlank()) {
                throw new IllegalArgumentException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.cannotchangepath", new Object[]{object2, t2}));
            }
            DriveEntry driveEntry = this.dV.getParent();
            if (driveEntry != null && (f3 = (f)driveEntry.getFeature(DriveEntry.FOLDER)) != null) {
                f3.a(string, this.dV.hasFeature(DriveEntry.FOLDER), this.dV.getID());
            }
            if (string.equals(object3)) {
                object = null;
            } else {
                this.eQ.put(((MetaKey)object).getKey(), string);
            }
            e.a(this.dV, t2.toString(), null, null, null);
        }
        if (t2 == null) {
            this.eQ.remove(metaKey.getKey());
            this.dV.C().I().remove((Object)DriveUtils.getCacheEntry(this.dV, metaKey.getKey()));
        } else {
            this.eQ.put(metaKey.getKey(), t2);
        }
        this.bm();
        if (bl) {
            this.dV.C().notifyObservers(DriveObserver.EventType.MODIFIED, new DriveObserver.EventType.MetaDataChange(this.dV.getID(), metaKey, object2, this.eQ.get(metaKey.getKey())));
            if (object != null) {
                this.dV.C().notifyObservers(DriveObserver.EventType.MODIFIED, new DriveObserver.EventType.MetaDataChange(this.dV.getID(), (MetaKey<?>)object, object3, this.eQ.get(((MetaKey)object).getKey())));
            }
            if (DriveUtils.getOperation() == null) {
                if (metaKey == NAME) {
                    a.bA.a(this.dV, object2);
                } else if (object == NAME) {
                    a.bA.a(this.dV, object3);
                }
            }
        }
    }

    @Override
    @Nullable
    public <T> T getMetaData(@Nonnull MetaKey<T> key) {
        Object object;
        if (key != MetaData.ID && key != MetaData.NAME && key != MetaData.CREATOR_ID && key != MetaData.PARENT_ID && key != MetaData.HOMEFOLDER) {
            this.dV.aj();
        }
        if (!((object = this.dV.C().I().get((Object)DriveUtils.getCacheEntry(this.dV, key.getKey()))) != null || key == MetaData.PARENT_ID && this.dV.getID().equals("Drive"))) {
            object = this.bo().get(key.getKey());
        }
        if (object != null && (key == MetaData.CREATOR_ID || key == MetaData.HOMEFOLDER || key == MetaData.MODIFIEDBY)) {
            return (T)GUID.valueOf((String)object.toString());
        }
        return (T)object;
    }

    static {
        eR.add(MetaData.PATH);
        eR.add(MetaData.NAME);
        eR.add(MetaData.SIZE);
        eR.add(MetaData.CREATOR_ID);
    }
}

