/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Predicate;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public class ZlibDecompressor {
    private static final int ZLIB_SUFFIX = 65535;
    private static final Predicate<ByteBuf> windowPredicate = payload -> payload.readableBytes() >= 4 && payload.getInt(payload.readableBytes() - 4) == 65535;
    private final ByteBufAllocator allocator;
    private final Inflater context = new Inflater();
    private final boolean unpooled;

    public ZlibDecompressor(ByteBufAllocator allocator) {
        this(allocator, false);
    }

    public ZlibDecompressor(ByteBufAllocator allocator, boolean unpooled) {
        this.allocator = allocator;
        this.unpooled = unpooled;
    }

    public Flux<ByteBuf> completeMessages(Flux<ByteBuf> payloads) {
        return payloads.windowUntil(windowPredicate).flatMap(Flux::collectList).map(list -> {
            ByteBuf byteBuf;
            ByteBuf buf;
            if (list.size() == 1) {
                buf = (ByteBuf)list.get(0);
            } else {
                CompositeByteBuf composite = this.allocator.compositeBuffer(list.size());
                for (ByteBuf component : list) {
                    composite.addComponent(true, component);
                }
                buf = composite;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InflaterOutputStream inflater = new InflaterOutputStream(out, this.context);
            try {
                inflater.write(ByteBufUtil.getBytes((ByteBuf)buf, (int)buf.readerIndex(), (int)buf.readableBytes(), (boolean)false));
                ByteBuf outBuffer = this.unpooled ? Unpooled.buffer() : this.allocator.buffer();
                byteBuf = outBuffer.writeBytes(out.toByteArray()).asReadOnly();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inflater.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            inflater.close();
            return byteBuf;
        });
    }
}

