/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.RecurrenceRuleNWeekdaySpecGenerator;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class RecurrenceRuleNWeekdaySpec
implements RecurrenceRuleNWeekdaySpecGenerator {
    private final int n;
    private final DayOfWeek day;

    private RecurrenceRuleNWeekdaySpec(int n, DayOfWeek day) {
        this.n = n;
        this.day = Objects.requireNonNull(day, "day");
    }

    private RecurrenceRuleNWeekdaySpec(RecurrenceRuleNWeekdaySpec original, int n, DayOfWeek day) {
        this.n = n;
        this.day = day;
    }

    @Override
    public int n() {
        return this.n;
    }

    @Override
    public DayOfWeek day() {
        return this.day;
    }

    public final RecurrenceRuleNWeekdaySpec withN(int value) {
        if (this.n == value) {
            return this;
        }
        return new RecurrenceRuleNWeekdaySpec(this, value, this.day);
    }

    public final RecurrenceRuleNWeekdaySpec withDay(DayOfWeek value) {
        DayOfWeek newValue = Objects.requireNonNull(value, "day");
        if (this.day == newValue) {
            return this;
        }
        return new RecurrenceRuleNWeekdaySpec(this, this.n, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RecurrenceRuleNWeekdaySpec && this.equalTo(0, (RecurrenceRuleNWeekdaySpec)another);
    }

    private boolean equalTo(int synthetic, RecurrenceRuleNWeekdaySpec another) {
        return this.n == another.n && this.day.equals(another.day);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.n;
        h += (h << 5) + this.day.hashCode();
        return h;
    }

    public String toString() {
        return "RecurrenceRuleNWeekdaySpec{n=" + this.n + ", day=" + this.day + "}";
    }

    public static RecurrenceRuleNWeekdaySpec of(int n, DayOfWeek day) {
        return new RecurrenceRuleNWeekdaySpec(n, day);
    }

    public static RecurrenceRuleNWeekdaySpec copyOf(RecurrenceRuleNWeekdaySpecGenerator instance) {
        if (instance instanceof RecurrenceRuleNWeekdaySpec) {
            return (RecurrenceRuleNWeekdaySpec)instance;
        }
        return RecurrenceRuleNWeekdaySpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_N = 1L;
        private static final long INIT_BIT_DAY = 2L;
        private long initBits = 3L;
        private int n;
        @Nullable
        private DayOfWeek day;

        private Builder() {
        }

        public final Builder from(RecurrenceRuleNWeekdaySpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.n(instance.n());
            this.day(instance.day());
            return this;
        }

        public final Builder n(int n) {
            this.n = n;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder day(DayOfWeek day) {
            this.day = Objects.requireNonNull(day, "day");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public RecurrenceRuleNWeekdaySpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RecurrenceRuleNWeekdaySpec(null, this.n, this.day);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("n");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("day");
            }
            return "Cannot build RecurrenceRuleNWeekdaySpec, some of required attributes are not set " + attributes;
        }
    }
}

