/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.spec.GuildPruneSpecGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class GuildPruneSpec
implements GuildPruneSpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final Integer days;
    @reactor.util.annotation.Nullable
    private final Set<Snowflake> roles;
    @reactor.util.annotation.Nullable
    private final Boolean computePruneCount;

    private GuildPruneSpec(Integer days) {
        this.days = Objects.requireNonNull(days, "days");
        this.reason = null;
        this.roles = null;
        this.computePruneCount = null;
    }

    private GuildPruneSpec(@reactor.util.annotation.Nullable String reason, Integer days, @reactor.util.annotation.Nullable Set<Snowflake> roles, @reactor.util.annotation.Nullable Boolean computePruneCount) {
        this.reason = reason;
        this.days = days;
        this.roles = roles;
        this.computePruneCount = computePruneCount;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Integer days() {
        return this.days;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Set<Snowflake> roles() {
        return this.roles;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Boolean computePruneCount() {
        return this.computePruneCount;
    }

    public final GuildPruneSpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new GuildPruneSpec(value, this.days, this.roles, this.computePruneCount);
    }

    public final GuildPruneSpec withDays(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "days");
        if (this.days.equals(newValue)) {
            return this;
        }
        return new GuildPruneSpec(this.reason, newValue, this.roles, this.computePruneCount);
    }

    public final GuildPruneSpec withRoles(Snowflake ... elements) {
        if (elements == null) {
            return new GuildPruneSpec(this.reason, this.days, null, this.computePruneCount);
        }
        Set<Snowflake> newValue = Arrays.asList(elements) == null ? null : GuildPruneSpec.createUnmodifiableSet(GuildPruneSpec.createSafeList(Arrays.asList(elements), true, false));
        return new GuildPruneSpec(this.reason, this.days, newValue, this.computePruneCount);
    }

    public final GuildPruneSpec withRoles(@reactor.util.annotation.Nullable Iterable<? extends Snowflake> elements) {
        if (this.roles == elements) {
            return this;
        }
        Set<Snowflake> newValue = elements == null ? null : GuildPruneSpec.createUnmodifiableSet(GuildPruneSpec.createSafeList(elements, true, false));
        return new GuildPruneSpec(this.reason, this.days, newValue, this.computePruneCount);
    }

    public final GuildPruneSpec withComputePruneCount(@reactor.util.annotation.Nullable Boolean value) {
        if (Objects.equals(this.computePruneCount, value)) {
            return this;
        }
        return new GuildPruneSpec(this.reason, this.days, this.roles, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildPruneSpec && this.equalTo(0, (GuildPruneSpec)another);
    }

    private boolean equalTo(int synthetic, GuildPruneSpec another) {
        return Objects.equals(this.reason, another.reason) && this.days.equals(another.days) && Objects.equals(this.roles, another.roles) && Objects.equals(this.computePruneCount, another.computePruneCount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.days.hashCode();
        h += (h << 5) + Objects.hashCode(this.roles);
        h += (h << 5) + Objects.hashCode(this.computePruneCount);
        return h;
    }

    public String toString() {
        return "GuildPruneSpec{reason=" + this.reason + ", days=" + this.days + ", roles=" + this.roles + ", computePruneCount=" + this.computePruneCount + "}";
    }

    public static GuildPruneSpec of(Integer days) {
        return new GuildPruneSpec(days);
    }

    static GuildPruneSpec copyOf(GuildPruneSpecGenerator instance) {
        if (instance instanceof GuildPruneSpec) {
            return (GuildPruneSpec)instance;
        }
        return GuildPruneSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    public static final class Builder {
        private static final long INIT_BIT_DAYS = 1L;
        private long initBits = 1L;
        @Nullable
        private String reason;
        @Nullable
        private Integer days;
        private List<Snowflake> roles = null;
        @Nullable
        private Boolean computePruneCount;

        private Builder() {
        }

        public final Builder from(GuildPruneSpec instance) {
            return this.from((GuildPruneSpecGenerator)instance);
        }

        final Builder from(GuildPruneSpecGenerator instance) {
            Boolean computePruneCountValue;
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.days(instance.days());
            Set<Snowflake> rolesValue = instance.roles();
            if (rolesValue != null) {
                this.addAllRoles(rolesValue);
            }
            if ((computePruneCountValue = instance.computePruneCount()) != null) {
                this.computePruneCount(computePruneCountValue);
            }
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public final Builder days(Integer days) {
            this.days = Objects.requireNonNull(days, "days");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addRole(Snowflake element) {
            if (this.roles == null) {
                this.roles = new ArrayList<Snowflake>();
            }
            this.roles.add(Objects.requireNonNull(element, "roles element"));
            return this;
        }

        public final Builder addRoles(Snowflake ... elements) {
            if (this.roles == null) {
                this.roles = new ArrayList<Snowflake>();
            }
            for (Snowflake element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        public final Builder roles(@reactor.util.annotation.Nullable Iterable<? extends Snowflake> elements) {
            if (elements == null) {
                this.roles = null;
                return this;
            }
            this.roles = new ArrayList<Snowflake>();
            return this.addAllRoles(elements);
        }

        public final Builder addAllRoles(Iterable<? extends Snowflake> elements) {
            Objects.requireNonNull(elements, "roles element");
            if (this.roles == null) {
                this.roles = new ArrayList<Snowflake>();
            }
            for (Snowflake snowflake : elements) {
                this.roles.add(Objects.requireNonNull(snowflake, "roles element"));
            }
            return this;
        }

        public final Builder computePruneCount(@reactor.util.annotation.Nullable Boolean computePruneCount) {
            this.computePruneCount = computePruneCount;
            return this;
        }

        public GuildPruneSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GuildPruneSpec(this.reason, this.days, this.roles == null ? null : GuildPruneSpec.createUnmodifiableSet(this.roles), this.computePruneCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("days");
            }
            return "Cannot build GuildPruneSpec, some of required attributes are not set " + attributes;
        }
    }
}

