/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.entity.ApplicationInfo;
import discord4j.core.spec.ApplicationEmojiCreateMonoGenerator;
import discord4j.rest.util.Image;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ApplicationEmojiCreateMono
extends ApplicationEmojiCreateMonoGenerator {
    private final String name;
    private final Image image;
    private final ApplicationInfo applicationInfo;

    private ApplicationEmojiCreateMono(String name, Image image, ApplicationInfo applicationInfo) {
        this.name = Objects.requireNonNull(name, "name");
        this.image = Objects.requireNonNull(image, "image");
        this.applicationInfo = Objects.requireNonNull(applicationInfo, "applicationInfo");
    }

    private ApplicationEmojiCreateMono(ApplicationEmojiCreateMono original, String name, Image image, ApplicationInfo applicationInfo) {
        this.name = name;
        this.image = image;
        this.applicationInfo = applicationInfo;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Image image() {
        return this.image;
    }

    @Override
    public ApplicationInfo applicationInfo() {
        return this.applicationInfo;
    }

    public final ApplicationEmojiCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ApplicationEmojiCreateMono(this, newValue, this.image, this.applicationInfo);
    }

    public final ApplicationEmojiCreateMono withImage(Image value) {
        if (this.image == value) {
            return this;
        }
        Image newValue = Objects.requireNonNull(value, "image");
        return new ApplicationEmojiCreateMono(this, this.name, newValue, this.applicationInfo);
    }

    public final ApplicationEmojiCreateMono withApplicationInfo(ApplicationInfo value) {
        if (this.applicationInfo == value) {
            return this;
        }
        ApplicationInfo newValue = Objects.requireNonNull(value, "applicationInfo");
        return new ApplicationEmojiCreateMono(this, this.name, this.image, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApplicationEmojiCreateMono && this.equalTo(0, (ApplicationEmojiCreateMono)another);
    }

    private boolean equalTo(int synthetic, ApplicationEmojiCreateMono another) {
        return this.name.equals(another.name) && this.image.equals((Object)another.image) && this.applicationInfo.equals(another.applicationInfo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.image.hashCode();
        h += (h << 5) + this.applicationInfo.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "ApplicationEmojiCreateMono{name=" + this.name + ", image=" + this.image + ", applicationInfo=" + this.applicationInfo + "}";
    }

    public static ApplicationEmojiCreateMono of(String name, Image image, ApplicationInfo applicationInfo) {
        return new ApplicationEmojiCreateMono(name, image, applicationInfo);
    }

    static ApplicationEmojiCreateMono copyOf(ApplicationEmojiCreateMonoGenerator instance) {
        if (instance instanceof ApplicationEmojiCreateMono) {
            return (ApplicationEmojiCreateMono)instance;
        }
        return ApplicationEmojiCreateMono.of(instance.name(), instance.image(), instance.applicationInfo());
    }
}

