/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.entity.ApplicationInfo;
import discord4j.core.spec.ApplicationEditSpec;
import discord4j.core.spec.AuditSpec;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.discordjson.json.ApplicationInfoRequest;
import discord4j.discordjson.json.InstallParamsData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;

@Value.Immutable(singleton=true)
interface ApplicationEditSpecGenerator
extends AuditSpec<ApplicationInfoRequest> {
    public Possible<String> customInstallUrl();

    public Possible<String> description();

    public Possible<String> roleConnectionsVerificationUrl();

    public Possible<InstallParamsData> installParams();

    public Possible<Integer> flags();

    public Possible<Optional<Image>> icon();

    public Possible<Optional<Image>> coverImage();

    public Possible<String> interactionsEndpointUrl();

    public Possible<List<String>> tags();

    @Override
    default public ApplicationInfoRequest asRequest() {
        return ApplicationInfoRequest.builder().customInstallUrl(this.customInstallUrl()).description(this.description()).roleConnectionsVerificationUrl(this.roleConnectionsVerificationUrl()).installParams(this.installParams()).flags(this.flags()).icon(InternalSpecUtils.mapPossibleOptional(this.icon(), Image::getDataUri)).coverImage(InternalSpecUtils.mapPossibleOptional(this.coverImage(), Image::getDataUri)).interactionsEndpointUrl(this.interactionsEndpointUrl()).tags(this.tags()).build();
    }

    @Value.Immutable(builder=false)
    public static abstract class ApplicationEditMonoGenerator
    extends Mono<ApplicationInfo>
    implements ApplicationEditSpecGenerator {
        abstract ApplicationInfo applicationInfo();

        public void subscribe(CoreSubscriber<? super ApplicationInfo> actual) {
            this.applicationInfo().edit(ApplicationEditSpec.copyOf(this)).subscribe(actual);
        }

        public abstract String toString();
    }
}

