/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.onboarding;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.onboarding.OnboardingPrompt;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.OnboardingData;
import discord4j.discordjson.json.OnboardingPromptData;
import java.util.List;
import java.util.stream.Collectors;

public class Onboarding
implements Entity {
    private final GatewayDiscordClient client;
    private final OnboardingData data;
    private final Snowflake guildId;
    private final List<OnboardingPrompt> prompts;
    private final List<Snowflake> defaultChannelIds;

    public Onboarding(GatewayDiscordClient client, OnboardingData data) {
        this.client = client;
        this.data = data;
        this.guildId = Snowflake.of((Id)data.guildId());
        this.prompts = data.prompts().stream().map(promptData -> new OnboardingPrompt(client, (OnboardingPromptData)promptData)).collect(Collectors.toList());
        this.defaultChannelIds = data.defaultChannelIds().stream().map(Snowflake::of).collect(Collectors.toList());
    }

    public OnboardingData getData() {
        return this.data;
    }

    public Snowflake getGuildId() {
        return this.guildId;
    }

    public boolean isEnabled() {
        return this.data.enabled();
    }

    public Mode getMode() {
        return Mode.from(this.data.mode());
    }

    public List<OnboardingPrompt> getPrompts() {
        return this.prompts;
    }

    public List<Snowflake> getDefaultChannelIds() {
        return this.defaultChannelIds;
    }

    @Override
    public Snowflake getId() {
        return this.guildId;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.client;
    }

    public String toString() {
        return "Onboarding{guildId=" + this.guildId + ", prompts=" + this.prompts + ", defaultChannelIds=" + this.defaultChannelIds + '}';
    }

    public static enum Mode {
        UNKNOWN(-1),
        ONBOARDING_DEFAULT(0),
        ONBOARDING_ADVANCED(1);

        private final int value;

        private Mode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Mode from(int value) {
            switch (value) {
                case 0: {
                    return ONBOARDING_DEFAULT;
                }
                case 1: {
                    return ONBOARDING_ADVANCED;
                }
            }
            return UNKNOWN;
        }
    }
}

