/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Emoji;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.GuildEmojiEditMono;
import discord4j.core.spec.GuildEmojiEditSpec;
import discord4j.core.spec.legacy.LegacyGuildEmojiEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.UserData;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class GuildEmoji
extends Emoji {
    private final long guildId;

    public GuildEmoji(GatewayDiscordClient gateway, EmojiData data, long guildId) {
        super(gateway, data);
        this.guildId = guildId;
    }

    public Set<Snowflake> getRoleIds() {
        return this.data.roles().toOptional().map(roles -> roles.stream().map(Snowflake::of).collect(Collectors.toSet())).orElseThrow(IllegalStateException::new);
    }

    public Flux<Role> getRoles() {
        return Flux.fromIterable(this.getRoleIds()).flatMap(id -> this.gateway.getRoleById(this.getGuildId(), (Snowflake)id));
    }

    public Flux<Role> getRoles(EntityRetrievalStrategy retrievalStrategy) {
        return Flux.fromIterable(this.getRoleIds()).flatMap(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getRoleById(this.getGuildId(), (Snowflake)id));
    }

    @Override
    public Mono<User> getUser() {
        UserData user = (UserData)this.data.user().toOptional().orElseThrow(IllegalStateException::new);
        return this.gateway.getRestClient().getEmojiService().getGuildEmoji(this.getGuildId().asLong(), this.getId().asLong()).map(data -> new User(this.gateway, user));
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.gateway.getGuildById(this.getGuildId());
    }

    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    @Deprecated
    public Mono<GuildEmoji> edit(Consumer<? super LegacyGuildEmojiEditSpec> spec) {
        return Mono.defer(() -> {
            LegacyGuildEmojiEditSpec mutatedSpec = new LegacyGuildEmojiEditSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getEmojiService().modifyGuildEmoji(this.getGuildId().asLong(), this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> new GuildEmoji(this.gateway, (EmojiData)data, this.getGuildId().asLong()));
    }

    public GuildEmojiEditMono edit() {
        return GuildEmojiEditMono.of(this);
    }

    public Mono<GuildEmoji> edit(GuildEmojiEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.gateway.getRestClient().getEmojiService().modifyGuildEmoji(this.getGuildId().asLong(), this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> new GuildEmoji(this.gateway, (EmojiData)data, this.getGuildId().asLong()));
    }

    public Mono<Void> delete() {
        return this.delete(null);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.gateway.getRestClient().getEmojiService().deleteGuildEmoji(this.getGuildId().asLong(), this.getId().asLong(), reason);
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    @Override
    public String toString() {
        return "GuildEmoji{data=" + this.data + ", guildId=" + this.guildId + '}';
    }
}

