/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.command.ApplicationCommandInteractionOptionValue;
import discord4j.core.object.command.ApplicationCommandOption;
import discord4j.discordjson.json.ApplicationCommandInteractionOptionData;
import discord4j.discordjson.json.ApplicationCommandInteractionResolvedData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

@Experimental
public class ApplicationCommandInteractionOption
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final ApplicationCommandInteractionOptionData data;
    @Nullable
    private final Long guildId;
    @Nullable
    private final ApplicationCommandInteractionResolvedData resolved;

    public ApplicationCommandInteractionOption(GatewayDiscordClient gateway, ApplicationCommandInteractionOptionData data, @Nullable Long guildId, @Nullable ApplicationCommandInteractionResolvedData resolved) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
        this.guildId = guildId;
        this.resolved = resolved;
    }

    public String getName() {
        return this.data.name();
    }

    public Optional<ApplicationCommandInteractionOptionValue> getValue() {
        return this.data.value().toOptional().map(value -> new ApplicationCommandInteractionOptionValue(this.gateway, this.guildId, this.data.type(), (String)value, this.resolved));
    }

    public ApplicationCommandOption.Type getType() {
        return ApplicationCommandOption.Type.of(this.data.type());
    }

    public List<ApplicationCommandInteractionOption> getOptions() {
        return this.data.options().toOptional().orElse(Collections.emptyList()).stream().map(data -> new ApplicationCommandInteractionOption(this.gateway, (ApplicationCommandInteractionOptionData)data, this.guildId, this.resolved)).collect(Collectors.toList());
    }

    public Optional<ApplicationCommandInteractionOption> getOption(String name) {
        return this.data.options().toOptional().orElse(Collections.emptyList()).stream().filter(data -> data.name().equals(name)).findFirst().map(data -> new ApplicationCommandInteractionOption(this.gateway, (ApplicationCommandInteractionOptionData)data, this.guildId, this.resolved));
    }

    public boolean isFocused() {
        return this.data.focused().toOptional().orElse(false);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }
}

