/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.command.ApplicationCommandContexts;
import discord4j.core.object.command.ApplicationCommandOption;
import discord4j.core.object.command.ApplicationIntegrationType;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ApplicationCommandData;
import discord4j.discordjson.json.ApplicationCommandOptionData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.PermissionSet;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ApplicationCommand
implements DiscordObject {
    public static final int MAX_NAME_LENGTH = 32;
    public static final int MAX_DESCRIPTION_LENGTH = 100;
    private final GatewayDiscordClient gateway;
    private final ApplicationCommandData data;

    public ApplicationCommand(GatewayDiscordClient gateway, ApplicationCommandData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public Snowflake getVersion() {
        return Snowflake.of((Id)this.data.version());
    }

    public Optional<Snowflake> getGuildId() {
        return this.data.guildId().toOptional().map(Snowflake::of);
    }

    public Type getType() {
        return this.data.type().toOptional().map(Type::of).orElse(Type.CHAT_INPUT);
    }

    public Snowflake getApplicationId() {
        return Snowflake.of((Id)this.data.applicationId());
    }

    public String getName() {
        return this.data.name();
    }

    public Map<Locale, String> getLocalizedNames() {
        return Possible.flatOpt((Possible)this.data.nameLocalizations()).orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(entry -> new Locale.Builder().setLanguageTag((String)entry.getKey()).build(), Map.Entry::getValue));
    }

    public String getDescription() {
        return this.data.description();
    }

    public Map<Locale, String> getLocalizedDescriptions() {
        return Possible.flatOpt((Possible)this.data.descriptionLocalizations()).orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(entry -> new Locale.Builder().setLanguageTag((String)entry.getKey()).build(), Map.Entry::getValue));
    }

    public PermissionSet getDefaultMemberPermissions() {
        return this.data.defaultMemberPermissions().map(Long::parseLong).map(PermissionSet::of).orElse(PermissionSet.none());
    }

    public List<ApplicationCommandOption> getOptions() {
        return this.data.options().toOptional().orElse(Collections.emptyList()).stream().map(data -> new ApplicationCommandOption(this.gateway, (ApplicationCommandOptionData)data)).collect(Collectors.toList());
    }

    public Optional<ApplicationCommandOption> getOption(String name) {
        return this.data.options().toOptional().orElse(Collections.emptyList()).stream().filter(option -> option.name().equals(name)).findFirst().map(data -> new ApplicationCommandOption(this.gateway, (ApplicationCommandOptionData)data));
    }

    public boolean isAvailableInDM() {
        return this.data.contexts().contains(ApplicationCommandContexts.PRIVATE_CHANNEL.getValue());
    }

    public List<ApplicationIntegrationType> getIntegrationTypes() {
        return this.data.integrationTypes().stream().map(ApplicationIntegrationType::of).collect(Collectors.toList());
    }

    public List<ApplicationCommandContexts> getContexts() {
        return this.data.contexts().stream().map(ApplicationCommandContexts::of).collect(Collectors.toList());
    }

    public boolean isNsfw() {
        return this.data.nsfw().toOptional().orElse(false);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public static enum Type {
        UNKNOWN(-1),
        CHAT_INPUT(1),
        USER(2),
        MESSAGE(3);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return CHAT_INPUT;
                }
                case 2: {
                    return USER;
                }
                case 3: {
                    return MESSAGE;
                }
            }
            return UNKNOWN;
        }
    }
}

