/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.User;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.core.spec.SoundboardSoundEditMono;
import discord4j.core.spec.SoundboardSoundEditSpec;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.ImmutableSendSoundboardSoundRequest;
import discord4j.discordjson.json.SendSoundboardSoundRequest;
import discord4j.discordjson.json.SoundboardSoundData;
import discord4j.discordjson.json.UserData;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class SoundboardSound
implements Entity {
    private final GatewayDiscordClient gateway;
    private final SoundboardSoundData data;

    public SoundboardSound(GatewayDiscordClient gateway, SoundboardSoundData data) {
        this.gateway = gateway;
        this.data = data;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.soundId());
    }

    public String getName() {
        return this.data.name();
    }

    public double getVolume() {
        return this.data.volume();
    }

    public boolean isAvailable() {
        return this.data.available();
    }

    public Optional<ReactionEmoji> getEmoji() {
        if (this.data.emojiId().isPresent() || this.data.emojiName().isPresent()) {
            return Optional.of(ReactionEmoji.of((EmojiData)EmojiData.builder().id(this.data.emojiId()).name(this.data.emojiName()).build()));
        }
        return Optional.empty();
    }

    public Optional<Snowflake> getGuildId() {
        return this.data.guildId().toOptional().map(Snowflake::of);
    }

    public Optional<User> getUser() {
        return this.data.user().toOptional().map(userData -> new User(this.gateway, (UserData)userData));
    }

    public Mono<Void> sendSound(Snowflake voiceChannelId) {
        ImmutableSendSoundboardSoundRequest.Builder builder = SendSoundboardSoundRequest.builder();
        builder.soundId(this.data.soundId());
        if (this.getGuildId().isPresent()) {
            builder.sourceGuildId(this.getGuildId().get().asLong());
        }
        return this.getClient().getRestClient().getSoundboardService().sendSoundboardSound(voiceChannelId.asLong(), (SendSoundboardSoundRequest)builder.build());
    }

    public SoundboardSoundEditMono edit() {
        if (!this.getGuildId().isPresent()) {
            throw new IllegalStateException("Cannot edit a soundboard sound without guild id.");
        }
        return SoundboardSoundEditMono.of(this);
    }

    public Mono<SoundboardSound> edit(SoundboardSoundEditSpec spec) {
        if (!this.getGuildId().isPresent()) {
            return Mono.error((Throwable)new IllegalStateException("Cannot edit a soundboard sound without guild id."));
        }
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.gateway.getRestClient().getSoundboardService().modifyGuildSoundboardSound(this.getGuildId().get().asLong(), this.getId().asLong(), spec.asRequest(), spec.reason()).map(data -> new SoundboardSound(this.gateway, (SoundboardSoundData)data)));
    }

    public Mono<Void> delete() {
        return this.delete(null);
    }

    public Mono<Void> delete(@Nullable String reason) {
        if (!this.getGuildId().isPresent()) {
            return Mono.error((Throwable)new IllegalStateException("Cannot delete soundboard sound without guild id."));
        }
        return this.getClient().getRestClient().getSoundboardService().deleteGuildSoundboardSound(this.getGuildId().get().asLong(), this.getId().asLong(), reason);
    }

    public SoundboardSoundData getData() {
        return this.data;
    }
}

