/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.poll;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.object.entity.poll.Poll;
import discord4j.core.object.entity.poll.PollAnswer;
import discord4j.gateway.ShardInfo;
import java.util.Optional;
import reactor.core.publisher.Mono;

public class PollVoteEvent
extends Event {
    private final Snowflake userId;
    private final Snowflake channelId;
    private final Snowflake messageId;
    private final Optional<Snowflake> guildId;
    private final int answerId;

    protected PollVoteEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Snowflake userId, Snowflake channelId, Snowflake messageId, Optional<Snowflake> guildId, int answerId) {
        super(gateway, shardInfo);
        this.userId = userId;
        this.channelId = channelId;
        this.messageId = messageId;
        this.guildId = guildId;
        this.answerId = answerId;
    }

    public Snowflake getUserId() {
        return this.userId;
    }

    public Mono<User> getUser() {
        return super.getClient().getUserById(this.userId);
    }

    public Snowflake getChannelId() {
        return this.channelId;
    }

    public Mono<MessageChannel> getChannel() {
        return super.getClient().getChannelById(this.channelId).ofType(MessageChannel.class);
    }

    public Snowflake getMessageId() {
        return this.messageId;
    }

    public Mono<Message> getMessage() {
        return super.getClient().getMessageById(this.channelId, this.messageId);
    }

    public Mono<Poll> getPoll() {
        return super.getClient().getMessageById(this.channelId, this.messageId).map(Message::getPoll).flatMap(Mono::justOrEmpty);
    }

    public Optional<Snowflake> getGuildId() {
        return this.guildId;
    }

    public int getAnswerId() {
        return this.answerId;
    }

    public Mono<PollAnswer> getAnswer() {
        return this.getPoll().flatMap(poll -> Mono.justOrEmpty(poll.getAnswerById(this.answerId)));
    }
}

