/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.message;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.message.MessageEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.gateway.ShardInfo;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class ReactionRemoveAllEvent
extends MessageEvent {
    private final long channelId;
    private final long messageId;
    @Nullable
    private final Long guildId;

    public ReactionRemoveAllEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long channelId, long messageId, @Nullable Long guildId) {
        super(gateway, shardInfo);
        this.channelId = channelId;
        this.messageId = messageId;
        this.guildId = guildId;
    }

    public Snowflake getChannelId() {
        return Snowflake.of((long)this.channelId);
    }

    public Mono<MessageChannel> getChannel() {
        return this.getClient().getChannelById(this.getChannelId()).cast(MessageChannel.class);
    }

    public Snowflake getMessageId() {
        return Snowflake.of((long)this.messageId);
    }

    public Mono<Message> getMessage() {
        return this.getClient().getMessageById(this.getChannelId(), this.getMessageId());
    }

    public Optional<Snowflake> getGuildId() {
        return Optional.ofNullable(this.guildId).map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return Mono.justOrEmpty(this.getGuildId()).flatMap(this.getClient()::getGuildById);
    }

    public String toString() {
        return "ReactionRemoveAllEvent{channelId=" + this.channelId + ", messageId=" + this.messageId + ", guildId=" + this.guildId + '}';
    }
}

