/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.interaction;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.interaction.ApplicationCommandInteractionEvent;
import discord4j.core.object.command.ApplicationCommandInteractionOption;
import discord4j.core.object.command.ApplicationCommandInteractionOptionValue;
import discord4j.core.object.command.Interaction;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.gateway.ShardInfo;
import java.util.List;
import java.util.Optional;
import reactor.core.publisher.Mono;

@Experimental
public class ChatInputInteractionEvent
extends ApplicationCommandInteractionEvent {
    public ChatInputInteractionEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Interaction interaction) {
        super(gateway, shardInfo, interaction);
    }

    public List<ApplicationCommandInteractionOption> getOptions() {
        return this.getInteraction().getCommandInteraction().orElseThrow(IllegalStateException::new).getOptions();
    }

    public Optional<ApplicationCommandInteractionOption> getOption(String name) {
        return this.getInteraction().getCommandInteraction().orElseThrow(IllegalStateException::new).getOption(name);
    }

    public Optional<String> getOptionAsString(String name) {
        return this.getOption(name).flatMap(ApplicationCommandInteractionOption::getValue).map(ApplicationCommandInteractionOptionValue::asString);
    }

    public Optional<Boolean> getOptionAsBoolean(String name) {
        return this.getOption(name).flatMap(ApplicationCommandInteractionOption::getValue).map(ApplicationCommandInteractionOptionValue::asBoolean);
    }

    public Optional<Long> getOptionAsLong(String name) {
        return this.getOption(name).flatMap(ApplicationCommandInteractionOption::getValue).map(ApplicationCommandInteractionOptionValue::asLong);
    }

    public Optional<Double> getOptionAsDouble(String name) {
        return this.getOption(name).flatMap(ApplicationCommandInteractionOption::getValue).map(ApplicationCommandInteractionOptionValue::asDouble);
    }

    public Optional<Snowflake> getOptionAsSnowflake(String name) {
        return this.getOption(name).flatMap(ApplicationCommandInteractionOption::getValue).map(ApplicationCommandInteractionOptionValue::asSnowflake);
    }

    public Mono<User> getOptionAsUser(String name) {
        return this.getOption(name).flatMap(ApplicationCommandInteractionOption::getValue).map(ApplicationCommandInteractionOptionValue::asUser).orElse(Mono.empty());
    }

    public Mono<Role> getOptionAsRole(String name) {
        return this.getOption(name).flatMap(ApplicationCommandInteractionOption::getValue).map(ApplicationCommandInteractionOptionValue::asRole).orElse(Mono.empty());
    }

    public Mono<Channel> getOptionAsChannel(String name) {
        return this.getOption(name).flatMap(ApplicationCommandInteractionOption::getValue).map(ApplicationCommandInteractionOptionValue::asChannel).orElse(Mono.empty());
    }

    public Optional<Attachment> getOptionAsAttachment(String name) {
        return this.getOption(name).flatMap(ApplicationCommandInteractionOption::getValue).map(ApplicationCommandInteractionOptionValue::asAttachment);
    }
}

