/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.service;

import discord4j.discordjson.json.ApplicationEmojiCreateRequest;
import discord4j.discordjson.json.ApplicationEmojiDataList;
import discord4j.discordjson.json.ApplicationEmojiModifyRequest;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildEmojiCreateRequest;
import discord4j.discordjson.json.GuildEmojiModifyRequest;
import discord4j.rest.request.Router;
import discord4j.rest.route.Routes;
import discord4j.rest.service.RestService;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class EmojiService
extends RestService {
    public EmojiService(Router router) {
        super(router);
    }

    public Flux<EmojiData> getGuildEmojis(long guildId) {
        return Routes.GUILD_EMOJIS_GET.newRequest(guildId).exchange(this.getRouter()).bodyToMono(EmojiData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<EmojiData> getGuildEmoji(long guildId, long emojiId) {
        return Routes.GUILD_EMOJI_GET.newRequest(guildId, emojiId).exchange(this.getRouter()).bodyToMono(EmojiData.class);
    }

    public Mono<EmojiData> createGuildEmoji(long guildId, GuildEmojiCreateRequest request, @Nullable String reason) {
        return Routes.GUILD_EMOJI_CREATE.newRequest(guildId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(EmojiData.class);
    }

    public Mono<EmojiData> modifyGuildEmoji(long guildId, long emojiId, GuildEmojiModifyRequest request, @Nullable String reason) {
        return Routes.GUILD_EMOJI_MODIFY.newRequest(guildId, emojiId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(EmojiData.class);
    }

    public Mono<Void> deleteGuildEmoji(long guildId, long emojiId, @Nullable String reason) {
        return Routes.GUILD_EMOJI_DELETE.newRequest(guildId, emojiId).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(Void.class);
    }

    public Mono<ApplicationEmojiDataList> getApplicationEmojis(long applicationId) {
        return Routes.APPLICATION_EMOJIS_GET.newRequest(applicationId).exchange(this.getRouter()).bodyToMono(ApplicationEmojiDataList.class);
    }

    public Mono<EmojiData> getApplicationEmoji(long guildId, long emojiId) {
        return Routes.APPLICATION_EMOJI_GET.newRequest(guildId, emojiId).exchange(this.getRouter()).bodyToMono(EmojiData.class);
    }

    public Mono<EmojiData> createApplicationEmoji(long applicationId, ApplicationEmojiCreateRequest request) {
        return Routes.APPLICATION_EMOJI_CREATE.newRequest(applicationId).body(request).exchange(this.getRouter()).bodyToMono(EmojiData.class);
    }

    public Mono<EmojiData> modifyApplicationEmoji(long applicationId, long emojiId, ApplicationEmojiModifyRequest request) {
        return Routes.APPLICATION_EMOJI_MODIFY.newRequest(applicationId, emojiId).body(request).exchange(this.getRouter()).bodyToMono(EmojiData.class);
    }

    public Mono<Void> deleteApplicationEmoji(long applicationId, long emojiId) {
        return Routes.APPLICATION_EMOJI_DELETE.newRequest(applicationId, emojiId).exchange(this.getRouter()).bodyToMono(Void.class);
    }
}

