/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.route;

import discord4j.rest.request.DiscordWebRequest;
import io.netty.handler.codec.http.HttpMethod;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public class Route {
    private final HttpMethod method;
    private final String uriTemplate;

    private Route(HttpMethod method, String uriTemplate) {
        this.method = method;
        this.uriTemplate = uriTemplate;
    }

    public static Route get(String uri) {
        return new Route(HttpMethod.GET, uri);
    }

    public static Route post(String uri) {
        return new Route(HttpMethod.POST, uri);
    }

    public static Route put(String uri) {
        return new Route(HttpMethod.PUT, uri);
    }

    public static Route patch(String uri) {
        return new Route(HttpMethod.PATCH, uri);
    }

    public static Route delete(String uri) {
        return new Route(HttpMethod.DELETE, uri);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public DiscordWebRequest newRequest(Object ... uriVars) {
        return new DiscordWebRequest(this, uriVars);
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public int hashCode() {
        return Objects.hash(this.method, this.uriTemplate);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().isAssignableFrom(Route.class)) {
            return false;
        }
        Route other = (Route)obj;
        return other.method.equals((Object)this.method) && other.uriTemplate.equals(this.uriTemplate);
    }

    public String toString() {
        return "Route{method=" + this.method + ", uriTemplate='" + this.uriTemplate + '\'' + '}';
    }
}

