/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.response;

import discord4j.common.annotations.Experimental;
import discord4j.rest.http.client.ClientException;
import discord4j.rest.http.client.ClientResponse;
import discord4j.rest.request.DiscordWebRequest;
import discord4j.rest.request.RouteMatcher;
import discord4j.rest.response.EmptyResponseTransformer;
import discord4j.rest.response.RetryingTransformer;
import java.time.Duration;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.retry.Retry;

@Experimental
public interface ResponseFunction {
    public Function<Mono<ClientResponse>, Mono<ClientResponse>> transform(DiscordWebRequest var1);

    public static EmptyResponseTransformer emptyIfNotFound() {
        return new EmptyResponseTransformer(RouteMatcher.any(), ClientException.isStatusCode(404));
    }

    public static EmptyResponseTransformer emptyIfNotFound(RouteMatcher routeMatcher) {
        return new EmptyResponseTransformer(routeMatcher, ClientException.isStatusCode(404));
    }

    public static EmptyResponseTransformer emptyOnErrorStatus(RouteMatcher routeMatcher, Integer ... codes) {
        return new EmptyResponseTransformer(routeMatcher, ClientException.isStatusCode(codes));
    }

    public static RetryingTransformer retryOnceOnErrorStatus(Integer ... codes) {
        return new RetryingTransformer(RouteMatcher.any(), Retry.onlyIf(ClientException.isRetryContextStatusCode(codes)).fixedBackoff(Duration.ofSeconds(1L)).retryOnce());
    }

    public static RetryingTransformer retryOnceOnErrorStatus(RouteMatcher routeMatcher, Integer ... codes) {
        return new RetryingTransformer(routeMatcher, Retry.onlyIf(ClientException.isRetryContextStatusCode(codes)).fixedBackoff(Duration.ofSeconds(1L)).retryOnce());
    }

    public static RetryingTransformer retryWhen(RouteMatcher routeMatcher, Retry<?> retry) {
        return new RetryingTransformer(routeMatcher, retry);
    }
}

