/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.TemplateCreateGuildRequest;
import discord4j.discordjson.json.TemplateData;
import discord4j.rest.RestClient;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class RestGuildTemplate {
    private final RestClient restClient;
    private final String code;

    private RestGuildTemplate(RestClient restClient, String code) {
        this.restClient = restClient;
        this.code = code;
    }

    public static RestGuildTemplate create(RestClient restClient, String code) {
        return new RestGuildTemplate(restClient, code);
    }

    public String getCode() {
        return this.code;
    }

    public Mono<TemplateData> getData() {
        return this.restClient.getTemplateService().getTemplate(this.code);
    }

    public Mono<GuildData> createGuild(TemplateCreateGuildRequest request) {
        return this.restClient.getTemplateService().createGuild(this.code, request);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestGuildTemplate that = (RestGuildTemplate)o;
        return Objects.equals(this.code, that.code);
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }
}

