/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.PartialMessageUpdateData;
import discord4j.discordjson.json.gateway.MessageUpdate;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableMessageUpdate
implements MessageUpdate {
    private final PartialMessageUpdateData message;

    private ImmutableMessageUpdate(PartialMessageUpdateData message) {
        this.message = Objects.requireNonNull(message, "message");
    }

    private ImmutableMessageUpdate(ImmutableMessageUpdate original, PartialMessageUpdateData message) {
        this.message = message;
    }

    @Override
    @JsonProperty(value="message")
    @JsonUnwrapped
    public PartialMessageUpdateData message() {
        return this.message;
    }

    public final ImmutableMessageUpdate withMessage(PartialMessageUpdateData value) {
        if (this.message == value) {
            return this;
        }
        PartialMessageUpdateData newValue = Objects.requireNonNull(value, "message");
        return new ImmutableMessageUpdate(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageUpdate && this.equalTo(0, (ImmutableMessageUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageUpdate another) {
        return this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return "MessageUpdate{message=" + this.message + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMessageUpdate fromJson(Json json) {
        Builder builder = ImmutableMessageUpdate.builder();
        if (json.message != null) {
            builder.message(json.message);
        }
        return builder.build();
    }

    public static ImmutableMessageUpdate of(PartialMessageUpdateData message) {
        return new ImmutableMessageUpdate(message);
    }

    public static ImmutableMessageUpdate copyOf(MessageUpdate instance) {
        if (instance instanceof ImmutableMessageUpdate) {
            return (ImmutableMessageUpdate)instance;
        }
        return ImmutableMessageUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private long initBits = 1L;
        @Nullable
        private PartialMessageUpdateData message;

        private Builder() {
        }

        public final Builder from(MessageUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.message(instance.message());
            return this;
        }

        @JsonProperty(value="message")
        @JsonUnwrapped
        public final Builder message(PartialMessageUpdateData message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageUpdate(null, this.message);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build MessageUpdate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements MessageUpdate {
        @Nullable
        PartialMessageUpdateData message;

        Json() {
        }

        @JsonProperty(value="message")
        @JsonUnwrapped
        public void setMessage(PartialMessageUpdateData message) {
            this.message = message;
        }

        @Override
        public PartialMessageUpdateData message() {
            throw new UnsupportedOperationException();
        }
    }
}

