/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.WebhookModifyRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableWebhookModifyRequest
implements WebhookModifyRequest {
    private final String name_value;
    private final boolean name_absent;
    private final String avatar_value;
    private final boolean avatar_absent;
    private final String channelId_value;
    private final boolean channelId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableWebhookModifyRequest(Possible<String> name, Possible<String> avatar, Possible<String> channelId) {
        Possible<String> name$impl = name;
        Possible<String> avatar$impl = avatar;
        Possible<String> channelId$impl = channelId;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.avatar_value = avatar$impl.toOptional().orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.channelId_value = channelId$impl.toOptional().orElse(null);
        this.channelId_absent = channelId$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableWebhookModifyRequest(ImmutableWebhookModifyRequest original, Possible<String> name, Possible<String> avatar, Possible<String> channelId) {
        Possible<String> name$impl = name;
        Possible<String> avatar$impl = avatar;
        Possible<String> channelId$impl = channelId;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.avatar_value = avatar$impl.toOptional().orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.channelId_value = channelId$impl.toOptional().orElse(null);
        this.channelId_absent = channelId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    @JsonProperty(value="avatar")
    public Possible<String> avatar() {
        return this.avatar_absent ? Possible.absent() : Possible.of((Object)this.avatar_value);
    }

    @Override
    @JsonProperty(value="channel_id")
    public Possible<String> channelId() {
        return this.channelId_absent ? Possible.absent() : Possible.of((Object)this.channelId_value);
    }

    public ImmutableWebhookModifyRequest withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookModifyRequest(this, newValue, this.avatar(), this.channelId());
    }

    public ImmutableWebhookModifyRequest withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableWebhookModifyRequest(this, (Possible<String>)newValue, this.avatar(), this.channelId());
    }

    public ImmutableWebhookModifyRequest withAvatar(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookModifyRequest(this, this.name(), newValue, this.channelId());
    }

    public ImmutableWebhookModifyRequest withAvatar(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableWebhookModifyRequest(this, this.name(), (Possible<String>)newValue, this.channelId());
    }

    public ImmutableWebhookModifyRequest withChannelId(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookModifyRequest(this, this.name(), this.avatar(), newValue);
    }

    public ImmutableWebhookModifyRequest withChannelId(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableWebhookModifyRequest(this, this.name(), this.avatar(), (Possible<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookModifyRequest && this.equalTo(0, (ImmutableWebhookModifyRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebhookModifyRequest another) {
        return this.name().equals(another.name()) && this.avatar().equals(another.avatar()) && this.channelId().equals(another.channelId());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.avatar().hashCode();
        h += (h << 5) + this.channelId().hashCode();
        return h;
    }

    public String toString() {
        return "WebhookModifyRequest{name=" + this.name().toString() + ", avatar=" + this.avatar().toString() + ", channelId=" + this.channelId().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWebhookModifyRequest fromJson(Json json) {
        Builder builder = ImmutableWebhookModifyRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.avatar != null) {
            builder.avatar(json.avatar);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        return builder.build();
    }

    public static ImmutableWebhookModifyRequest of(Possible<String> name, Possible<String> avatar, Possible<String> channelId) {
        return new ImmutableWebhookModifyRequest(name, avatar, channelId);
    }

    public static ImmutableWebhookModifyRequest copyOf(WebhookModifyRequest instance) {
        if (instance instanceof ImmutableWebhookModifyRequest) {
            return (ImmutableWebhookModifyRequest)instance;
        }
        return ImmutableWebhookModifyRequest.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isAvatarPresent() {
        return !this.avatar_absent;
    }

    public String avatarOrElse(String defaultValue) {
        return !this.avatar_absent ? this.avatar_value : defaultValue;
    }

    public boolean isChannelIdPresent() {
        return !this.channelId_absent;
    }

    public String channelIdOrElse(String defaultValue) {
        return !this.channelId_absent ? this.channelId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<String> avatar_possible = Possible.absent();
        private Possible<String> channelId_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(WebhookModifyRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.avatar(instance.avatar());
            this.channelId(instance.channelId());
            return this;
        }

        @JsonProperty(value="name")
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        public Builder name(String value) {
            this.name_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="avatar")
        public Builder avatar(Possible<String> value) {
            this.avatar_possible = value;
            return this;
        }

        public Builder avatar(String value) {
            this.avatar_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="channel_id")
        public Builder channelId(Possible<String> value) {
            this.channelId_possible = value;
            return this;
        }

        public Builder channelId(String value) {
            this.channelId_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableWebhookModifyRequest build() {
            return new ImmutableWebhookModifyRequest(null, this.name_build(), this.avatar_build(), this.channelId_build());
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<String> avatar_build() {
            return this.avatar_possible;
        }

        private Possible<String> channelId_build() {
            return this.channelId_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements WebhookModifyRequest {
        Possible<String> name = Possible.absent();
        Possible<String> avatar = Possible.absent();
        Possible<String> channelId = Possible.absent();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(Possible<String> name) {
            this.name = name;
        }

        @JsonProperty(value="avatar")
        public void setAvatar(Possible<String> avatar) {
            this.avatar = avatar;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Possible<String> channelId) {
            this.channelId = channelId;
        }

        @Override
        public Possible<String> name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> avatar() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> channelId() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build WebhookModifyRequest, attribute initializers form cycle " + attributes;
        }
    }
}

