/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.PollAnswerObject;
import discord4j.discordjson.json.PollCreateData;
import discord4j.discordjson.json.PollMediaObject;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutablePollCreateData
implements PollCreateData {
    private final PollMediaObject question_value;
    private final boolean question_absent;
    private final List<PollAnswerObject> answers_value;
    private final boolean answers_absent;
    private final Integer duration_value;
    private final boolean duration_absent;
    private final Boolean allowMultiselect_value;
    private final boolean allowMultiselect_absent;
    private final Integer layoutType_value;
    private final boolean layoutType_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePollCreateData(Possible<PollMediaObject> question, Possible<List<PollAnswerObject>> answers, Possible<Integer> duration, Possible<Boolean> allowMultiselect, Possible<Integer> layoutType) {
        Possible<PollMediaObject> question$impl = question;
        Possible<List<PollAnswerObject>> answers$impl = answers;
        Possible<Integer> duration$impl = duration;
        Possible<Boolean> allowMultiselect$impl = allowMultiselect;
        Possible<Integer> layoutType$impl = layoutType;
        this.question_value = question$impl.toOptional().orElse(null);
        this.question_absent = question$impl.isAbsent();
        this.answers_value = answers$impl.toOptional().orElse(null);
        this.answers_absent = answers$impl.isAbsent();
        this.duration_value = duration$impl.toOptional().orElse(null);
        this.duration_absent = duration$impl.isAbsent();
        this.allowMultiselect_value = allowMultiselect$impl.toOptional().orElse(null);
        this.allowMultiselect_absent = allowMultiselect$impl.isAbsent();
        this.layoutType_value = layoutType$impl.toOptional().orElse(null);
        this.layoutType_absent = layoutType$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutablePollCreateData(ImmutablePollCreateData original, Possible<PollMediaObject> question, Possible<List<PollAnswerObject>> answers, Possible<Integer> duration, Possible<Boolean> allowMultiselect, Possible<Integer> layoutType) {
        Possible<PollMediaObject> question$impl = question;
        Possible<List<PollAnswerObject>> answers$impl = answers;
        Possible<Integer> duration$impl = duration;
        Possible<Boolean> allowMultiselect$impl = allowMultiselect;
        Possible<Integer> layoutType$impl = layoutType;
        this.question_value = question$impl.toOptional().orElse(null);
        this.question_absent = question$impl.isAbsent();
        this.answers_value = answers$impl.toOptional().orElse(null);
        this.answers_absent = answers$impl.isAbsent();
        this.duration_value = duration$impl.toOptional().orElse(null);
        this.duration_absent = duration$impl.isAbsent();
        this.allowMultiselect_value = allowMultiselect$impl.toOptional().orElse(null);
        this.allowMultiselect_absent = allowMultiselect$impl.isAbsent();
        this.layoutType_value = layoutType$impl.toOptional().orElse(null);
        this.layoutType_absent = layoutType$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="question")
    public Possible<PollMediaObject> question() {
        return this.question_absent ? Possible.absent() : Possible.of((Object)this.question_value);
    }

    @Override
    @JsonProperty(value="answers")
    public Possible<List<PollAnswerObject>> answers() {
        return this.answers_absent ? Possible.absent() : Possible.of(this.answers_value);
    }

    @Override
    @JsonProperty(value="duration")
    public Possible<Integer> duration() {
        return this.duration_absent ? Possible.absent() : Possible.of((Object)this.duration_value);
    }

    @Override
    @JsonProperty(value="allow_multiselect")
    public Possible<Boolean> allowMultiselect() {
        return this.allowMultiselect_absent ? Possible.absent() : Possible.of((Object)this.allowMultiselect_value);
    }

    @Override
    @JsonProperty(value="layout_type")
    public Possible<Integer> layoutType() {
        return this.layoutType_absent ? Possible.absent() : Possible.of((Object)this.layoutType_value);
    }

    public ImmutablePollCreateData withQuestion(Possible<PollMediaObject> value) {
        Possible<PollMediaObject> newValue = Objects.requireNonNull(value);
        return new ImmutablePollCreateData(this, newValue, this.answers(), this.duration(), this.allowMultiselect(), this.layoutType());
    }

    public ImmutablePollCreateData withQuestion(PollMediaObject value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutablePollCreateData(this, (Possible<PollMediaObject>)newValue, this.answers(), this.duration(), this.allowMultiselect(), this.layoutType());
    }

    public ImmutablePollCreateData withAnswers(Possible<List<PollAnswerObject>> possible) {
        Possible<List<PollAnswerObject>> newValue = Objects.requireNonNull(possible);
        return new ImmutablePollCreateData(this, this.question(), newValue, this.duration(), this.allowMultiselect(), this.layoutType());
    }

    public ImmutablePollCreateData withAnswers(Iterable<PollAnswerObject> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutablePollCreateData(this, this.question(), (Possible<List<PollAnswerObject>>)newValue, this.duration(), this.allowMultiselect(), this.layoutType());
    }

    @SafeVarargs
    public final ImmutablePollCreateData withAnswers(PollAnswerObject ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new ImmutablePollCreateData(this, this.question(), (Possible<List<PollAnswerObject>>)newValue, this.duration(), this.allowMultiselect(), this.layoutType());
    }

    public ImmutablePollCreateData withDuration(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ImmutablePollCreateData(this, this.question(), this.answers(), newValue, this.allowMultiselect(), this.layoutType());
    }

    public ImmutablePollCreateData withDuration(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutablePollCreateData(this, this.question(), this.answers(), (Possible<Integer>)newValue, this.allowMultiselect(), this.layoutType());
    }

    public ImmutablePollCreateData withAllowMultiselect(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutablePollCreateData(this, this.question(), this.answers(), this.duration(), newValue, this.layoutType());
    }

    public ImmutablePollCreateData withAllowMultiselect(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutablePollCreateData(this, this.question(), this.answers(), this.duration(), (Possible<Boolean>)newValue, this.layoutType());
    }

    public ImmutablePollCreateData withLayoutType(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ImmutablePollCreateData(this, this.question(), this.answers(), this.duration(), this.allowMultiselect(), newValue);
    }

    public ImmutablePollCreateData withLayoutType(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutablePollCreateData(this, this.question(), this.answers(), this.duration(), this.allowMultiselect(), (Possible<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePollCreateData && this.equalTo(0, (ImmutablePollCreateData)another);
    }

    private boolean equalTo(int synthetic, ImmutablePollCreateData another) {
        return this.question().equals(another.question()) && Objects.equals(this.answers_value, another.answers_value) && this.duration().equals(another.duration()) && this.allowMultiselect().equals(another.allowMultiselect()) && this.layoutType().equals(another.layoutType());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.question().hashCode();
        h += (h << 5) + Objects.hashCode(this.answers_value);
        h += (h << 5) + this.duration().hashCode();
        h += (h << 5) + this.allowMultiselect().hashCode();
        h += (h << 5) + this.layoutType().hashCode();
        return h;
    }

    public String toString() {
        return "PollCreateData{question=" + this.question().toString() + ", answers=" + Objects.toString(this.answers_value) + ", duration=" + this.duration().toString() + ", allowMultiselect=" + this.allowMultiselect().toString() + ", layoutType=" + this.layoutType().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePollCreateData fromJson(Json json) {
        Builder builder = ImmutablePollCreateData.builder();
        if (json.question != null) {
            builder.question(json.question);
        }
        if (json.answers != null) {
            builder.answers(json.answers);
        }
        if (json.duration != null) {
            builder.duration(json.duration);
        }
        if (json.allowMultiselect != null) {
            builder.allowMultiselect(json.allowMultiselect);
        }
        if (json.layoutType != null) {
            builder.layoutType(json.layoutType);
        }
        return builder.build();
    }

    public static ImmutablePollCreateData of(Possible<PollMediaObject> question, Possible<List<PollAnswerObject>> answers, Possible<Integer> duration, Possible<Boolean> allowMultiselect, Possible<Integer> layoutType) {
        return new ImmutablePollCreateData(question, answers, duration, allowMultiselect, layoutType);
    }

    public static ImmutablePollCreateData copyOf(PollCreateData instance) {
        if (instance instanceof ImmutablePollCreateData) {
            return (ImmutablePollCreateData)instance;
        }
        return ImmutablePollCreateData.builder().from(instance).build();
    }

    public boolean isQuestionPresent() {
        return !this.question_absent;
    }

    public PollMediaObject questionOrElse(PollMediaObject defaultValue) {
        return !this.question_absent ? this.question_value : defaultValue;
    }

    public boolean isAnswersPresent() {
        return !this.answers_absent;
    }

    public List<PollAnswerObject> answersOrElse(List<PollAnswerObject> defaultValue) {
        return !this.answers_absent ? this.answers_value : defaultValue;
    }

    public boolean isDurationPresent() {
        return !this.duration_absent;
    }

    public Integer durationOrElse(Integer defaultValue) {
        return !this.duration_absent ? this.duration_value : defaultValue;
    }

    public boolean isAllowMultiselectPresent() {
        return !this.allowMultiselect_absent;
    }

    public Boolean allowMultiselectOrElse(Boolean defaultValue) {
        return !this.allowMultiselect_absent ? this.allowMultiselect_value : defaultValue;
    }

    public boolean isLayoutTypePresent() {
        return !this.layoutType_absent;
    }

    public Integer layoutTypeOrElse(Integer defaultValue) {
        return !this.layoutType_absent ? this.layoutType_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<PollMediaObject> question_possible = Possible.absent();
        private List<PollAnswerObject> answers_list = null;
        private Possible<Integer> duration_possible = Possible.absent();
        private Possible<Boolean> allowMultiselect_possible = Possible.absent();
        private Possible<Integer> layoutType_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(PollCreateData instance) {
            Objects.requireNonNull(instance, "instance");
            this.question(instance.question());
            this.answers(instance.answers());
            this.duration(instance.duration());
            this.allowMultiselect(instance.allowMultiselect());
            this.layoutType(instance.layoutType());
            return this;
        }

        @JsonProperty(value="question")
        public Builder question(Possible<PollMediaObject> value) {
            this.question_possible = value;
            return this;
        }

        public Builder question(PollMediaObject value) {
            this.question_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addAnswer(PollAnswerObject element) {
            this.answers_getOrCreate().add(element);
            return this;
        }

        public Builder addAllAnswers(List<PollAnswerObject> elements) {
            this.answers_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="answers")
        public Builder answers(Possible<List<PollAnswerObject>> elements) {
            this.answers_list = null;
            elements.toOptional().ifPresent(e -> this.answers_getOrCreate().addAll((Collection<PollAnswerObject>)e));
            return this;
        }

        public Builder answers(List<PollAnswerObject> elements) {
            this.answers_list = new ArrayList<PollAnswerObject>(elements);
            return this;
        }

        public Builder answers(Iterable<PollAnswerObject> elements) {
            this.answers_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="duration")
        public Builder duration(Possible<Integer> value) {
            this.duration_possible = value;
            return this;
        }

        public Builder duration(Integer value) {
            this.duration_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="allow_multiselect")
        public Builder allowMultiselect(Possible<Boolean> value) {
            this.allowMultiselect_possible = value;
            return this;
        }

        public Builder allowMultiselect(Boolean value) {
            this.allowMultiselect_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="layout_type")
        public Builder layoutType(Possible<Integer> value) {
            this.layoutType_possible = value;
            return this;
        }

        public Builder layoutType(Integer value) {
            this.layoutType_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutablePollCreateData build() {
            return new ImmutablePollCreateData(null, this.question_build(), this.answers_build(), this.duration_build(), this.allowMultiselect_build(), this.layoutType_build());
        }

        private Possible<PollMediaObject> question_build() {
            return this.question_possible;
        }

        private Possible<List<PollAnswerObject>> answers_build() {
            return this.answers_list == null ? Possible.absent() : Possible.of(this.answers_list);
        }

        private List<PollAnswerObject> answers_getOrCreate() {
            if (this.answers_list == null) {
                this.answers_list = new ArrayList<PollAnswerObject>();
            }
            return this.answers_list;
        }

        private Possible<Integer> duration_build() {
            return this.duration_possible;
        }

        private Possible<Boolean> allowMultiselect_build() {
            return this.allowMultiselect_possible;
        }

        private Possible<Integer> layoutType_build() {
            return this.layoutType_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements PollCreateData {
        Possible<PollMediaObject> question = Possible.absent();
        Possible<List<PollAnswerObject>> answers = Possible.absent();
        Possible<Integer> duration = Possible.absent();
        Possible<Boolean> allowMultiselect = Possible.absent();
        Possible<Integer> layoutType = Possible.absent();

        Json() {
        }

        @JsonProperty(value="question")
        public void setQuestion(Possible<PollMediaObject> question) {
            this.question = question;
        }

        @JsonProperty(value="answers")
        public void setAnswers(Possible<List<PollAnswerObject>> answers) {
            this.answers = answers;
        }

        @JsonProperty(value="duration")
        public void setDuration(Possible<Integer> duration) {
            this.duration = duration;
        }

        @JsonProperty(value="allow_multiselect")
        public void setAllowMultiselect(Possible<Boolean> allowMultiselect) {
            this.allowMultiselect = allowMultiselect;
        }

        @JsonProperty(value="layout_type")
        public void setLayoutType(Possible<Integer> layoutType) {
            this.layoutType = layoutType;
        }

        @Override
        public Possible<PollMediaObject> question() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<PollAnswerObject>> answers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Integer> duration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> allowMultiselect() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Integer> layoutType() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build PollCreateData, attribute initializers form cycle " + attributes;
        }
    }
}

