/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AllowedMentionsData;
import discord4j.discordjson.json.ComponentData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.MessageCreateRequest;
import discord4j.discordjson.json.MessageReferenceData;
import discord4j.discordjson.json.MessageSendRequestBase;
import discord4j.discordjson.json.PollCreateData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableMessageCreateRequest
implements MessageCreateRequest {
    private final Integer flags_value;
    private final boolean flags_absent;
    private final String content_value;
    private final boolean content_absent;
    private final Boolean tts_value;
    private final boolean tts_absent;
    private final AllowedMentionsData allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final MessageReferenceData messageReference_value;
    private final boolean messageReference_absent;
    private final List<ComponentData> components_value;
    private final boolean components_absent;
    private final List<EmbedData> embeds_value;
    private final boolean embeds_absent;
    private final PollCreateData poll_value;
    private final boolean poll_absent;
    private final Object nonce_value;
    private final boolean nonce_absent;
    private final Boolean enforceNonce_value;
    private final boolean enforceNonce_absent;
    private final EmbedData embed_value;
    private final boolean embed_absent;
    private final List<Id> stickerIds_value;
    private final boolean stickerIds_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageCreateRequest(Possible<Integer> flags, Possible<String> content, Possible<Boolean> tts, Possible<AllowedMentionsData> allowedMentions, Possible<MessageReferenceData> messageReference, Possible<List<ComponentData>> components, Possible<List<EmbedData>> embeds, Possible<PollCreateData> poll, Possible<Object> nonce, Possible<Boolean> enforceNonce, Possible<EmbedData> embed, Possible<List<Id>> stickerIds) {
        Possible<Integer> flags$impl = flags;
        Possible<String> content$impl = content;
        Possible<Boolean> tts$impl = tts;
        Possible<AllowedMentionsData> allowedMentions$impl = allowedMentions;
        Possible<MessageReferenceData> messageReference$impl = messageReference;
        Possible<List<ComponentData>> components$impl = components;
        Possible<List<EmbedData>> embeds$impl = embeds;
        Possible<PollCreateData> poll$impl = poll;
        Possible<Object> nonce$impl = nonce;
        Possible<Boolean> enforceNonce$impl = enforceNonce;
        Possible<EmbedData> embed$impl = embed;
        Possible<List<Id>> stickerIds$impl = stickerIds;
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.poll_value = poll$impl.toOptional().orElse(null);
        this.poll_absent = poll$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.enforceNonce_value = enforceNonce$impl.toOptional().orElse(null);
        this.enforceNonce_absent = enforceNonce$impl.isAbsent();
        this.embed_value = embed$impl.toOptional().orElse(null);
        this.embed_absent = embed$impl.isAbsent();
        this.stickerIds_value = stickerIds$impl.toOptional().orElse(null);
        this.stickerIds_absent = stickerIds$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableMessageCreateRequest(ImmutableMessageCreateRequest original, Possible<Integer> flags, Possible<String> content, Possible<Boolean> tts, Possible<AllowedMentionsData> allowedMentions, Possible<MessageReferenceData> messageReference, Possible<List<ComponentData>> components, Possible<List<EmbedData>> embeds, Possible<PollCreateData> poll, Possible<Object> nonce, Possible<Boolean> enforceNonce, Possible<EmbedData> embed, Possible<List<Id>> stickerIds) {
        Possible<Integer> flags$impl = flags;
        Possible<String> content$impl = content;
        Possible<Boolean> tts$impl = tts;
        Possible<AllowedMentionsData> allowedMentions$impl = allowedMentions;
        Possible<MessageReferenceData> messageReference$impl = messageReference;
        Possible<List<ComponentData>> components$impl = components;
        Possible<List<EmbedData>> embeds$impl = embeds;
        Possible<PollCreateData> poll$impl = poll;
        Possible<Object> nonce$impl = nonce;
        Possible<Boolean> enforceNonce$impl = enforceNonce;
        Possible<EmbedData> embed$impl = embed;
        Possible<List<Id>> stickerIds$impl = stickerIds;
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.poll_value = poll$impl.toOptional().orElse(null);
        this.poll_absent = poll$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.enforceNonce_value = enforceNonce$impl.toOptional().orElse(null);
        this.enforceNonce_absent = enforceNonce$impl.isAbsent();
        this.embed_value = embed$impl.toOptional().orElse(null);
        this.embed_absent = embed$impl.isAbsent();
        this.stickerIds_value = stickerIds$impl.toOptional().orElse(null);
        this.stickerIds_absent = stickerIds$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="flags")
    public Possible<Integer> flags() {
        return this.flags_absent ? Possible.absent() : Possible.of((Object)this.flags_value);
    }

    @Override
    @JsonProperty(value="content")
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of((Object)this.content_value);
    }

    @Override
    @JsonProperty(value="tts")
    public Possible<Boolean> tts() {
        return this.tts_absent ? Possible.absent() : Possible.of((Object)this.tts_value);
    }

    @Override
    @JsonProperty(value="allowed_mentions")
    public Possible<AllowedMentionsData> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of((Object)this.allowedMentions_value);
    }

    @Override
    @JsonProperty(value="message_reference")
    public Possible<MessageReferenceData> messageReference() {
        return this.messageReference_absent ? Possible.absent() : Possible.of((Object)this.messageReference_value);
    }

    @Override
    @JsonProperty(value="components")
    public Possible<List<ComponentData>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    @Override
    @JsonProperty(value="embeds")
    public Possible<List<EmbedData>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(this.embeds_value);
    }

    @Override
    @JsonProperty(value="poll")
    public Possible<PollCreateData> poll() {
        return this.poll_absent ? Possible.absent() : Possible.of((Object)this.poll_value);
    }

    @Override
    @JsonProperty(value="nonce")
    public Possible<Object> nonce() {
        return this.nonce_absent ? Possible.absent() : Possible.of((Object)this.nonce_value);
    }

    @Override
    @JsonProperty(value="enforce_nonce")
    public Possible<Boolean> enforceNonce() {
        return this.enforceNonce_absent ? Possible.absent() : Possible.of((Object)this.enforceNonce_value);
    }

    @Override
    @JsonProperty(value="embed")
    @Deprecated
    public Possible<EmbedData> embed() {
        return this.embed_absent ? Possible.absent() : Possible.of((Object)this.embed_value);
    }

    @Override
    @JsonProperty(value="sticker_ids")
    public Possible<List<Id>> stickerIds() {
        return this.stickerIds_absent ? Possible.absent() : Possible.of(this.stickerIds_value);
    }

    public ImmutableMessageCreateRequest withFlags(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageCreateRequest(this, newValue, this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withFlags(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageCreateRequest(this, (Possible<Integer>)newValue, this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageCreateRequest(this, this.flags(), newValue, this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withContent(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageCreateRequest(this, this.flags(), (Possible<String>)newValue, this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withTts(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), newValue, this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withTts(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), (Possible<Boolean>)newValue, this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withAllowedMentions(Possible<AllowedMentionsData> value) {
        Possible<AllowedMentionsData> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), newValue, this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withAllowedMentions(AllowedMentionsData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), (Possible<AllowedMentionsData>)newValue, this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withMessageReference(Possible<MessageReferenceData> value) {
        Possible<MessageReferenceData> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), newValue, this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withMessageReference(MessageReferenceData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), (Possible<MessageReferenceData>)newValue, this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withComponents(Possible<List<ComponentData>> possible) {
        Possible<List<ComponentData>> newValue = Objects.requireNonNull(possible);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), newValue, this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withComponents(Iterable<ComponentData> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), (Possible<List<ComponentData>>)newValue, this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    @SafeVarargs
    public final ImmutableMessageCreateRequest withComponents(ComponentData ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), (Possible<List<ComponentData>>)newValue, this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withEmbeds(Possible<List<EmbedData>> possible) {
        Possible<List<EmbedData>> newValue = Objects.requireNonNull(possible);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), newValue, this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withEmbeds(Iterable<EmbedData> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), (Possible<List<EmbedData>>)newValue, this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    @SafeVarargs
    public final ImmutableMessageCreateRequest withEmbeds(EmbedData ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), (Possible<List<EmbedData>>)newValue, this.poll(), this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withPoll(Possible<PollCreateData> value) {
        Possible<PollCreateData> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), newValue, this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withPoll(PollCreateData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), (Possible<PollCreateData>)newValue, this.nonce(), this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withNonce(Possible<Object> value) {
        Possible<Object> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), newValue, this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withNonce(Object value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), (Possible<Object>)newValue, this.enforceNonce(), this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withEnforceNonce(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), newValue, this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withEnforceNonce(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), (Possible<Boolean>)newValue, this.embed(), this.stickerIds());
    }

    public ImmutableMessageCreateRequest withEmbed(Possible<EmbedData> value) {
        Possible<EmbedData> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), newValue, this.stickerIds());
    }

    public ImmutableMessageCreateRequest withEmbed(EmbedData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), (Possible<EmbedData>)newValue, this.stickerIds());
    }

    public ImmutableMessageCreateRequest withStickerIds(Possible<List<Id>> possible) {
        Possible<List<Id>> newValue = Objects.requireNonNull(possible);
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), newValue);
    }

    public ImmutableMessageCreateRequest withStickerIds(Iterable<Id> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), (Possible<List<Id>>)newValue);
    }

    @SafeVarargs
    public final ImmutableMessageCreateRequest withStickerIds(Id ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableMessageCreateRequest(this, this.flags(), this.content(), this.tts(), this.allowedMentions(), this.messageReference(), this.components(), this.embeds(), this.poll(), this.nonce(), this.enforceNonce(), this.embed(), (Possible<List<Id>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageCreateRequest && this.equalTo(0, (ImmutableMessageCreateRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageCreateRequest another) {
        return this.flags().equals(another.flags()) && this.content().equals(another.content()) && this.tts().equals(another.tts()) && this.allowedMentions().equals(another.allowedMentions()) && this.messageReference().equals(another.messageReference()) && Objects.equals(this.components_value, another.components_value) && Objects.equals(this.embeds_value, another.embeds_value) && this.poll().equals(another.poll()) && this.nonce().equals(another.nonce()) && this.enforceNonce().equals(another.enforceNonce()) && this.embed().equals(another.embed()) && Objects.equals(this.stickerIds_value, another.stickerIds_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.flags().hashCode();
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + this.tts().hashCode();
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + this.messageReference().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        h += (h << 5) + Objects.hashCode(this.embeds_value);
        h += (h << 5) + this.poll().hashCode();
        h += (h << 5) + this.nonce().hashCode();
        h += (h << 5) + this.enforceNonce().hashCode();
        h += (h << 5) + this.embed().hashCode();
        h += (h << 5) + Objects.hashCode(this.stickerIds_value);
        return h;
    }

    public String toString() {
        return "MessageCreateRequest{flags=" + this.flags().toString() + ", content=" + this.content().toString() + ", tts=" + this.tts().toString() + ", allowedMentions=" + this.allowedMentions().toString() + ", messageReference=" + this.messageReference().toString() + ", components=" + Objects.toString(this.components_value) + ", embeds=" + Objects.toString(this.embeds_value) + ", poll=" + this.poll().toString() + ", nonce=" + this.nonce().toString() + ", enforceNonce=" + this.enforceNonce().toString() + ", embed=" + this.embed().toString() + ", stickerIds=" + Objects.toString(this.stickerIds_value) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMessageCreateRequest fromJson(Json json) {
        Builder builder = ImmutableMessageCreateRequest.builder();
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.tts != null) {
            builder.tts(json.tts);
        }
        if (json.allowedMentions != null) {
            builder.allowedMentions(json.allowedMentions);
        }
        if (json.messageReference != null) {
            builder.messageReference(json.messageReference);
        }
        if (json.components != null) {
            builder.components(json.components);
        }
        if (json.embeds != null) {
            builder.embeds(json.embeds);
        }
        if (json.poll != null) {
            builder.poll(json.poll);
        }
        if (json.nonce != null) {
            builder.nonce(json.nonce);
        }
        if (json.enforceNonce != null) {
            builder.enforceNonce(json.enforceNonce);
        }
        if (json.embed != null) {
            builder.embed(json.embed);
        }
        if (json.stickerIds != null) {
            builder.stickerIds(json.stickerIds);
        }
        return builder.build();
    }

    public static ImmutableMessageCreateRequest of(Possible<Integer> flags, Possible<String> content, Possible<Boolean> tts, Possible<AllowedMentionsData> allowedMentions, Possible<MessageReferenceData> messageReference, Possible<List<ComponentData>> components, Possible<List<EmbedData>> embeds, Possible<PollCreateData> poll, Possible<Object> nonce, Possible<Boolean> enforceNonce, Possible<EmbedData> embed, Possible<List<Id>> stickerIds) {
        return new ImmutableMessageCreateRequest(flags, content, tts, allowedMentions, messageReference, components, embeds, poll, nonce, enforceNonce, embed, stickerIds);
    }

    public static ImmutableMessageCreateRequest copyOf(MessageCreateRequest instance) {
        if (instance instanceof ImmutableMessageCreateRequest) {
            return (ImmutableMessageCreateRequest)instance;
        }
        return ImmutableMessageCreateRequest.builder().from(instance).build();
    }

    public boolean isFlagsPresent() {
        return !this.flags_absent;
    }

    public Integer flagsOrElse(Integer defaultValue) {
        return !this.flags_absent ? this.flags_value : defaultValue;
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isTtsPresent() {
        return !this.tts_absent;
    }

    public Boolean ttsOrElse(Boolean defaultValue) {
        return !this.tts_absent ? this.tts_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentionsData allowedMentionsOrElse(AllowedMentionsData defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isMessageReferencePresent() {
        return !this.messageReference_absent;
    }

    public MessageReferenceData messageReferenceOrElse(MessageReferenceData defaultValue) {
        return !this.messageReference_absent ? this.messageReference_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<ComponentData> componentsOrElse(List<ComponentData> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedData> embedsOrElse(List<EmbedData> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isPollPresent() {
        return !this.poll_absent;
    }

    public PollCreateData pollOrElse(PollCreateData defaultValue) {
        return !this.poll_absent ? this.poll_value : defaultValue;
    }

    public boolean isNoncePresent() {
        return !this.nonce_absent;
    }

    public Object nonceOrElse(Object defaultValue) {
        return !this.nonce_absent ? this.nonce_value : defaultValue;
    }

    public boolean isEnforceNoncePresent() {
        return !this.enforceNonce_absent;
    }

    public Boolean enforceNonceOrElse(Boolean defaultValue) {
        return !this.enforceNonce_absent ? this.enforceNonce_value : defaultValue;
    }

    public boolean isEmbedPresent() {
        return !this.embed_absent;
    }

    public EmbedData embedOrElse(EmbedData defaultValue) {
        return !this.embed_absent ? this.embed_value : defaultValue;
    }

    public boolean isStickerIdsPresent() {
        return !this.stickerIds_absent;
    }

    public List<Id> stickerIdsOrElse(List<Id> defaultValue) {
        return !this.stickerIds_absent ? this.stickerIds_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<Integer> flags_possible = Possible.absent();
        private Possible<String> content_possible = Possible.absent();
        private Possible<Boolean> tts_possible = Possible.absent();
        private Possible<AllowedMentionsData> allowedMentions_possible = Possible.absent();
        private Possible<MessageReferenceData> messageReference_possible = Possible.absent();
        private List<ComponentData> components_list = null;
        private List<EmbedData> embeds_list = null;
        private Possible<PollCreateData> poll_possible = Possible.absent();
        private Possible<Object> nonce_possible = Possible.absent();
        private Possible<Boolean> enforceNonce_possible = Possible.absent();
        private Possible<EmbedData> embed_possible = Possible.absent();
        private List<Id> stickerIds_list = null;

        private Builder() {
        }

        public final Builder from(MessageCreateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(MessageSendRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            MessageSendRequestBase instance;
            long bits = 0L;
            if (object instanceof MessageCreateRequest) {
                instance = (MessageCreateRequest)object;
                if ((bits & 1L) == 0L) {
                    this.messageReference(instance.messageReference());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.components(instance.components());
                    bits |= 2L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.tts(instance.tts());
                    bits |= 0x40L;
                }
                this.stickerIds(instance.stickerIds());
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.poll(instance.poll());
                    bits |= 8L;
                }
                this.embed(instance.embed());
                this.enforceNonce(instance.enforceNonce());
                this.nonce(instance.nonce());
                if ((bits & 0x80L) == 0L) {
                    this.embeds(instance.embeds());
                    bits |= 0x80L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.content(instance.content());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.allowedMentions(instance.allowedMentions());
                    bits |= 0x20L;
                }
            }
            if (object instanceof MessageSendRequestBase) {
                instance = (MessageSendRequestBase)object;
                if ((bits & 1L) == 0L) {
                    this.messageReference(instance.messageReference());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.components(instance.components());
                    bits |= 2L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.tts(instance.tts());
                    bits |= 0x40L;
                }
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.poll(instance.poll());
                    bits |= 8L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.embeds(instance.embeds());
                    bits |= 0x80L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.content(instance.content());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.allowedMentions(instance.allowedMentions());
                    bits |= 0x20L;
                }
            }
        }

        @JsonProperty(value="flags")
        public Builder flags(Possible<Integer> value) {
            this.flags_possible = value;
            return this;
        }

        public Builder flags(Integer value) {
            this.flags_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="content")
        public Builder content(Possible<String> value) {
            this.content_possible = value;
            return this;
        }

        public Builder content(String value) {
            this.content_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="tts")
        public Builder tts(Possible<Boolean> value) {
            this.tts_possible = value;
            return this;
        }

        public Builder tts(Boolean value) {
            this.tts_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="allowed_mentions")
        public Builder allowedMentions(Possible<AllowedMentionsData> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        public Builder allowedMentions(AllowedMentionsData value) {
            this.allowedMentions_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="message_reference")
        public Builder messageReference(Possible<MessageReferenceData> value) {
            this.messageReference_possible = value;
            return this;
        }

        public Builder messageReference(MessageReferenceData value) {
            this.messageReference_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addComponent(ComponentData element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        public Builder addAllComponents(List<ComponentData> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="components")
        public Builder components(Possible<List<ComponentData>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<ComponentData>)e));
            return this;
        }

        public Builder components(List<ComponentData> elements) {
            this.components_list = new ArrayList<ComponentData>(elements);
            return this;
        }

        public Builder components(Iterable<ComponentData> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public Builder addEmbed(EmbedData element) {
            this.embeds_getOrCreate().add(element);
            return this;
        }

        public Builder addAllEmbeds(List<EmbedData> elements) {
            this.embeds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="embeds")
        public Builder embeds(Possible<List<EmbedData>> elements) {
            this.embeds_list = null;
            elements.toOptional().ifPresent(e -> this.embeds_getOrCreate().addAll((Collection<EmbedData>)e));
            return this;
        }

        public Builder embeds(List<EmbedData> elements) {
            this.embeds_list = new ArrayList<EmbedData>(elements);
            return this;
        }

        public Builder embeds(Iterable<EmbedData> elements) {
            this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="poll")
        public Builder poll(Possible<PollCreateData> value) {
            this.poll_possible = value;
            return this;
        }

        public Builder poll(PollCreateData value) {
            this.poll_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="nonce")
        public Builder nonce(Possible<Object> value) {
            this.nonce_possible = value;
            return this;
        }

        public Builder nonce(Object value) {
            this.nonce_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="enforce_nonce")
        public Builder enforceNonce(Possible<Boolean> value) {
            this.enforceNonce_possible = value;
            return this;
        }

        public Builder enforceNonce(Boolean value) {
            this.enforceNonce_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="embed")
        public Builder embed(Possible<EmbedData> value) {
            this.embed_possible = value;
            return this;
        }

        public Builder embed(EmbedData value) {
            this.embed_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addStickerId(Id element) {
            this.stickerIds_getOrCreate().add(element);
            return this;
        }

        public Builder addAllStickerIds(List<Id> elements) {
            this.stickerIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="sticker_ids")
        public Builder stickerIds(Possible<List<Id>> elements) {
            this.stickerIds_list = null;
            elements.toOptional().ifPresent(e -> this.stickerIds_getOrCreate().addAll((Collection<Id>)e));
            return this;
        }

        public Builder stickerIds(List<Id> elements) {
            this.stickerIds_list = new ArrayList<Id>(elements);
            return this;
        }

        public Builder stickerIds(Iterable<Id> elements) {
            this.stickerIds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public ImmutableMessageCreateRequest build() {
            return new ImmutableMessageCreateRequest(null, this.flags_build(), this.content_build(), this.tts_build(), this.allowedMentions_build(), this.messageReference_build(), this.components_build(), this.embeds_build(), this.poll_build(), this.nonce_build(), this.enforceNonce_build(), this.embed_build(), this.stickerIds_build());
        }

        private Possible<Integer> flags_build() {
            return this.flags_possible;
        }

        private Possible<String> content_build() {
            return this.content_possible;
        }

        private Possible<Boolean> tts_build() {
            return this.tts_possible;
        }

        private Possible<AllowedMentionsData> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<MessageReferenceData> messageReference_build() {
            return this.messageReference_possible;
        }

        private Possible<List<ComponentData>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<ComponentData> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<ComponentData>();
            }
            return this.components_list;
        }

        private Possible<List<EmbedData>> embeds_build() {
            return this.embeds_list == null ? Possible.absent() : Possible.of(this.embeds_list);
        }

        private List<EmbedData> embeds_getOrCreate() {
            if (this.embeds_list == null) {
                this.embeds_list = new ArrayList<EmbedData>();
            }
            return this.embeds_list;
        }

        private Possible<PollCreateData> poll_build() {
            return this.poll_possible;
        }

        private Possible<Object> nonce_build() {
            return this.nonce_possible;
        }

        private Possible<Boolean> enforceNonce_build() {
            return this.enforceNonce_possible;
        }

        private Possible<EmbedData> embed_build() {
            return this.embed_possible;
        }

        private Possible<List<Id>> stickerIds_build() {
            return this.stickerIds_list == null ? Possible.absent() : Possible.of(this.stickerIds_list);
        }

        private List<Id> stickerIds_getOrCreate() {
            if (this.stickerIds_list == null) {
                this.stickerIds_list = new ArrayList<Id>();
            }
            return this.stickerIds_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements MessageCreateRequest {
        Possible<Integer> flags = Possible.absent();
        Possible<String> content = Possible.absent();
        Possible<Boolean> tts = Possible.absent();
        Possible<AllowedMentionsData> allowedMentions = Possible.absent();
        Possible<MessageReferenceData> messageReference = Possible.absent();
        Possible<List<ComponentData>> components = Possible.absent();
        Possible<List<EmbedData>> embeds = Possible.absent();
        Possible<PollCreateData> poll = Possible.absent();
        Possible<Object> nonce = Possible.absent();
        Possible<Boolean> enforceNonce = Possible.absent();
        Possible<EmbedData> embed = Possible.absent();
        Possible<List<Id>> stickerIds = Possible.absent();

        Json() {
        }

        @JsonProperty(value="flags")
        public void setFlags(Possible<Integer> flags) {
            this.flags = flags;
        }

        @JsonProperty(value="content")
        public void setContent(Possible<String> content) {
            this.content = content;
        }

        @JsonProperty(value="tts")
        public void setTts(Possible<Boolean> tts) {
            this.tts = tts;
        }

        @JsonProperty(value="allowed_mentions")
        public void setAllowedMentions(Possible<AllowedMentionsData> allowedMentions) {
            this.allowedMentions = allowedMentions;
        }

        @JsonProperty(value="message_reference")
        public void setMessageReference(Possible<MessageReferenceData> messageReference) {
            this.messageReference = messageReference;
        }

        @JsonProperty(value="components")
        public void setComponents(Possible<List<ComponentData>> components) {
            this.components = components;
        }

        @JsonProperty(value="embeds")
        public void setEmbeds(Possible<List<EmbedData>> embeds) {
            this.embeds = embeds;
        }

        @JsonProperty(value="poll")
        public void setPoll(Possible<PollCreateData> poll) {
            this.poll = poll;
        }

        @JsonProperty(value="nonce")
        public void setNonce(Possible<Object> nonce) {
            this.nonce = nonce;
        }

        @JsonProperty(value="enforce_nonce")
        public void setEnforceNonce(Possible<Boolean> enforceNonce) {
            this.enforceNonce = enforceNonce;
        }

        @JsonProperty(value="embed")
        public void setEmbed(Possible<EmbedData> embed) {
            this.embed = embed;
        }

        @JsonProperty(value="sticker_ids")
        public void setStickerIds(Possible<List<Id>> stickerIds) {
            this.stickerIds = stickerIds;
        }

        @Override
        public Possible<Integer> flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> content() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> tts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<AllowedMentionsData> allowedMentions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<MessageReferenceData> messageReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<ComponentData>> components() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<EmbedData>> embeds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<PollCreateData> poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Object> nonce() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> enforceNonce() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<EmbedData> embed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<Id>> stickerIds() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build MessageCreateRequest, attribute initializers form cycle " + attributes;
        }
    }
}

